/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.IncludedIn;
import com.google.gerrit.server.project.CommitResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.revwalk.RevCommit;

@Singleton
class CommitIncludedIn
implements RestReadView<CommitResource> {
    private IncludedIn includedIn;

    @Inject
    CommitIncludedIn(IncludedIn includedIn) {
        this.includedIn = includedIn;
    }

    public IncludedInInfo apply(CommitResource rsrc) throws RestApiException, OrmException, IOException {
        RevCommit commit = rsrc.getCommit();
        Project.NameKey project = rsrc.getProject().getProject().getNameKey();
        return this.includedIn.apply(project, commit.getId().getName());
    }
}

