/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.data.SubscribeSection;
import com.google.gerrit.extensions.api.projects.CommentLinkInfo;
import com.google.gerrit.extensions.api.projects.ThemeInfo;
import com.google.gerrit.extensions.client.InheritableBoolean;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.rules.PrologEnvironment;
import com.google.gerrit.rules.RulesCache;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityCollection;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.BranchOrderSection;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.ProjectLevelConfig;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.project.CommentLinkInfoImpl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectHierarchyIterator;
import com.google.gerrit.server.project.SectionMatcher;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.googlecode.prolog_cafe.exceptions.CompileException;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectState {
    private static final Logger log = LoggerFactory.getLogger(ProjectState.class);
    private final boolean isAllProjects;
    private final boolean isAllUsers;
    private final SitePaths sitePaths;
    private final AllProjectsName allProjectsName;
    private final ProjectCache projectCache;
    private final ProjectControl.AssistedFactory projectControlFactory;
    private final PrologEnvironment.Factory envFactory;
    private final GitRepositoryManager gitMgr;
    private final RulesCache rulesCache;
    private final List<CommentLinkInfo> commentLinks;
    private final ProjectConfig config;
    private final Map<String, ProjectLevelConfig> configs;
    private final Set<AccountGroup.UUID> localOwners;
    private final long globalMaxObjectSizeLimit;
    private final boolean inheritProjectMaxObjectSizeLimit;
    private volatile PrologMachineCopy rulesMachine;
    private volatile long lastCheckGeneration;
    private volatile List<SectionMatcher> localAccessSections;
    private volatile ThemeInfo theme;
    private final CapabilityCollection capabilities;
    private static final String MAY_NOT_SET = "This project may not set a higher limit.";
    @VisibleForTesting
    public static final String INHERITED_FROM_PARENT = "Inherited from parent project '%s'.";
    @VisibleForTesting
    public static final String OVERRIDDEN_BY_PARENT = "Overridden by parent project '%s'. This project may not set a higher limit.";
    @VisibleForTesting
    public static final String INHERITED_FROM_GLOBAL = "Inherited from the global config.";
    @VisibleForTesting
    public static final String OVERRIDDEN_BY_GLOBAL = "Overridden by the global config. This project may not set a higher limit.";

    @Inject
    public ProjectState(SitePaths sitePaths, ProjectCache projectCache, AllProjectsName allProjectsName, AllUsersName allUsersName, ProjectControl.AssistedFactory projectControlFactory, PrologEnvironment.Factory envFactory, GitRepositoryManager gitMgr, RulesCache rulesCache, List<CommentLinkInfo> commentLinks, CapabilityCollection.Factory capabilityFactory, TransferConfig transferConfig, @Assisted ProjectConfig config) {
        this.sitePaths = sitePaths;
        this.projectCache = projectCache;
        this.isAllProjects = config.getProject().getNameKey().equals(allProjectsName);
        this.isAllUsers = config.getProject().getNameKey().equals(allUsersName);
        this.allProjectsName = allProjectsName;
        this.projectControlFactory = projectControlFactory;
        this.envFactory = envFactory;
        this.gitMgr = gitMgr;
        this.rulesCache = rulesCache;
        this.commentLinks = commentLinks;
        this.config = config;
        this.configs = new HashMap<String, ProjectLevelConfig>();
        this.capabilities = this.isAllProjects ? capabilityFactory.create(config.getAccessSection("GLOBAL_CAPABILITIES")) : null;
        this.globalMaxObjectSizeLimit = transferConfig.getMaxObjectSizeLimit();
        this.inheritProjectMaxObjectSizeLimit = transferConfig.getInheritProjectMaxObjectSizeLimit();
        if (this.isAllProjects && !Permission.canBeOnAllProjects("refs/*", "owner")) {
            this.localOwners = Collections.emptySet();
        } else {
            Permission owner;
            HashSet<AccountGroup.UUID> groups = new HashSet<AccountGroup.UUID>();
            AccessSection all = config.getAccessSection("refs/*");
            if (all != null && (owner = all.getPermission("owner")) != null) {
                for (PermissionRule rule : owner.getRules()) {
                    GroupReference ref = rule.getGroup();
                    if (rule.getAction() != PermissionRule.Action.ALLOW || ref.getUUID() == null) continue;
                    groups.add(ref.getUUID());
                }
            }
            this.localOwners = Collections.unmodifiableSet(groups);
        }
    }

    void initLastCheck(long generation) {
        this.lastCheckGeneration = generation;
    }

    boolean needsRefresh(long generation) {
        if (generation <= 0L) {
            return this.isRevisionOutOfDate();
        }
        if (this.lastCheckGeneration != generation) {
            this.lastCheckGeneration = generation;
            return this.isRevisionOutOfDate();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isRevisionOutOfDate() {
        try (Repository git = this.gitMgr.openRepository(this.getProject().getNameKey());){
            Ref ref = git.getRefDatabase().exactRef("refs/meta/config");
            if (ref == null || ref.getObjectId() == null) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = !ref.getObjectId().equals(this.config.getRevision());
            return bl;
        }
        catch (IOException gone) {
            return true;
        }
    }

    public CapabilityCollection getCapabilityCollection() {
        return this.capabilities;
    }

    public PrologEnvironment newPrologEnvironment() throws CompileException {
        PrologMachineCopy pmc = this.rulesMachine;
        if (pmc == null) {
            this.rulesMachine = pmc = this.rulesCache.loadMachine(this.getProject().getNameKey(), this.config.getRulesId());
        }
        return this.envFactory.create(pmc);
    }

    public PrologEnvironment newPrologEnvironment(String name, Reader in) throws CompileException {
        PrologMachineCopy pmc = this.rulesCache.loadMachine(name, in);
        return this.envFactory.create(pmc);
    }

    public Project getProject() {
        return this.config.getProject();
    }

    public ProjectConfig getConfig() {
        return this.config;
    }

    public ProjectLevelConfig getConfig(String fileName) {
        if (this.configs.containsKey(fileName)) {
            return this.configs.get(fileName);
        }
        ProjectLevelConfig cfg = new ProjectLevelConfig(fileName, this);
        try (Repository git = this.gitMgr.openRepository(this.getProject().getNameKey());){
            cfg.load(git);
        }
        catch (IOException | ConfigInvalidException e) {
            log.warn("Failed to load " + fileName + " for " + this.getProject().getName(), e);
        }
        this.configs.put(fileName, cfg);
        return cfg;
    }

    public EffectiveMaxObjectSizeLimit getEffectiveMaxObjectSizeLimit() {
        EffectiveMaxObjectSizeLimit result = new EffectiveMaxObjectSizeLimit();
        result.value = this.config.getMaxObjectSizeLimit();
        if (this.inheritProjectMaxObjectSizeLimit) {
            for (ProjectState parent : this.parents()) {
                long parentValue = parent.config.getMaxObjectSizeLimit();
                if (parentValue > 0L && result.value > 0L) {
                    if (parentValue >= result.value) continue;
                    result.value = parentValue;
                    result.summary = String.format(OVERRIDDEN_BY_PARENT, parent.config.getName());
                    continue;
                }
                if (parentValue <= 0L) continue;
                result.value = parentValue;
                result.summary = String.format(INHERITED_FROM_PARENT, parent.config.getName());
            }
        }
        if (this.globalMaxObjectSizeLimit > 0L && result.value > 0L) {
            if (this.globalMaxObjectSizeLimit < result.value) {
                result.value = this.globalMaxObjectSizeLimit;
                result.summary = OVERRIDDEN_BY_GLOBAL;
            }
        } else if (this.globalMaxObjectSizeLimit > result.value) {
            result.value = this.globalMaxObjectSizeLimit;
            result.summary = INHERITED_FROM_GLOBAL;
        }
        return result;
    }

    List<SectionMatcher> getLocalAccessSections() {
        List<SectionMatcher> sm = this.localAccessSections;
        if (sm == null) {
            Collection<AccessSection> fromConfig = this.config.getAccessSections();
            sm = new ArrayList<SectionMatcher>(fromConfig.size());
            for (AccessSection section : fromConfig) {
                SectionMatcher matcher;
                if (this.isAllProjects) {
                    ArrayList<Permission> copy = Lists.newArrayListWithCapacity(section.getPermissions().size());
                    for (Permission p : section.getPermissions()) {
                        if (!Permission.canBeOnAllProjects(section.getName(), p.getName())) continue;
                        copy.add(p);
                    }
                    section = new AccessSection(section.getName());
                    section.setPermissions(copy);
                }
                if ((matcher = SectionMatcher.wrap(this.getProject().getNameKey(), section)) == null) continue;
                sm.add(matcher);
            }
            this.localAccessSections = sm;
        }
        return sm;
    }

    List<SectionMatcher> getAllSections() {
        if (this.isAllProjects) {
            return this.getLocalAccessSections();
        }
        ArrayList<SectionMatcher> all = new ArrayList<SectionMatcher>();
        for (ProjectState s : this.tree()) {
            all.addAll(s.getLocalAccessSections());
        }
        return all;
    }

    public Set<AccountGroup.UUID> getOwners() {
        for (ProjectState p : this.tree()) {
            if (p.localOwners.isEmpty()) continue;
            return p.localOwners;
        }
        return Collections.emptySet();
    }

    public Set<AccountGroup.UUID> getAllOwners() {
        HashSet<AccountGroup.UUID> result = new HashSet<AccountGroup.UUID>();
        for (ProjectState p : this.tree()) {
            result.addAll(p.localOwners);
        }
        return result;
    }

    public ProjectControl controlFor(CurrentUser user) {
        return this.projectControlFactory.create(user, this);
    }

    public Iterable<ProjectState> tree() {
        return new Iterable<ProjectState>(){

            @Override
            public Iterator<ProjectState> iterator() {
                return new ProjectHierarchyIterator(ProjectState.this.projectCache, ProjectState.this.allProjectsName, ProjectState.this);
            }
        };
    }

    public Iterable<ProjectState> treeInOrder() {
        ArrayList<ProjectState> projects = Lists.newArrayList(this.tree());
        Collections.reverse(projects);
        return projects;
    }

    public FluentIterable<ProjectState> parents() {
        return FluentIterable.from(this.tree()).skip(1);
    }

    public boolean isAllProjects() {
        return this.isAllProjects;
    }

    public boolean isAllUsers() {
        return this.isAllUsers;
    }

    public boolean isUseContributorAgreements() {
        return this.getInheritableBoolean(Project::getUseContributorAgreements);
    }

    public boolean isUseContentMerge() {
        return this.getInheritableBoolean(Project::getUseContentMerge);
    }

    public boolean isUseSignedOffBy() {
        return this.getInheritableBoolean(Project::getUseSignedOffBy);
    }

    public boolean isRequireChangeID() {
        return this.getInheritableBoolean(Project::getRequireChangeID);
    }

    public boolean isCreateNewChangeForAllNotInTarget() {
        return this.getInheritableBoolean(Project::getCreateNewChangeForAllNotInTarget);
    }

    public boolean isEnableSignedPush() {
        return this.getInheritableBoolean(Project::getEnableSignedPush);
    }

    public boolean isRequireSignedPush() {
        return this.getInheritableBoolean(Project::getRequireSignedPush);
    }

    public boolean isRejectImplicitMerges() {
        return this.getInheritableBoolean(Project::getRejectImplicitMerges);
    }

    public LabelTypes getLabelTypes() {
        LinkedHashMap<String, LabelType> types = new LinkedHashMap<String, LabelType>();
        for (ProjectState s : this.treeInOrder()) {
            for (LabelType type : s.getConfig().getLabelSections().values()) {
                String lower = type.getName().toLowerCase();
                LabelType old = (LabelType)types.get(lower);
                if (old != null && !old.canOverride()) continue;
                types.put(lower, type);
            }
        }
        ArrayList<LabelType> all = Lists.newArrayListWithCapacity(types.size());
        for (LabelType type : types.values()) {
            if (type.getValues().isEmpty()) continue;
            all.add(type);
        }
        return new LabelTypes(Collections.unmodifiableList(all));
    }

    public List<CommentLinkInfo> getCommentLinks() {
        LinkedHashMap<String, CommentLinkInfo> cls = new LinkedHashMap<String, CommentLinkInfo>();
        for (CommentLinkInfo cl : this.commentLinks) {
            cls.put(cl.name.toLowerCase(), cl);
        }
        for (ProjectState s : this.treeInOrder()) {
            for (CommentLinkInfoImpl cl : s.getConfig().getCommentLinkSections()) {
                String name = cl.name.toLowerCase();
                if (cl.isOverrideOnly()) {
                    CommentLinkInfo parent = (CommentLinkInfo)cls.get(name);
                    if (parent == null) continue;
                    cls.put(name, cl.inherit(parent));
                    continue;
                }
                cls.put(name, cl);
            }
        }
        return ImmutableList.copyOf(cls.values());
    }

    public BranchOrderSection getBranchOrderSection() {
        for (ProjectState s : this.tree()) {
            BranchOrderSection section = s.getConfig().getBranchOrderSection();
            if (section == null) continue;
            return section;
        }
        return null;
    }

    public Collection<SubscribeSection> getSubscribeSections(Branch.NameKey branch) {
        ArrayList<SubscribeSection> ret = new ArrayList<SubscribeSection>();
        for (ProjectState s : this.tree()) {
            ret.addAll(s.getConfig().getSubscribeSections(branch));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeInfo getTheme() {
        ThemeInfo theme = this.theme;
        if (theme == null) {
            ProjectState projectState = this;
            synchronized (projectState) {
                theme = this.theme;
                if (theme == null) {
                    this.theme = theme = this.loadTheme();
                }
            }
        }
        if (theme == ThemeInfo.INHERIT) {
            ProjectState parent = Iterables.getFirst(this.parents(), null);
            return parent != null ? parent.getTheme() : null;
        }
        return theme;
    }

    private ThemeInfo loadTheme() {
        String name = this.getConfig().getProject().getName();
        Path dir = this.sitePaths.themes_dir.resolve(name);
        if (!Files.exists(dir, new LinkOption[0])) {
            return ThemeInfo.INHERIT;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            log.warn("Bad theme for {}: not a directory", (Object)name);
            return ThemeInfo.INHERIT;
        }
        try {
            return new ThemeInfo(this.readFile(dir.resolve("GerritSite.css")), this.readFile(dir.resolve("GerritSiteHeader.html")), this.readFile(dir.resolve("GerritSiteFooter.html")));
        }
        catch (IOException e) {
            log.error("Error reading theme for " + name, e);
            return ThemeInfo.INHERIT;
        }
    }

    private String readFile(Path p) throws IOException {
        return Files.exists(p, new LinkOption[0]) ? new String(Files.readAllBytes(p), StandardCharsets.UTF_8) : null;
    }

    private boolean getInheritableBoolean(Function<Project, InheritableBoolean> func) {
        for (ProjectState s : this.tree()) {
            switch (func.apply(s.getProject())) {
                case TRUE: {
                    return true;
                }
                case FALSE: {
                    return false;
                }
            }
        }
        return false;
    }

    public static class EffectiveMaxObjectSizeLimit {
        public long value;
        public String summary;
    }

    public static interface Factory {
        public ProjectState create(ProjectConfig var1);
    }
}

