/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query;

import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParser;
import java.util.Collection;

public abstract class OperatorPredicate<T>
extends Predicate<T> {
    private final String name;
    private final String value;

    protected OperatorPredicate(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getOperator() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Predicate<T> copy(Collection<? extends Predicate<T>> children) {
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("Expected 0 children");
        }
        return this;
    }

    @Override
    public int hashCode() {
        return this.getOperator().hashCode() * 31 + this.getValue().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() == other.getClass()) {
            OperatorPredicate p = (OperatorPredicate)other;
            return this.getOperator().equals(p.getOperator()) && this.getValue().equals(p.getValue());
        }
        return false;
    }

    public String toString() {
        String val = this.getValue();
        if (QueryParser.isSingleWord(val)) {
            return this.getOperator() + ":" + val;
        }
        return this.getOperator() + ":\"" + val + "\"";
    }
}

