/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.server.ChangeAccess;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.reviewdb.server.ReviewDbWrapper;
import com.google.gwtorm.server.AtomicUpdate;

public class BatchUpdateReviewDb
extends ReviewDbWrapper {
    private final ChangeAccess changesWrapper;

    BatchUpdateReviewDb(ReviewDb delegate) {
        super(delegate);
        this.changesWrapper = new BatchUpdateChanges(delegate.changes());
    }

    public ReviewDb unsafeGetDelegate() {
        return this.delegate;
    }

    @Override
    public ChangeAccess changes() {
        return this.changesWrapper;
    }

    @Override
    public void commit() {
        throw new UnsupportedOperationException("do not call commit; BatchUpdate always manages transactions");
    }

    @Override
    public void rollback() {
        throw new UnsupportedOperationException("do not call rollback; BatchUpdate always manages transactions");
    }

    private static class BatchUpdateChanges
    extends ReviewDbWrapper.ChangeAccessWrapper {
        private BatchUpdateChanges(ChangeAccess delegate) {
            super(delegate);
        }

        @Override
        public void insert(Iterable<Change> instances) {
            throw new UnsupportedOperationException("do not call insert; change is automatically inserted");
        }

        @Override
        public void upsert(Iterable<Change> instances) {
            throw new UnsupportedOperationException("do not call upsert; existing changes are updated automatically, or use InsertChangeOp for insertion");
        }

        @Override
        public void update(Iterable<Change> instances) {
            throw new UnsupportedOperationException("do not call update; change is updated automatically");
        }

        @Override
        public void beginTransaction(Change.Id key) {
            throw new UnsupportedOperationException("updateChange is always called within a transaction");
        }

        @Override
        public void deleteKeys(Iterable<Change.Id> keys) {
            throw new UnsupportedOperationException("do not call deleteKeys; use ChangeContext#deleteChange()");
        }

        @Override
        public void delete(Iterable<Change> instances) {
            throw new UnsupportedOperationException("do not call delete; use ChangeContext#deleteChange()");
        }

        @Override
        public Change atomicUpdate(Change.Id key, AtomicUpdate<Change> update) {
            throw new UnsupportedOperationException("do not call atomicUpdate; updateChange is always called within a transaction");
        }
    }
}

