/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.update;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.lib.BaseRepositoryBuilder;
import org.eclipse.jgit.lib.ObjectDatabase;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.RefRename;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.ReflogReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;

class ReadOnlyRepository
extends Repository {
    private static final String MSG = "Cannot modify a " + ReadOnlyRepository.class.getSimpleName();
    private final Repository delegate;
    private final RefDb refdb;
    private final ObjDb objdb;

    private static BaseRepositoryBuilder<?, ?> builder(Repository r) {
        Preconditions.checkNotNull(r);
        Object builder = ((BaseRepositoryBuilder)new BaseRepositoryBuilder().setFS(r.getFS())).setGitDir(r.getDirectory());
        if (!r.isBare()) {
            ((BaseRepositoryBuilder)((BaseRepositoryBuilder)builder).setWorkTree(r.getWorkTree())).setIndexFile(r.getIndexFile());
        }
        return builder;
    }

    ReadOnlyRepository(Repository delegate) {
        super(ReadOnlyRepository.builder(delegate));
        this.delegate = delegate;
        this.refdb = new RefDb(delegate.getRefDatabase());
        this.objdb = new ObjDb(delegate.getObjectDatabase());
    }

    @Override
    public void create(boolean bare) throws IOException {
        throw new UnsupportedOperationException(MSG);
    }

    @Override
    public ObjectDatabase getObjectDatabase() {
        return this.objdb;
    }

    @Override
    public RefDatabase getRefDatabase() {
        return this.refdb;
    }

    @Override
    public StoredConfig getConfig() {
        return this.delegate.getConfig();
    }

    @Override
    public AttributesNodeProvider createAttributesNodeProvider() {
        return this.delegate.createAttributesNodeProvider();
    }

    @Override
    public void scanForRepoChanges() throws IOException {
        this.delegate.scanForRepoChanges();
    }

    @Override
    public void notifyIndexChanged() {
        this.delegate.notifyIndexChanged();
    }

    @Override
    public ReflogReader getReflogReader(String refName) throws IOException {
        return this.delegate.getReflogReader(refName);
    }

    @Override
    public String getGitwebDescription() throws IOException {
        return this.delegate.getGitwebDescription();
    }

    private static class ObjDb
    extends ObjectDatabase {
        private final ObjectDatabase delegate;

        private ObjDb(ObjectDatabase delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        public ObjectInserter newInserter() {
            throw new UnsupportedOperationException(MSG);
        }

        @Override
        public ObjectReader newReader() {
            return this.delegate.newReader();
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    private static class RefDb
    extends RefDatabase {
        private final RefDatabase delegate;

        private RefDb(RefDatabase delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        public void create() throws IOException {
            throw new UnsupportedOperationException(MSG);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean isNameConflicting(String name) throws IOException {
            return this.delegate.isNameConflicting(name);
        }

        @Override
        public RefUpdate newUpdate(String name, boolean detach) throws IOException {
            throw new UnsupportedOperationException(MSG);
        }

        @Override
        public RefRename newRename(String fromName, String toName) throws IOException {
            throw new UnsupportedOperationException(MSG);
        }

        @Override
        public Ref getRef(String name) throws IOException {
            return this.delegate.getRef(name);
        }

        @Override
        public Map<String, Ref> getRefs(String prefix) throws IOException {
            return this.delegate.getRefs(prefix);
        }

        @Override
        public List<Ref> getAdditionalRefs() throws IOException {
            return this.delegate.getAdditionalRefs();
        }

        @Override
        public Ref peel(Ref ref) throws IOException {
            return this.delegate.peel(ref);
        }
    }
}

