/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import java.security.AccessController;
import java.security.PrivilegedAction;

public final class HostPlatform {
    private static final boolean win32 = HostPlatform.compute("windows");
    private static final boolean mac = HostPlatform.compute("mac");

    public static boolean isWin32() {
        return win32;
    }

    public static boolean isMac() {
        return mac;
    }

    private static boolean compute(String platform) {
        String osDotName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        return osDotName != null && osDotName.toLowerCase().contains(platform);
    }

    private HostPlatform() {
    }
}

