/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Chars;
import dk.brics.automaton.Automaton;
import dk.brics.automaton.RegExp;
import dk.brics.automaton.RunAutomaton;
import java.util.Collections;
import java.util.List;

public abstract class RegexListSearcher<T>
implements Function<T, String> {
    private final RunAutomaton pattern;
    private final String prefixBegin;
    private final String prefixEnd;
    private final int prefixLen;
    private final boolean prefixOnly;

    public static RegexListSearcher<String> ofStrings(String re) {
        return new RegexListSearcher<String>(re){

            @Override
            public String apply(String in) {
                return in;
            }
        };
    }

    public RegexListSearcher(String re) {
        if (re.startsWith("^")) {
            re = re.substring(1);
        }
        if (re.endsWith("$") && !re.endsWith("\\$")) {
            re = re.substring(0, re.length() - 1);
        }
        Automaton automaton = new RegExp(re).toAutomaton();
        this.prefixBegin = automaton.getCommonPrefix();
        this.prefixLen = this.prefixBegin.length();
        if (0 < this.prefixLen) {
            char max = Chars.checkedCast(this.prefixBegin.charAt(this.prefixLen - 1) + '\u0001');
            this.prefixEnd = this.prefixBegin.substring(0, this.prefixLen - 1) + max;
            this.prefixOnly = re.equals(this.prefixBegin + ".*");
        } else {
            this.prefixEnd = "";
            this.prefixOnly = false;
        }
        this.pattern = this.prefixOnly ? null : new RunAutomaton(automaton);
    }

    public Iterable<T> search(List<T> list) {
        int end;
        int begin;
        Preconditions.checkNotNull(list);
        if (0 < this.prefixLen) {
            begin = this.find(list, this.prefixBegin);
            end = this.find(list, this.prefixEnd);
        } else {
            begin = 0;
            end = list.size();
        }
        if (this.prefixOnly) {
            return begin < end ? list.subList(begin, end) : ImmutableList.of();
        }
        return Iterables.filter(list.subList(begin, end), x -> this.pattern.run((String)this.apply(x)));
    }

    public boolean hasMatch(List<T> list) {
        return !Iterables.isEmpty(this.search(list));
    }

    private int find(List<T> list, String p) {
        int r = Collections.binarySearch(Lists.transform(list, this), p);
        return r < 0 ? -(r + 1) : r;
    }
}

