/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.sshd.SshLog;
import com.google.gerrit.sshd.SshScope;
import com.google.gerrit.sshd.SshSession;
import com.google.gerrit.sshd.SshUtil;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Locale;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.session.ServerSession;
import org.eclipse.jgit.lib.Config;

@Singleton
class GerritGSSAuthenticator
extends GSSAuthenticator {
    private final AccountCache accounts;
    private final SshScope sshScope;
    private final SshLog sshLog;
    private final IdentifiedUser.GenericFactory userFactory;
    private final Config config;

    @Inject
    GerritGSSAuthenticator(AccountCache accounts, SshScope sshScope, SshLog sshLog, IdentifiedUser.GenericFactory userFactory, @GerritServerConfig Config config) {
        this.accounts = accounts;
        this.sshScope = sshScope;
        this.sshLog = sshLog;
        this.userFactory = userFactory;
        this.config = config;
    }

    @Override
    public boolean validateIdentity(ServerSession session, String identity) {
        boolean active;
        AccountState state;
        SshSession sd = session.getAttribute(SshSession.KEY);
        int at = identity.indexOf(64);
        String username = at == -1 ? identity : identity.substring(0, at);
        if (this.config.getBoolean("auth", "userNameToLowerCase", false)) {
            username = username.toLowerCase(Locale.US);
        }
        Account account = (state = this.accounts.getByUsername(username)) == null ? null : state.getAccount();
        boolean bl = active = account != null && account.isActive();
        if (active) {
            return SshUtil.success(username, session, this.sshScope, this.sshLog, sd, SshUtil.createUser(sd, this.userFactory, account.getId()));
        }
        return false;
    }
}

