/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GarbageCollectionResult;
import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.GarbageCollection;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

@RequiresAnyCapability(value={"runGC", "maintainServer"})
@CommandMetaData(name="gc", description="Run Git garbage collection", runsAt=CommandMetaData.Mode.MASTER_OR_SLAVE)
public class GarbageCollectionCommand
extends SshCommand {
    @Option(name="--all", usage="runs the Git garbage collection for all projects")
    private boolean all;
    @Option(name="--show-progress", usage="progress information is shown")
    private boolean showProgress;
    @Option(name="--aggressive", usage="run aggressive garbage collection")
    private boolean aggressive;
    @Argument(index=0, required=false, multiValued=true, metaVar="NAME", usage="projects for which the Git garbage collection should be run")
    private List<ProjectControl> projects = new ArrayList<ProjectControl>();
    @Inject
    private ProjectCache projectCache;
    @Inject
    private GarbageCollection.Factory garbageCollectionFactory;

    @Override
    public void run() throws Exception {
        this.verifyCommandLine();
        this.runGC();
    }

    private void verifyCommandLine() throws BaseCommand.UnloggedFailure {
        if (!this.all && this.projects.isEmpty()) {
            throw this.die("needs projects as command arguments or --all option");
        }
        if (this.all && !this.projects.isEmpty()) {
            throw this.die("either specify projects as command arguments or use --all option");
        }
    }

    private void runGC() {
        ArrayList<Project.NameKey> projectNames;
        if (this.all) {
            projectNames = Lists.newArrayList(this.projectCache.all());
        } else {
            projectNames = Lists.newArrayListWithCapacity(this.projects.size());
            for (ProjectControl pc : this.projects) {
                projectNames.add(pc.getProject().getNameKey());
            }
        }
        GarbageCollectionResult result = this.garbageCollectionFactory.create().run(projectNames, this.aggressive, this.showProgress ? this.stdout : null);
        if (result.hasErrors()) {
            for (GarbageCollectionResult.Error e : result.getErrors()) {
                String msg;
                switch (e.getType()) {
                    case REPOSITORY_NOT_FOUND: {
                        msg = "error: project \"" + e.getProjectName() + "\" not found";
                        break;
                    }
                    case GC_ALREADY_SCHEDULED: {
                        msg = "error: garbage collection for project \"" + e.getProjectName() + "\" was already scheduled";
                        break;
                    }
                    case GC_FAILED: {
                        msg = "error: garbage collection for project \"" + e.getProjectName() + "\" failed";
                        break;
                    }
                    default: {
                        msg = "error: garbage collection for project \"" + e.getProjectName() + "\" failed: " + (Object)((Object)e.getType());
                    }
                }
                this.stdout.print(msg + "\n");
            }
        }
    }
}

