/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtorm.nosql.generic;

import com.google.gwtorm.client.Key;
import com.google.gwtorm.nosql.IndexFunction;
import com.google.gwtorm.nosql.IndexKeyBuilder;
import com.google.gwtorm.nosql.IndexRow;
import com.google.gwtorm.nosql.NoSqlAccess;
import com.google.gwtorm.nosql.generic.CandidateRow;
import com.google.gwtorm.nosql.generic.GenericSchema;
import com.google.gwtorm.nosql.generic.Row;
import com.google.gwtorm.server.AbstractResultSet;
import com.google.gwtorm.server.AtomicUpdate;
import com.google.gwtorm.server.ListResultSet;
import com.google.gwtorm.server.OrmConcurrencyException;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.ResultSet;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class GenericAccess<T, K extends Key<?>>
extends NoSqlAccess<T, K> {
    private static final int MAX_SZ = 64;
    private final GenericSchema db;
    private LinkedHashMap<K, byte[]> cache;

    protected GenericAccess(GenericSchema s) {
        super(s);
        this.db = s;
    }

    protected LinkedHashMap<K, byte[]> cache() {
        if (this.cache == null) {
            this.cache = new LinkedHashMap<K, byte[]>(8){

                @Override
                protected boolean removeEldestEntry(Map.Entry<K, byte[]> entry) {
                    return 64 <= this.size();
                }
            };
        }
        return this.cache;
    }

    @Override
    public T get(K key) throws OrmException, OrmDuplicateKeyException {
        byte[] bin = this.db.fetchRow(this.dataRowKey(key));
        if (bin != null) {
            Object obj = this.getObjectCodec().decode(bin);
            this.cache().put(this.primaryKey(obj), bin);
            return obj;
        }
        return null;
    }

    @Override
    public ResultSet<T> get(final Iterable<K> keys) throws OrmException {
        final ResultSet<Row> rs = this.db.fetchRows(new Iterable<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                return new Iterator<byte[]>(){
                    private final Iterator<K> i;
                    {
                        this.i = keys.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public byte[] next() {
                        return GenericAccess.this.dataRowKey((Key)this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
        final Iterator<Row> i = rs.iterator();
        return new AbstractResultSet<T>(){

            @Override
            protected boolean hasNext() {
                return i.hasNext();
            }

            @Override
            protected T next() {
                byte[] bin = ((Row)i.next()).getValue();
                Object obj = GenericAccess.this.getObjectCodec().decode(bin);
                GenericAccess.this.cache().put(GenericAccess.this.primaryKey(obj), bin);
                return obj;
            }

            @Override
            public void close() {
                rs.close();
            }
        };
    }

    @Override
    protected ResultSet<T> scanPrimaryKey(byte[] fromKey, byte[] toKey, int limit, boolean order) throws OrmException {
        IndexKeyBuilder b = new IndexKeyBuilder();
        b.add(this.getRelationName());
        b.delimiter();
        b.addRaw(fromKey);
        fromKey = b.toByteArray();
        b = new IndexKeyBuilder();
        b.add(this.getRelationName());
        b.delimiter();
        b.addRaw(toKey);
        toKey = b.toByteArray();
        final ResultSet<Row> rs = this.db.scan(fromKey, toKey, limit, order);
        final Iterator<Row> i = rs.iterator();
        return new AbstractResultSet<T>(){

            @Override
            protected boolean hasNext() {
                return i.hasNext();
            }

            @Override
            protected T next() {
                byte[] bin = ((Row)i.next()).getValue();
                Object obj = GenericAccess.this.getObjectCodec().decode(bin);
                GenericAccess.this.cache().put(GenericAccess.this.primaryKey(obj), bin);
                return obj;
            }

            @Override
            public void close() {
                rs.close();
            }
        };
    }

    @Override
    protected ResultSet<T> scanIndex(IndexFunction<T> idx, byte[] fromKey, byte[] toKey, int limit, boolean order) throws OrmException {
        long now = System.currentTimeMillis();
        IndexKeyBuilder b = new IndexKeyBuilder();
        b.add(this.getRelationName());
        b.add('.');
        b.add(idx.getName());
        b.delimiter();
        b.addRaw(fromKey);
        fromKey = b.toByteArray();
        b = new IndexKeyBuilder();
        b.add(this.getRelationName());
        b.add('.');
        b.add(idx.getName());
        b.delimiter();
        b.addRaw(toKey);
        toKey = b.toByteArray();
        ArrayList res = new ArrayList();
        Object lastKey = fromKey;
        block0: while (true) {
            Object idxKey;
            ArrayList<CandidateRow> scanned = 0 < limit ? new ArrayList(limit) : new ArrayList<CandidateRow>();
            boolean needData = false;
            for (Row ent : this.db.scan((byte[])lastKey, toKey, limit, order)) {
                idxKey = ent.getKey();
                IndexRow indexRow = IndexRow.CODEC.decode(ent.getValue());
                CandidateRow row = new CandidateRow((byte[])idxKey, indexRow);
                scanned.add(row);
                needData |= !row.hasData();
                lastKey = idxKey;
            }
            if (needData) {
                HashMap<ByteString, CandidateRow> byKey = new HashMap<ByteString, CandidateRow>();
                ArrayList<byte[]> toFetch = new ArrayList<byte[]>(scanned.size());
                idxKey = scanned.iterator();
                while (idxKey.hasNext()) {
                    CandidateRow candidateRow = (CandidateRow)idxKey.next();
                    if (candidateRow.hasData()) continue;
                    IndexKeyBuilder pk = new IndexKeyBuilder();
                    pk.add(this.getRelationName());
                    pk.delimiter();
                    pk.addRaw(candidateRow.getDataKey());
                    byte[] key = pk.toByteArray();
                    byKey.put(ByteString.copyFrom(key), candidateRow);
                    toFetch.add(key);
                }
                for (Row row : this.db.fetchRows(toFetch)) {
                    CandidateRow idxRow2 = (CandidateRow)byKey.get(ByteString.copyFrom(row.getKey()));
                    if (idxRow2 == null) continue;
                    idxRow2.setData(row.getValue());
                }
                for (CandidateRow candidateRow : scanned) {
                    if (!candidateRow.hasData()) {
                        this.db.maybeFossilCollectIndexRow(now, candidateRow.getIndexKey(), candidateRow.getIndexRow());
                        continue;
                    }
                    byte[] bin = candidateRow.getData();
                    Object obj = this.getObjectCodec().decode(bin);
                    if (this.matches(idx, obj, candidateRow.getIndexKey())) {
                        this.cache().put(this.primaryKey(obj), bin);
                        res.add(obj);
                        if (limit <= 0 || res.size() != limit) continue;
                        break block0;
                    }
                    this.db.maybeFossilCollectIndexRow(now, candidateRow.getIndexKey(), candidateRow.getIndexRow());
                }
            } else {
                for (CandidateRow idxRow4 : scanned) {
                    byte[] bin = idxRow4.getData();
                    Object t = this.getObjectCodec().decode(bin);
                    this.cache().put(this.primaryKey(t), bin);
                    res.add(t);
                    if (limit <= 0 || res.size() != limit) continue;
                    break block0;
                }
            }
            if (limit == 0 || scanned.size() < limit) break;
            b = new IndexKeyBuilder();
            b.addRaw((byte[])lastKey);
            b.nul();
            lastKey = b.toByteArray();
        }
        return new ListResultSet(res);
    }

    @Override
    public void insert(Iterable<T> instances) throws OrmException {
        for (T obj : instances) {
            this.insertOne(obj);
        }
        this.db.flush();
    }

    private void insertOne(T nObj) throws OrmException {
        this.writeNewIndexes(null, nObj);
        byte[] key = this.dataRowKey(this.primaryKey(nObj));
        this.db.insert(key, this.getObjectCodec().encodeToByteString(nObj).toByteArray());
    }

    @Override
    public void update(Iterable<T> instances) throws OrmException {
        for (T obj : instances) {
            this.upsertOne(obj, true);
        }
        this.db.flush();
    }

    @Override
    public void upsert(Iterable<T> instances) throws OrmException {
        for (T obj : instances) {
            this.upsertOne(obj, false);
        }
        this.db.flush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void upsertOne(T newObj, boolean mustExist) throws OrmException {
        T oldObj;
        byte[] key = this.dataRowKey(this.primaryKey(newObj));
        byte[] oldBin = this.cache().get(this.primaryKey(newObj));
        if (oldBin != null) {
            oldObj = this.getObjectCodec().decode(oldBin);
        } else if (mustExist) {
            oldBin = this.db.fetchRow(key);
            if (oldBin == null) throw new OrmConcurrencyException();
            oldObj = this.getObjectCodec().decode(oldBin);
        } else {
            oldObj = null;
        }
        this.writeNewIndexes(oldObj, newObj);
        this.db.upsert(key, this.getObjectCodec().encodeToByteString(newObj).toByteArray());
        this.pruneOldIndexes(oldObj, newObj);
    }

    protected void writeNewIndexes(T oldObj, T newObj) throws OrmException {
        byte[] idxData = this.indexRowData(newObj);
        for (IndexFunction<T> f : this.getIndexes()) {
            if (!f.includes(newObj)) continue;
            byte[] idxKey = this.indexRowKey(f, newObj);
            if (oldObj != null && this.matches(f, oldObj, idxKey)) continue;
            this.db.upsert(idxKey, idxData);
        }
    }

    protected void pruneOldIndexes(T oldObj, T newObj) throws OrmException {
        if (oldObj != null) {
            for (IndexFunction<T> f : this.getIndexes()) {
                if (!f.includes(oldObj)) continue;
                byte[] idxKey = this.indexRowKey(f, oldObj);
                if (newObj != null && this.matches(f, newObj, idxKey)) continue;
                this.db.delete(idxKey);
            }
        }
    }

    @Override
    public void delete(Iterable<T> instances) throws OrmException {
        for (T oldObj : instances) {
            this.db.delete(this.dataRowKey(this.primaryKey(oldObj)));
            this.pruneOldIndexes(oldObj, null);
            this.cache().remove(this.primaryKey(oldObj));
        }
        this.db.flush();
    }

    @Override
    public T atomicUpdate(K key, final AtomicUpdate<T> update) throws OrmException {
        IndexKeyBuilder b = new IndexKeyBuilder();
        b.add(this.getRelationName());
        b.delimiter();
        this.encodePrimaryKey(b, key);
        try {
            final Object[] res = new Object[3];
            this.db.atomicUpdate(b.toByteArray(), new AtomicUpdate<byte[]>(){

                @Override
                public byte[] update(byte[] data) {
                    if (data != null) {
                        Object oldObj = GenericAccess.this.getObjectCodec().decode(data);
                        Object newObj = GenericAccess.this.getObjectCodec().decode(data);
                        res[0] = update.update(newObj);
                        res[1] = oldObj;
                        res[2] = newObj;
                        try {
                            GenericAccess.this.writeNewIndexes(oldObj, newObj);
                        }
                        catch (OrmException err) {
                            throw new IndexException(err);
                        }
                        return GenericAccess.this.getObjectCodec().encodeToByteString(newObj).toByteArray();
                    }
                    res[0] = null;
                    return null;
                }
            });
            if (res[0] != null) {
                this.pruneOldIndexes(res[1], res[2]);
            }
            return (T)res[0];
        }
        catch (IndexException err) {
            throw err.cause;
        }
    }

    protected boolean matches(IndexFunction<T> f, T obj, byte[] exp) {
        return f.includes(obj) && Arrays.equals(exp, this.indexRowKey(f, obj));
    }

    protected byte[] dataRowKey(K key) {
        IndexKeyBuilder b = new IndexKeyBuilder();
        b.add(this.getRelationName());
        b.delimiter();
        this.encodePrimaryKey(b, key);
        return b.toByteArray();
    }

    protected byte[] indexRowKey(IndexFunction<T> idx, T obj) {
        IndexKeyBuilder b = new IndexKeyBuilder();
        b.add(this.getRelationName());
        b.add('.');
        b.add(idx.getName());
        b.delimiter();
        idx.encode(b, obj);
        b.delimiter();
        this.encodePrimaryKey(b, this.primaryKey(obj));
        return b.toByteArray();
    }

    protected byte[] indexRowData(T obj) {
        long now = System.currentTimeMillis();
        IndexKeyBuilder b = new IndexKeyBuilder();
        this.encodePrimaryKey(b, this.primaryKey(obj));
        byte[] key = b.toByteArray();
        return IndexRow.CODEC.encodeToByteArray(IndexRow.forKey(now, key));
    }

    private static class IndexException
    extends RuntimeException {
        final OrmException cause;

        IndexException(OrmException err) {
            super(err);
            this.cause = err;
        }
    }
}

