/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_ArrayLiteral;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OutputContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

abstract class ArrayLiteral
extends CodeChunk.WithValue {
    ArrayLiteral() {
    }

    abstract ImmutableList<? extends CodeChunk.WithValue> elements();

    static ArrayLiteral create(ImmutableList<? extends CodeChunk.WithValue> elements) {
        return new AutoValue_ArrayLiteral(elements);
    }

    @Override
    public boolean isRepresentableAsSingleExpression() {
        for (CodeChunk.WithValue withValue : this.elements()) {
            if (withValue.isRepresentableAsSingleExpression()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (CodeChunk.WithValue withValue : this.elements()) {
            withValue.collectRequires(collector);
        }
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        this.formatOutputExpr(ctx, OutputContext.EXPRESSION);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx, OutputContext outputContext) {
        ctx.append('[');
        boolean first = true;
        for (CodeChunk.WithValue withValue : this.elements()) {
            if (first) {
                first = false;
            } else {
                ctx.append(", ");
            }
            withValue.formatOutputExpr(ctx, OutputContext.EXPRESSION);
        }
        ctx.append(']');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx, boolean moreToCome) {
        for (int i = 0; i < this.elements().size(); ++i) {
            ((CodeChunk.WithValue)this.elements().get(i)).formatInitialStatements(ctx, moreToCome || i < this.elements().size() - 1);
        }
    }
}

