/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.internal.GenCallCodeUtils;
import com.google.template.soy.jssrc.internal.GenJsCodeVisitor;
import com.google.template.soy.jssrc.internal.GenJsExprsVisitor;
import com.google.template.soy.jssrc.internal.IsComputableAsJsExprsVisitor;
import com.google.template.soy.jssrc.internal.JsCodeBuilder;
import com.google.template.soy.jssrc.internal.JsExprTranslator;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.msgs.internal.IcuSyntaxUtils;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenJsCodeVisitorAssistantForMsgs
extends AbstractSoyNodeVisitor<Void> {
    private static final Pattern UNDERSCORE_NUMBER_SUFFIX = Pattern.compile("_[0-9]+$");
    private final SoyJsSrcOptions jsSrcOptions;
    protected final GenJsCodeVisitor master;
    private final JsExprTranslator jsExprTranslator;
    private final GenCallCodeUtils genCallCodeUtils;
    private final IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor;
    private final GenJsExprsVisitor genJsExprsVisitor;
    private final TemplateAliases templateAliases;
    protected final TranslationContext translationContext;
    private final ErrorReporter errorReporter;

    protected GenJsCodeVisitorAssistantForMsgs(GenJsCodeVisitor master, SoyJsSrcOptions jsSrcOptions, JsExprTranslator jsExprTranslator, GenCallCodeUtils genCallCodeUtils, IsComputableAsJsExprsVisitor isComputableAsJsExprsVisitor, TemplateAliases functionAliases, GenJsExprsVisitor genJsExprsVisitor, TranslationContext translationContext, ErrorReporter errorReporter) {
        this.master = master;
        this.jsSrcOptions = jsSrcOptions;
        this.jsExprTranslator = jsExprTranslator;
        this.genCallCodeUtils = genCallCodeUtils;
        this.isComputableAsJsExprsVisitor = isComputableAsJsExprsVisitor;
        this.templateAliases = functionAliases;
        this.genJsExprsVisitor = genJsExprsVisitor;
        this.translationContext = translationContext;
        this.errorReporter = errorReporter;
    }

    @Override
    public Void exec(SoyNode node) {
        throw new AssertionError();
    }

    protected JsCodeBuilder jsCodeBuilder() {
        return this.master.jsCodeBuilder;
    }

    public String generateMsgGroupVariable(MsgFallbackGroupNode node) {
        String tmpVarName = this.translationContext.nameGenerator().generateName("msg_s");
        if (node.numChildren() == 1) {
            return this.generateSingleMsgVariable((MsgNode)node.getChild(0), tmpVarName);
        }
        this.generateMsgGroupVariable(node, tmpVarName);
        return tmpVarName;
    }

    private String generateSingleMsgVariable(MsgNode msgNode, String tmpVarName) {
        String googMsgVarName = this.buildGoogMsgVarNameHelper(msgNode);
        GoogMsgCodeGenInfo googMsgCodeGenInfo = this.genGoogGetMsgCallHelper(googMsgVarName, msgNode);
        if (!msgNode.isPlrselMsg()) {
            return googMsgVarName;
        }
        this.jsCodeBuilder().append(CodeChunk.declare(tmpVarName, GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(googMsgCodeGenInfo)));
        return tmpVarName;
    }

    private void generateMsgGroupVariable(MsgFallbackGroupNode node, String tmpVarName) {
        ArrayList<GoogMsgCodeGenInfo> childGoogMsgCodeGenInfos = new ArrayList<GoogMsgCodeGenInfo>(node.numChildren());
        for (MsgNode msgNode : node.getChildren()) {
            String googMsgVarName = this.buildGoogMsgVarNameHelper(msgNode);
            childGoogMsgCodeGenInfos.add(this.genGoogGetMsgCallHelper(googMsgVarName, msgNode));
        }
        this.jsCodeBuilder().appendLineStart("var ", tmpVarName, " = goog.getMsgWithFallback(");
        boolean isFirst = true;
        for (GoogMsgCodeGenInfo childGoogMsgCodeGenInfo : childGoogMsgCodeGenInfos) {
            if (isFirst) {
                isFirst = false;
            } else {
                this.jsCodeBuilder().append(", ");
            }
            this.jsCodeBuilder().append(childGoogMsgCodeGenInfo.googMsgVarName);
        }
        this.jsCodeBuilder().appendLineEnd(");");
        for (GoogMsgCodeGenInfo childGoogMsgCodeGenInfo : childGoogMsgCodeGenInfos) {
            if (!childGoogMsgCodeGenInfo.isPlrselMsg) continue;
            CodeChunk.WithValue tmpVar = CodeChunk.id(tmpVarName);
            this.jsCodeBuilder().append(this.translationContext.codeGenerator().newChunk().if_(tmpVar.doubleEquals(CodeChunk.id(childGoogMsgCodeGenInfo.googMsgVarName)), tmpVar.assign(GenJsCodeVisitorAssistantForMsgs.getMessageFormatCall(childGoogMsgCodeGenInfo))).endif().build());
        }
    }

    private String buildGoogMsgVarNameHelper(MsgNode msgNode) {
        String desiredName = this.jsSrcOptions.googMsgsAreExternal() ? "MSG_EXTERNAL_" + MsgUtils.computeMsgIdForDualFormat(msgNode) : "MSG_UNNAMED";
        return this.translationContext.nameGenerator().generateName(desiredName);
    }

    private GoogMsgCodeGenInfo genGoogGetMsgCallHelper(String googMsgVarName, MsgNode msgNode) {
        ImmutableList<SoyMsgPart> msgParts = MsgUtils.buildMsgParts(msgNode);
        CodeChunk.WithValue googMsgContent = CodeChunk.stringLiteral(GenJsCodeVisitorAssistantForMsgs.buildGoogMsgContentStr(msgParts, msgNode.isPlrselMsg()));
        GoogMsgCodeGenInfo googMsgCodeGenInfo = new GoogMsgCodeGenInfo(googMsgVarName, msgNode.isPlrselMsg());
        this.genGoogMsgCodeForChildren(msgNode, msgNode, googMsgCodeGenInfo);
        this.jsCodeBuilder().appendLineStart("/** ");
        if (msgNode.getMeaning() != null) {
            this.jsCodeBuilder().appendLineEnd("@meaning ", msgNode.getMeaning());
            this.jsCodeBuilder().appendLineStart(" *  ");
        }
        this.jsCodeBuilder().append("@desc ", msgNode.getDesc());
        if (msgNode.isHidden()) {
            this.jsCodeBuilder().appendLineEnd(new String[0]);
            this.jsCodeBuilder().appendLineStart(" *  @hidden");
        }
        this.jsCodeBuilder().appendLineEnd(" */");
        if (msgNode.isPlrselMsg() || googMsgCodeGenInfo.placeholders.isEmpty()) {
            this.jsCodeBuilder().append(CodeChunk.declare(googMsgCodeGenInfo.googMsgVarName, CodeChunk.dottedId("goog.getMsg").call(googMsgContent)));
        } else {
            this.jsCodeBuilder().append(CodeChunk.declare(googMsgCodeGenInfo.googMsgVarName, CodeChunk.dottedId("goog.getMsg").call(googMsgContent, googMsgCodeGenInfo.placeholders.build())));
        }
        return googMsgCodeGenInfo;
    }

    private static String buildGoogMsgContentStr(ImmutableList<SoyMsgPart> msgParts, boolean doUseBracedPhs) {
        msgParts = IcuSyntaxUtils.convertMsgPartsToEmbeddedIcuSyntax(msgParts, false);
        StringBuilder msgStrSb = new StringBuilder();
        for (SoyMsgPart msgPart : msgParts) {
            if (msgPart instanceof SoyMsgRawTextPart) {
                msgStrSb.append(((SoyMsgRawTextPart)msgPart).getRawText());
                continue;
            }
            if (msgPart instanceof SoyMsgPlaceholderPart) {
                String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                if (doUseBracedPhs) {
                    msgStrSb.append("{").append(placeholderName).append("}");
                    continue;
                }
                String googMsgPlaceholderName = GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
                msgStrSb.append("{$").append(googMsgPlaceholderName).append("}");
                continue;
            }
            throw new AssertionError();
        }
        return msgStrSb.toString();
    }

    private static CodeChunk.WithValue getMessageFormatCall(GoogMsgCodeGenInfo codeGenInfo) {
        MapLiteralBuilder builder = codeGenInfo.pluralsAndSelects;
        builder.putAll(codeGenInfo.placeholders);
        return CodeChunk.new_(CodeChunk.dottedId("goog.i18n.MessageFormat")).call(CodeChunk.id(codeGenInfo.googMsgVarName)).dotAccess("formatIgnoringPound").call(builder.build());
    }

    private void genGoogMsgCodeForChildren(SoyNode.BlockNode parentNode, MsgNode msgNode, GoogMsgCodeGenInfo codeGenInfo) {
        for (SoyNode.StandaloneNode child : parentNode.getChildren()) {
            if (child instanceof RawTextNode) continue;
            if (child instanceof MsgPlaceholderNode) {
                this.genGoogMsgCodeForPlaceholder((MsgPlaceholderNode)child, msgNode, codeGenInfo);
                continue;
            }
            if (child instanceof MsgPluralNode) {
                this.genGoogMsgCodeForPluralNode((MsgPluralNode)child, msgNode, codeGenInfo);
                continue;
            }
            if (child instanceof MsgSelectNode) {
                this.genGoogMsgCodeForSelectNode((MsgSelectNode)child, msgNode, codeGenInfo);
                continue;
            }
            String nodeStringForErrorMsg = child instanceof SoyNode.CommandNode ? "Tag " + ((SoyNode.CommandNode)((Object)child)).getTagString() : "Node " + child;
            throw new AssertionError((Object)(nodeStringForErrorMsg + " is not allowed to be a direct child of a 'msg' tag. At :" + child.getSourceLocation()));
        }
    }

    private void genGoogMsgCodeForPluralNode(MsgPluralNode pluralNode, MsgNode msgNode, GoogMsgCodeGenInfo googMsgCodeGenInfo) {
        googMsgCodeGenInfo.pluralsAndSelects.put(CodeChunk.stringLiteral(msgNode.getPluralVarName(pluralNode)), this.jsExprTranslator.translateToCodeChunk(pluralNode.getExpr(), this.translationContext, this.errorReporter));
        for (CaseOrDefaultNode child : pluralNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, msgNode, googMsgCodeGenInfo);
        }
    }

    private void genGoogMsgCodeForSelectNode(MsgSelectNode selectNode, MsgNode msgNode, GoogMsgCodeGenInfo codeGenInfo) {
        codeGenInfo.pluralsAndSelects.put(CodeChunk.stringLiteral(msgNode.getSelectVarName(selectNode)), this.jsExprTranslator.translateToCodeChunk(selectNode.getExpr(), this.translationContext, this.errorReporter));
        for (CaseOrDefaultNode child : selectNode.getChildren()) {
            this.genGoogMsgCodeForChildren(child, msgNode, codeGenInfo);
        }
    }

    private void genGoogMsgCodeForPlaceholder(MsgPlaceholderNode node, MsgNode msgNode, GoogMsgCodeGenInfo codeGenInfo) {
        String placeholderName = msgNode.getPlaceholderName(node);
        String googMsgPlaceholderName = codeGenInfo.isPlrselMsg ? placeholderName : GenJsCodeVisitorAssistantForMsgs.genGoogMsgPlaceholderName(placeholderName);
        codeGenInfo.placeholders.put(CodeChunk.stringLiteral(googMsgPlaceholderName), this.genGoogMsgPlaceholder(node));
    }

    private static String genGoogMsgPlaceholderName(String placeholderName) {
        Matcher suffixMatcher = UNDERSCORE_NUMBER_SUFFIX.matcher(placeholderName);
        if (suffixMatcher.find()) {
            String base = placeholderName.substring(0, suffixMatcher.start());
            String suffix = suffixMatcher.group();
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, base) + suffix;
        }
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, placeholderName);
    }

    protected CodeChunk.WithValue genGoogMsgPlaceholder(MsgPlaceholderNode msgPhNode) {
        ArrayList<CodeChunk.WithValue> contentChunks = new ArrayList<CodeChunk.WithValue>();
        for (SoyNode.StandaloneNode contentNode : msgPhNode.getChildren()) {
            if (contentNode instanceof MsgHtmlTagNode && !((Boolean)this.isComputableAsJsExprsVisitor.exec(contentNode)).booleanValue()) {
                this.visit(contentNode);
                contentChunks.add(CodeChunk.id("htmlTag" + contentNode.getId()));
                continue;
            }
            if (contentNode instanceof CallNode) {
                CallNode callNode = (CallNode)contentNode;
                for (CallParamNode grandchild : callNode.getChildren()) {
                    if (!(grandchild instanceof CallParamContentNode) || ((Boolean)this.isComputableAsJsExprsVisitor.exec(grandchild)).booleanValue()) continue;
                    this.visit(grandchild);
                }
                CodeChunk.WithValue call = this.genCallCodeUtils.gen(callNode, this.templateAliases, this.translationContext, this.errorReporter);
                contentChunks.add(call);
                continue;
            }
            List<CodeChunk.WithValue> chunks = this.genJsExprsVisitor.exec(contentNode);
            contentChunks.add(CodeChunkUtils.concatChunks(chunks));
        }
        return CodeChunkUtils.concatChunks(contentChunks);
    }

    @Override
    protected void visitMsgHtmlTagNode(MsgHtmlTagNode node) {
        if (((Boolean)this.isComputableAsJsExprsVisitor.exec(node)).booleanValue()) {
            throw new AssertionError((Object)"Should only define 'htmlTag<n>' when not computable as JS expressions.");
        }
        this.jsCodeBuilder().pushOutputVar("htmlTag" + node.getId());
        this.visitChildren(node);
        this.jsCodeBuilder().popOutputVar();
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        this.master.visitForUseByAssistants(node);
    }

    private static final class MapLiteralBuilder {
        final ImmutableList.Builder<CodeChunk.WithValue> keys = ImmutableList.builder();
        final ImmutableList.Builder<CodeChunk.WithValue> values = ImmutableList.builder();
        final Set<CodeChunk.WithValue> knownKeys = new HashSet<CodeChunk.WithValue>();

        private MapLiteralBuilder() {
        }

        MapLiteralBuilder put(CodeChunk.WithValue key, CodeChunk.WithValue value) {
            if (this.knownKeys.add(key)) {
                this.keys.add((Object)key);
                this.values.add((Object)value);
            }
            return this;
        }

        boolean isEmpty() {
            return this.knownKeys.isEmpty();
        }

        MapLiteralBuilder putAll(MapLiteralBuilder other) {
            ImmutableCollection keys = other.keys.build();
            ImmutableCollection values = other.values.build();
            Preconditions.checkState(keys.size() == values.size());
            Preconditions.checkState(Sets.intersection(this.knownKeys, other.knownKeys).isEmpty());
            for (int i = 0; i < keys.size(); ++i) {
                this.put((CodeChunk.WithValue)keys.get(i), (CodeChunk.WithValue)values.get(i));
            }
            return this;
        }

        CodeChunk.WithValue build() {
            return CodeChunk.mapLiteral(this.keys.build(), this.values.build());
        }
    }

    private static final class GoogMsgCodeGenInfo {
        final String googMsgVarName;
        final boolean isPlrselMsg;
        final MapLiteralBuilder placeholders = new MapLiteralBuilder();
        final MapLiteralBuilder pluralsAndSelects = new MapLiteralBuilder();

        GoogMsgCodeGenInfo(String googMsgVarName, boolean isPlrselMsg) {
            this.googMsgVarName = googMsgVarName;
            this.isPlrselMsg = isPlrselMsg;
        }
    }
}

