/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.scp;

import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.scp.ScpClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.scp.ScpException;
import org.apache.sshd.common.scp.ScpHelper;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.logging.AbstractLoggingBean;

public abstract class AbstractScpClient
extends AbstractLoggingBean
implements ScpClient {
    public static final Set<ClientChannelEvent> COMMAND_WAIT_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.EXIT_STATUS, ClientChannelEvent.CLOSED));

    protected AbstractScpClient() {
    }

    @Override
    public final ClientSession getSession() {
        return this.getClientSession();
    }

    @Override
    public void download(String[] remote, String local, Collection<ScpClient.Option> options) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", (Object)local);
        if ((remote = ValidateUtils.checkNotNullAndNotEmpty(remote, "Invalid argument remote: %s", new Object[]{remote})).length > 1) {
            options = this.addTargetIsDirectory(options);
        }
        for (String r : remote) {
            this.download(r, local, options);
        }
    }

    @Override
    public void download(String[] remote, Path local, Collection<ScpClient.Option> options) throws IOException {
        if ((remote = ValidateUtils.checkNotNullAndNotEmpty(remote, "Invalid argument remote: %s", new Object[]{remote})).length > 1) {
            options = this.addTargetIsDirectory(options);
        }
        for (String r : remote) {
            this.download(r, local, options);
        }
    }

    @Override
    public void download(String remote, Path local, Collection<ScpClient.Option> options) throws IOException {
        local = ValidateUtils.checkNotNull(local, "Invalid argument local: %s", (Object)local);
        remote = ValidateUtils.checkNotNullAndNotEmpty(remote, "Invalid argument remote: %s", (Object)remote);
        LinkOption[] opts = IoUtils.getLinkOptions(false);
        if (Files.isDirectory(local, opts)) {
            options = this.addTargetIsDirectory(options);
        }
        if (options.contains((Object)ScpClient.Option.TargetIsDirectory)) {
            Boolean status = IoUtils.checkFileExists(local, opts);
            if (status == null) {
                throw new SshException("Target directory " + local.toString() + " is probably inaccesible");
            }
            if (!status.booleanValue()) {
                throw new SshException("Target directory " + local.toString() + " does not exist");
            }
            if (!Files.isDirectory(local, opts)) {
                throw new SshException("Target directory " + local.toString() + " is not a directory");
            }
        }
        this.download(remote, local.getFileSystem(), local, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void download(String remote, String local, Collection<ScpClient.Option> options) throws IOException {
        local = ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", (Object)local);
        ClientSession session = this.getClientSession();
        ClientFactoryManager manager = session.getFactoryManager();
        FileSystemFactory factory = manager.getFileSystemFactory();
        FileSystem fs = factory.createFileSystem(session);
        try {
            this.download(remote, fs, fs.getPath(local, new String[0]), options);
        }
        catch (Throwable throwable) {
            block8: {
                try {
                    fs.close();
                }
                catch (UnsupportedOperationException e) {
                    if (!this.log.isDebugEnabled()) break block8;
                    this.log.debug("download({}) {} => {} - failed ({}) to close file system={}: {}", session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage());
                }
            }
            throw throwable;
        }
        try {
            fs.close();
        }
        catch (UnsupportedOperationException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("download({}) {} => {} - failed ({}) to close file system={}: {}", session, remote, local, e.getClass().getSimpleName(), fs, e.getMessage());
            }
        }
    }

    protected abstract void download(String var1, FileSystem var2, Path var3, Collection<ScpClient.Option> var4) throws IOException;

    @Override
    public void upload(String[] local, String remote, Collection<ScpClient.Option> options) throws IOException {
        List<String> paths = Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", new Object[]{local}));
        this.runUpload(remote, options, paths, (helper, local1, sendOptions) -> helper.send(local1, sendOptions.contains((Object)ScpClient.Option.Recursive), sendOptions.contains((Object)ScpClient.Option.PreserveAttributes), 8192));
    }

    @Override
    public void upload(Path[] local, String remote, Collection<ScpClient.Option> options) throws IOException {
        List<Path> paths = Arrays.asList(ValidateUtils.checkNotNullAndNotEmpty(local, "Invalid argument local: %s", new Object[]{local}));
        this.runUpload(remote, options, paths, (helper, local1, sendOptions) -> helper.sendPaths(local1, sendOptions.contains((Object)ScpClient.Option.Recursive), sendOptions.contains((Object)ScpClient.Option.PreserveAttributes), 8192));
    }

    protected abstract <T> void runUpload(String var1, Collection<ScpClient.Option> var2, Collection<T> var3, ScpOperationExecutor<T> var4) throws IOException;

    protected void handleCommandExitStatus(String cmd, ClientChannel channel) throws IOException {
        long timeout = PropertyResolverUtils.getLongProperty(channel, "scp-exec-channel-exit-status-timeout", DEFAULT_EXEC_CHANNEL_EXIT_STATUS_TIMEOUT);
        if (timeout <= 0L) {
            this.handleCommandExitStatus(cmd, (Integer)null);
            return;
        }
        long waitStart = System.nanoTime();
        Set<ClientChannelEvent> events = channel.waitFor(COMMAND_WAIT_EVENTS, timeout);
        long waitEnd = System.nanoTime();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleCommandExitStatus({}) cmd='{}', waited={} nanos, events={}", this.getClientSession(), cmd, waitEnd - waitStart, events);
        }
        this.handleCommandExitStatus(cmd, channel.getExitStatus());
    }

    protected void handleCommandExitStatus(String cmd, Integer exitStatus) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleCommandExitStatus({}) cmd='{}', exit-status={}", this.getClientSession(), cmd, ScpHelper.getExitStatusName(exitStatus));
        }
        if (exitStatus == null) {
            return;
        }
        int statusCode = exitStatus;
        switch (statusCode) {
            case 0: {
                break;
            }
            case 1: {
                this.log.warn("handleCommandExitStatus({}) cmd='{}' may have terminated with some problems", (Object)this.getClientSession(), (Object)cmd);
                break;
            }
            default: {
                throw new ScpException("Failed to run command='" + cmd + "': " + ScpHelper.getExitStatusName(exitStatus), exitStatus);
            }
        }
    }

    protected Collection<ScpClient.Option> addTargetIsDirectory(Collection<ScpClient.Option> options) {
        if (GenericUtils.isEmpty(options) || !options.contains((Object)ScpClient.Option.TargetIsDirectory)) {
            options = GenericUtils.isEmpty(options) ? EnumSet.noneOf(ScpClient.Option.class) : GenericUtils.of(options);
            options.add(ScpClient.Option.TargetIsDirectory);
        }
        return options;
    }

    protected ChannelExec openCommandChannel(ClientSession session, String cmd) throws IOException {
        long waitTimeout = PropertyResolverUtils.getLongProperty(session, "scp-exec-channel-open-timeout", DEFAULT_EXEC_CHANNEL_OPEN_TIMEOUT);
        ChannelExec channel = session.createExecChannel(cmd);
        long startTime = System.nanoTime();
        try {
            channel.open().verify(waitTimeout);
            long endTime = System.nanoTime();
            long nanosWait = endTime - startTime;
            if (this.log.isTraceEnabled()) {
                this.log.trace("openCommandChannel(" + session + ")[" + cmd + "]" + " completed after " + nanosWait + " nanos out of " + TimeUnit.MILLISECONDS.toNanos(waitTimeout));
            }
            return channel;
        }
        catch (IOException | RuntimeException e) {
            long endTime = System.nanoTime();
            long nanosWait = endTime - startTime;
            if (this.log.isTraceEnabled()) {
                this.log.trace("openCommandChannel(" + session + ")[" + cmd + "]" + " failed (" + e.getClass().getSimpleName() + ")" + " to complete after " + nanosWait + " nanos out of " + TimeUnit.MILLISECONDS.toNanos(waitTimeout) + ": " + e.getMessage());
            }
            channel.close(false);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface ScpOperationExecutor<T> {
        public void execute(ScpHelper var1, Collection<T> var2, Collection<ScpClient.Option> var3) throws IOException;
    }
}

