/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.logging;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.logging.LoggingUtils;
import org.apache.sshd.common.util.logging.SimplifiedLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoggingBean {
    protected final Logger log;
    private final AtomicReference<SimplifiedLog> simplifiedLog = new AtomicReference();

    protected AbstractLoggingBean() {
        this("");
    }

    protected AbstractLoggingBean(String discriminator) {
        String name = this.getClass().getName();
        if (GenericUtils.length(discriminator) > 0) {
            name = name + "[" + discriminator + "]";
        }
        this.log = LoggerFactory.getLogger(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SimplifiedLog getSimplifiedLogger() {
        SimplifiedLog logger;
        AtomicReference<SimplifiedLog> atomicReference = this.simplifiedLog;
        synchronized (atomicReference) {
            logger = this.simplifiedLog.get();
            if (logger == null) {
                logger = LoggingUtils.wrap(this.log);
            }
        }
        return logger;
    }
}

