/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.errors;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.Formatter;
import org.parboiled.errors.DefaultInvalidInputErrorFormatter;
import org.parboiled.errors.InvalidInputError;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.Position;

public final class ErrorUtils {
    private static final Joiner ERROR_JOINER = Joiner.on("---\n");
    private static final Function<ParseError, String> ERROR_TO_STRING = new Function<ParseError, String>(){

        @Override
        public String apply(ParseError input) {
            return ErrorUtils.printParseError(input);
        }
    };
    private static final RuntimeException REMOVE_THAT_DAMNIT = new RuntimeException(){

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    };

    private ErrorUtils() {
    }

    @Nullable
    static Matcher findProperLabelMatcher(MatcherPath path, int errorIndex) {
        try {
            return ErrorUtils.findProperLabelMatcher0(path, errorIndex);
        }
        catch (RuntimeException e) {
            if (e == REMOVE_THAT_DAMNIT) {
                return null;
            }
            throw e;
        }
    }

    @Nullable
    private static Matcher findProperLabelMatcher0(MatcherPath path, int errorIndex) {
        Matcher found;
        Preconditions.checkNotNull(path, "path");
        Matcher matcher = found = path.hasParent() ? ErrorUtils.findProperLabelMatcher0(path.getParent(), errorIndex) : null;
        if (found != null) {
            return found;
        }
        Matcher m = path.getElement().getMatcher();
        if (m instanceof TestNotMatcher) {
            throw REMOVE_THAT_DAMNIT;
        }
        if (path.getElement().getStartIndex() == errorIndex && m.hasCustomLabel()) {
            return m;
        }
        return null;
    }

    public static String printParseErrors(ParsingResult<?> parsingResult) {
        Preconditions.checkNotNull(parsingResult, "parsingResult");
        return ErrorUtils.printParseErrors(parsingResult.getParseErrors());
    }

    public static String printParseErrors(List<ParseError> errors) {
        Preconditions.checkNotNull(errors, "errors");
        return ERROR_JOINER.join(Iterables.transform(errors, ERROR_TO_STRING));
    }

    public static String printParseError(ParseError error) {
        Preconditions.checkNotNull(error, "error");
        return ErrorUtils.printParseError(error, new DefaultInvalidInputErrorFormatter());
    }

    public static String printParseError(ParseError error, Formatter<InvalidInputError> formatter) {
        Preconditions.checkNotNull(error, "error");
        Preconditions.checkNotNull(formatter, "formatter");
        String msg = error.getErrorMessage();
        if (msg == null) {
            msg = error instanceof InvalidInputError ? formatter.format((InvalidInputError)error) : error.getClass().getSimpleName();
        }
        return ErrorUtils.printErrorMessage("%s (line %s, pos %s):", msg, error.getStartIndex(), error.getEndIndex(), error.getInputBuffer());
    }

    public static String printErrorMessage(String format, String errorMessage, int errorIndex, InputBuffer inputBuffer) {
        Preconditions.checkNotNull(inputBuffer, "inputBuffer");
        return ErrorUtils.printErrorMessage(format, errorMessage, errorIndex, errorIndex + 1, inputBuffer);
    }

    public static String printErrorMessage(String format, String errorMessage, int startIndex, int endIndex, InputBuffer inputBuffer) {
        int i;
        Preconditions.checkNotNull(inputBuffer, "inputBuffer");
        Preconditions.checkArgument(startIndex <= endIndex);
        Position pos = inputBuffer.getPosition(startIndex);
        StringBuilder sb = new StringBuilder(String.format(format, errorMessage, pos.line, pos.column));
        sb.append('\n');
        String line = inputBuffer.extractLine(pos.line);
        sb.append(line);
        sb.append('\n');
        int charCount = Math.max(Math.min(endIndex - startIndex, line.length() - pos.column + 2), 1);
        for (i = 0; i < pos.column - 1; ++i) {
            sb.append(' ');
        }
        for (i = 0; i < charCount; ++i) {
            sb.append('^');
        }
        sb.append("\n");
        return sb.toString();
    }
}

