/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.parserunners;

import com.github.parboiled1.grappa.stack.DefaultValueStack;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.parboiled.DefaultMatcherContext;
import org.parboiled.MatchHandler;
import org.parboiled.MatcherContext;
import org.parboiled.Rule;
import org.parboiled.buffers.CharSequenceInputBuffer;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.errors.ParseError;
import org.parboiled.matchers.Matcher;
import org.parboiled.parserunners.ParseRunner;
import org.parboiled.support.ParsingResult;
import org.parboiled.support.ValueStack;

public abstract class AbstractParseRunner<V>
implements ParseRunner<V> {
    protected final Matcher rootMatcher;
    protected List<ParseError> parseErrors = Lists.newArrayList();
    protected ValueStack<V> valueStack = new DefaultValueStack();
    protected Object initialValueStackSnapshot;

    public AbstractParseRunner(@Nonnull Rule rule) {
        this.rootMatcher = Preconditions.checkNotNull((Matcher)rule, "rule");
    }

    public Matcher getRootMatcher() {
        return this.rootMatcher;
    }

    @Override
    public ParseRunner<V> withParseErrors(List<ParseError> parseErrors) {
        this.parseErrors = parseErrors;
        return this;
    }

    @Deprecated
    public List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    @Override
    public ParseRunner<V> withValueStack(@Nonnull ValueStack<V> valueStack) {
        this.valueStack = Preconditions.checkNotNull(valueStack, "valueStack");
        this.initialValueStackSnapshot = valueStack.takeSnapshot();
        return this;
    }

    public ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    @Override
    public ParsingResult<V> run(String input) {
        return this.run((CharSequence)input);
    }

    @Override
    public ParsingResult<V> run(CharSequence input) {
        Preconditions.checkNotNull(input, "input");
        return this.run(new CharSequenceInputBuffer(input));
    }

    @Override
    public ParsingResult<V> run(char[] input) {
        Preconditions.checkNotNull(input, "input");
        return this.run(new CharSequenceInputBuffer(input));
    }

    protected void resetValueStack() {
        this.valueStack.restoreSnapshot(this.initialValueStackSnapshot);
    }

    protected MatcherContext<V> createRootContext(InputBuffer inputBuffer, MatchHandler matchHandler, boolean fastStringMatching) {
        return new DefaultMatcherContext<V>(inputBuffer, this.valueStack, this.parseErrors, matchHandler, this.rootMatcher, fastStringMatching);
    }

    protected ParsingResult<V> createParsingResult(boolean matched, MatcherContext<V> rootContext) {
        return new ParsingResult<V>(matched, rootContext.getNode(), this.valueStack, this.parseErrors, rootContext.getInputBuffer());
    }
}

