/*
 * Decompiled with CFR 0.152.
 */
package com.github.parboiled1.grappa.stack;

import com.github.parboiled1.grappa.misc.SystemOutCharSink;
import com.github.parboiled1.grappa.stack.ForwardingValueStack;
import com.google.common.base.Joiner;
import com.google.common.io.CharSink;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.parboiled.support.ValueStack;

public final class DebuggingValueStack<V>
extends ForwardingValueStack<V> {
    private static final Joiner JOINER = Joiner.on(", ");
    private final CharSink sink;

    public DebuggingValueStack(@Nonnull ValueStack<V> delegate, @Nonnull CharSink sink) {
        super(delegate);
        this.sink = sink;
    }

    public DebuggingValueStack(@Nonnull ValueStack<V> delegate) {
        this(delegate, SystemOutCharSink.INSTANCE);
    }

    @Override
    public void clear() {
        this.log("clear");
        super.clear();
    }

    @Override
    public void restoreSnapshot(@Nullable Object snapshot) {
        this.log("restore snapshot: " + snapshot);
        super.restoreSnapshot(snapshot);
    }

    @Override
    public void push(@Nullable V value) {
        this.log("push: " + value);
        super.push(value);
    }

    @Override
    public void push(int down, @Nullable V value) {
        this.log("push " + down + ": " + value);
        super.push(down, value);
    }

    @Override
    @Nullable
    public V pop(int down) {
        this.log("pop: " + down);
        return super.pop(down);
    }

    @Override
    public void poke(int down, @Nullable V value) {
        this.log("poke " + down + ": " + value);
        super.poke(down, value);
    }

    @Override
    public void pushAll(@Nullable V firstValue, V ... moreValues) {
        this.log("pushAll: " + JOINER.join(firstValue, moreValues, new Object[0]));
        super.pushAll(firstValue, moreValues);
    }

    @Override
    @Nullable
    public Object takeSnapshot() {
        this.log("take snapshot");
        return super.takeSnapshot();
    }

    @Override
    @Nullable
    public V pop() {
        this.log("pop");
        return super.pop();
    }

    @Override
    @Nullable
    public V peek() {
        this.log("peek");
        return super.peek();
    }

    @Override
    @Nullable
    public V peek(int down) {
        this.log("peek " + down);
        return super.peek(down);
    }

    @Override
    public void poke(@Nullable V value) {
        this.log("poke: " + value);
        super.poke(value);
    }

    @Override
    public void dup() {
        this.log("dup");
        super.dup();
    }

    @Override
    public void swap(int n) {
        this.log("swap: " + n);
        super.swap(n);
    }

    @Override
    public void swap() {
        this.log("swap");
        super.swap();
    }

    @Override
    public void swap3() {
        this.log("swap3");
        super.swap3();
    }

    @Override
    public void swap4() {
        this.log("swap4");
        super.swap4();
    }

    @Override
    public void swap5() {
        this.log("swap5");
        super.swap5();
    }

    @Override
    public void swap6() {
        this.log("swap6");
        super.swap6();
    }

    @Override
    public void pushAll(@Nonnull Iterable<V> values) {
        this.log("pushAll: " + JOINER.join(values));
        super.pushAll(values);
    }

    private void log(CharSequence sequence) {
        try {
            this.sink.write(sequence);
        }
        catch (IOException e) {
            throw new RuntimeException("cannot write to debug channel", e);
        }
    }
}

