/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.html.types;

import com.google.common.annotations.GwtCompatible;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.errorprone.annotations.CompileTimeConstant;

@GwtCompatible
public final class SafeStyleSheets {
    private SafeStyleSheets() {
    }

    public static SafeStyleSheet fromConstant(@CompileTimeConstant String styleSheet) {
        if (styleSheet.length() == 0) {
            return SafeStyleSheet.EMPTY;
        }
        for (int i = 0; i < styleSheet.length(); ++i) {
            if (styleSheet.charAt(i) != '<') continue;
            throw new IllegalArgumentException("Forbidden '<' character in style sheet string: " + styleSheet);
        }
        return SafeStyleSheets.create(styleSheet);
    }

    public static SafeStyleSheet fromProto(SafeStyleSheetProto proto) {
        return SafeStyleSheets.create(proto.getPrivateDoNotAccessOrElseSafeStyleSheetWrappedValue());
    }

    public static SafeStyleSheetProto toProto(SafeStyleSheet style) {
        return SafeStyleSheetProto.newBuilder().setPrivateDoNotAccessOrElseSafeStyleSheetWrappedValue(style.getSafeStyleSheetString()).build();
    }

    static SafeStyleSheet create(String style) {
        return new SafeStyleSheet(style);
    }
}

