/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.gerrit.common.FileUtil;
import com.google.gerrit.common.IoUtil;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GwtIncompatible(value="Unemulated classes in java.nio and Guava")
public final class SiteLibraryLoaderUtil {
    private static final Logger log = LoggerFactory.getLogger(SiteLibraryLoaderUtil.class);

    public static void loadSiteLib(Path libdir) {
        try {
            List<Path> jars = SiteLibraryLoaderUtil.listJars(libdir);
            IoUtil.loadJARs(jars);
            log.debug("Loaded site libraries: {}", (Object)SiteLibraryLoaderUtil.jarList(jars));
        }
        catch (IOException e) {
            log.error("Error scanning lib directory " + libdir, e);
        }
    }

    private static String jarList(List<Path> jars) {
        return jars.stream().map(p -> p.getFileName().toString()).collect(Collectors.joining(","));
    }

    public static List<Path> listJars(Path dir) throws IOException {
        List<Path> list;
        block8: {
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) throws IOException {
                    String name = entry.getFileName().toString();
                    return (name.endsWith(".jar") || name.endsWith(".zip")) && Files.isRegularFile(entry, new LinkOption[0]);
                }
            };
            DirectoryStream<Path> jars = Files.newDirectoryStream(dir, (DirectoryStream.Filter<? super Path>)filter);
            try {
                list = new Ordering<Path>(){

                    @Override
                    public int compare(Path a, Path b) {
                        return ComparisonChain.start().compare(FileUtil.lastModified(b), FileUtil.lastModified(a)).compare(a, b).result();
                    }
                }.sortedCopy(jars);
                if (jars == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jars != null) {
                        try {
                            jars.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException nsfe) {
                    return ImmutableList.of();
                }
            }
            jars.close();
        }
        return list;
    }

    private SiteLibraryLoaderUtil() {
    }
}

