/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.httpd.WebSession;
import com.google.gerrit.httpd.WebSessionManager;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.AccessPath;
import com.google.gerrit.server.AnonymousUser;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.account.AuthResult;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.config.AuthConfig;
import com.google.inject.Provider;
import com.google.inject.servlet.RequestScoped;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.http.server.GitSmartHttpTools;

@RequestScoped
public abstract class CacheBasedWebSession
implements WebSession {
    @VisibleForTesting
    public static final String ACCOUNT_COOKIE = "GerritAccount";
    protected static final long MAX_AGE_MINUTES = TimeUnit.HOURS.toMinutes(12L);
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final WebSessionManager manager;
    private final AuthConfig authConfig;
    private final Provider<AnonymousUser> anonymousProvider;
    private final IdentifiedUser.RequestFactory identified;
    private final EnumSet<AccessPath> okPaths = EnumSet.of(AccessPath.UNKNOWN);
    private final AccountCache byIdCache;
    private Cookie outCookie;
    private WebSessionManager.Key key;
    private WebSessionManager.Val val;
    private CurrentUser user;

    protected CacheBasedWebSession(HttpServletRequest request, HttpServletResponse response, WebSessionManager manager, AuthConfig authConfig, Provider<AnonymousUser> anonymousProvider, IdentifiedUser.RequestFactory identified, AccountCache byIdCache) {
        this.request = request;
        this.response = response;
        this.manager = manager;
        this.authConfig = authConfig;
        this.anonymousProvider = anonymousProvider;
        this.identified = identified;
        this.byIdCache = byIdCache;
        if (request.getRequestURI() == null || !GitSmartHttpTools.isGitClient(request)) {
            String cookie = this.readCookie();
            if (cookie != null) {
                this.key = new WebSessionManager.Key(cookie);
                this.val = manager.get(this.key);
                if (this.val != null && this.val.needsCookieRefresh()) {
                    this.val = manager.createVal(this.key, this.val);
                }
                if (this.val != null && !this.checkAccountStatus(this.val.getAccountId())) {
                    this.val = null;
                }
            }
            String token = request.getHeader("X-Gerrit-Auth");
            if (this.val != null && token != null && token.equals(this.val.getAuth())) {
                this.okPaths.add(AccessPath.REST_API);
            }
        }
    }

    private String readCookie() {
        Cookie[] all = this.request.getCookies();
        if (all != null) {
            for (Cookie c : all) {
                if (!ACCOUNT_COOKIE.equals(c.getName())) continue;
                String v = c.getValue();
                return v != null && !"".equals(v) ? v : null;
            }
        }
        return null;
    }

    @Override
    public boolean isSignedIn() {
        return this.val != null;
    }

    @Override
    @Nullable
    public String getXGerritAuth() {
        return this.isSignedIn() ? this.val.getAuth() : null;
    }

    @Override
    public boolean isValidXGerritAuth(String keyIn) {
        return keyIn.equals(this.getXGerritAuth());
    }

    @Override
    public boolean isAccessPathOk(AccessPath path) {
        return this.okPaths.contains((Object)path);
    }

    @Override
    public void setAccessPathOk(AccessPath path, boolean ok) {
        if (ok) {
            this.okPaths.add(path);
        } else {
            this.okPaths.remove((Object)path);
        }
    }

    @Override
    public ExternalId.Key getLastLoginExternalId() {
        return this.val != null ? this.val.getExternalId() : null;
    }

    @Override
    public CurrentUser getUser() {
        if (this.user == null) {
            this.user = this.isSignedIn() ? this.identified.create(this.val.getAccountId()) : (CurrentUser)this.anonymousProvider.get();
        }
        return this.user;
    }

    @Override
    public void login(AuthResult res, boolean rememberMe) {
        Account.Id id = res.getAccountId();
        ExternalId.Key identity = res.getExternalId();
        if (this.val != null) {
            this.manager.destroy(this.key);
        }
        if (!this.checkAccountStatus(id)) {
            this.val = null;
            return;
        }
        this.key = this.manager.createKey(id);
        this.val = this.manager.createVal(this.key, id, rememberMe, identity, null, null);
        this.saveCookie();
        this.user = this.identified.create(this.val.getAccountId());
    }

    @Override
    public void setUserAccountId(Account.Id id) {
        this.key = new WebSessionManager.Key("id:" + id);
        this.val = new WebSessionManager.Val(id, 0L, false, null, 0L, null, null);
        this.user = this.identified.runAs(id, this.user);
    }

    @Override
    public void logout() {
        if (this.val != null) {
            this.manager.destroy(this.key);
            this.key = null;
            this.val = null;
            this.saveCookie();
            this.user = this.anonymousProvider.get();
        }
    }

    @Override
    public String getSessionId() {
        return this.val != null ? this.val.getSessionId() : null;
    }

    private boolean checkAccountStatus(Account.Id id) {
        AccountState accountState = this.byIdCache.get(id);
        return accountState != null && accountState.getAccount().isActive();
    }

    private void saveCookie() {
        int ageSeconds;
        String token;
        if (this.response == null) {
            return;
        }
        if (this.key == null) {
            token = "";
            ageSeconds = 0;
        } else {
            token = this.key.getToken();
            ageSeconds = this.manager.getCookieAge(this.val);
        }
        String path = this.authConfig.getCookiePath();
        if (Strings.isNullOrEmpty(path) && Strings.isNullOrEmpty(path = this.request.getContextPath())) {
            path = "/";
        }
        if (this.outCookie != null) {
            throw new IllegalStateException("Cookie GerritAccount was set");
        }
        this.outCookie = new Cookie(ACCOUNT_COOKIE, token);
        String domain = this.authConfig.getCookieDomain();
        if (!Strings.isNullOrEmpty(domain)) {
            this.outCookie.setDomain(domain);
        }
        this.outCookie.setSecure(CacheBasedWebSession.isSecure(this.request));
        this.outCookie.setPath(path);
        this.outCookie.setMaxAge(ageSeconds);
        this.outCookie.setSecure(this.authConfig.getCookieSecure());
        this.response.addCookie(this.outCookie);
    }

    private static boolean isSecure(HttpServletRequest req) {
        return req.isSecure() || "https".equals(req.getScheme());
    }
}

