/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Singleton
public class CatServlet
extends HttpServlet {
    private final Provider<ReviewDb> requestDb;
    private final Provider<CurrentUser> userProvider;
    private final ChangeControl.GenericFactory changeControl;
    private final ChangeEditUtil changeEditUtil;
    private final PatchSetUtil psUtil;

    @Inject
    CatServlet(Provider<ReviewDb> sf, ChangeControl.GenericFactory ccf, Provider<CurrentUser> usrprv, ChangeEditUtil ceu, PatchSetUtil psu) {
        this.requestDb = sf;
        this.changeControl = ccf;
        this.userProvider = usrprv;
        this.changeEditUtil = ceu;
        this.psUtil = psu;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        String revision;
        Change.Id changeId;
        Patch.Key patchKey;
        int side;
        block16: {
            String keyStr = req.getPathInfo();
            if (!(keyStr = Url.decode(keyStr)).startsWith("/")) {
                rsp.sendError(404);
                return;
            }
            int c = (keyStr = keyStr.substring(1)).lastIndexOf(94);
            if (c == 0) {
                rsp.sendError(404);
                return;
            }
            if (c < 0) {
                side = 0;
            } else {
                try {
                    side = Integer.parseInt(keyStr.substring(c + 1));
                    keyStr = keyStr.substring(0, c);
                }
                catch (NumberFormatException e) {
                    rsp.sendError(404);
                    return;
                }
            }
            try {
                patchKey = Patch.Key.parse(keyStr);
            }
            catch (NumberFormatException e) {
                rsp.sendError(404);
                return;
            }
            changeId = patchKey.getParentKey().getParentKey();
            try {
                ReviewDb db = this.requestDb.get();
                ChangeControl control = this.changeControl.validateFor(db, changeId, this.userProvider.get());
                if (patchKey.getParentKey().get() == 0) {
                    try {
                        Optional<ChangeEdit> edit = this.changeEditUtil.byChange(control.getChange());
                        if (!edit.isPresent()) {
                            rsp.sendError(404);
                            return;
                        }
                        revision = edit.get().getRevision().get();
                        break block16;
                    }
                    catch (AuthException e) {
                        rsp.sendError(404);
                        return;
                    }
                }
                PatchSet patchSet = this.psUtil.get(db, control.getNotes(), patchKey.getParentKey());
                if (patchSet == null) {
                    rsp.sendError(404);
                    return;
                }
                revision = patchSet.getRevision().get();
            }
            catch (NoSuchChangeException e) {
                rsp.sendError(404);
                return;
            }
            catch (OrmException e) {
                this.getServletContext().log("Cannot query database", e);
                rsp.sendError(500);
                return;
            }
        }
        String path = patchKey.getFileName();
        String restUrl = String.format("%s/changes/%d/revisions/%s/files/%s/download?parent=%d", req.getContextPath(), changeId.get(), revision, Url.encode(path), side);
        rsp.sendRedirect(restUrl);
    }
}

