/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.store.Directory;

final class WrappableSearcherManager
extends ReferenceManager<IndexSearcher> {
    private final SearcherFactory searcherFactory;

    WrappableSearcherManager(IndexWriter writer, boolean applyAllDeletes, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.current = WrappableSearcherManager.getSearcher(searcherFactory, DirectoryReader.open(writer, applyAllDeletes));
    }

    WrappableSearcherManager(Directory dir, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.current = WrappableSearcherManager.getSearcher(searcherFactory, DirectoryReader.open(dir));
    }

    WrappableSearcherManager(DirectoryReader reader, SearcherFactory searcherFactory) throws IOException {
        if (searcherFactory == null) {
            searcherFactory = new SearcherFactory();
        }
        this.searcherFactory = searcherFactory;
        this.current = WrappableSearcherManager.getSearcher(searcherFactory, reader);
    }

    @Override
    protected void decRef(IndexSearcher reference) throws IOException {
        reference.getIndexReader().decRef();
    }

    @Override
    protected IndexSearcher refreshIfNeeded(IndexSearcher referenceToRefresh) throws IOException {
        IndexReader r = referenceToRefresh.getIndexReader();
        assert (r instanceof DirectoryReader) : "searcher's IndexReader should be a DirectoryReader, but got " + r;
        DirectoryReader newReader = DirectoryReader.openIfChanged((DirectoryReader)r);
        if (newReader == null) {
            return null;
        }
        return WrappableSearcherManager.getSearcher(this.searcherFactory, newReader);
    }

    @Override
    protected boolean tryIncRef(IndexSearcher reference) {
        return reference.getIndexReader().tryIncRef();
    }

    @Override
    protected int getRefCount(IndexSearcher reference) {
        return reference.getIndexReader().getRefCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSearcherCurrent() throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.acquire();
        try {
            IndexReader r = searcher.getIndexReader();
            assert (r instanceof DirectoryReader) : "searcher's IndexReader should be a DirectoryReader, but got " + r;
            boolean bl = ((DirectoryReader)r).isCurrent();
            return bl;
        }
        finally {
            this.release(searcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexSearcher getSearcher(SearcherFactory searcherFactory, IndexReader reader) throws IOException {
        IndexSearcher searcher;
        boolean success = false;
        try {
            searcher = searcherFactory.newSearcher(reader, null);
            IndexReader unwrapped = searcher.getIndexReader();
            while (unwrapped != reader) {
                if (unwrapped instanceof FilterDirectoryReader) {
                    unwrapped = ((FilterDirectoryReader)unwrapped).getDelegate();
                    continue;
                }
                if (!(unwrapped instanceof FilterLeafReader)) break;
                unwrapped = ((FilterLeafReader)unwrapped).getDelegate();
            }
            if (unwrapped != reader) {
                throw new IllegalStateException("SearcherFactory must wrap the provided reader (got " + searcher.getIndexReader() + " but expected " + reader + ")");
            }
            success = true;
        }
        finally {
            if (!success) {
                reader.decRef();
            }
        }
        return searcher;
    }
}

