/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.HashedPassword;
import com.google.gerrit.server.account.WatchConfig;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountState {
    private static final Logger logger = LoggerFactory.getLogger(AccountState.class);
    public static final Function<AccountState, Account.Id> ACCOUNT_ID_FUNCTION = a -> a.getAccount().getId();
    private final Account account;
    private final Set<AccountGroup.UUID> internalGroups;
    private final Collection<ExternalId> externalIds;
    private final Map<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> projectWatches;
    private Cache<CurrentUser.PropertyKey<Object>, Object> properties;

    public AccountState(Account account, Set<AccountGroup.UUID> actualGroups, Collection<ExternalId> externalIds, Map<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> projectWatches) {
        this.account = account;
        this.internalGroups = actualGroups;
        this.externalIds = externalIds;
        this.projectWatches = projectWatches;
        this.account.setUserName(AccountState.getUserName(externalIds));
    }

    public Account getAccount() {
        return this.account;
    }

    public String getUserName() {
        return this.account.getUserName();
    }

    public boolean checkPassword(String password, String username) {
        if (password == null) {
            return false;
        }
        for (ExternalId id : this.getExternalIds()) {
            String hashedStr;
            if (!id.isScheme("username") || !username.equals(id.key().id()) || Strings.isNullOrEmpty(hashedStr = id.password())) continue;
            try {
                return HashedPassword.decode(hashedStr).checkPassword(password);
            }
            catch (DecoderException e) {
                logger.error("DecoderException for user {}: {}", (Object)username, (Object)e.getMessage());
                return false;
            }
        }
        return false;
    }

    public Collection<ExternalId> getExternalIds() {
        return this.externalIds;
    }

    public Map<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> getProjectWatches() {
        return this.projectWatches;
    }

    public Set<AccountGroup.UUID> getInternalGroups() {
        return this.internalGroups;
    }

    public static String getUserName(Collection<ExternalId> ids) {
        for (ExternalId extId : ids) {
            if (!extId.isScheme("username")) continue;
            return extId.key().id();
        }
        return null;
    }

    public static Set<String> getEmails(Collection<ExternalId> ids) {
        HashSet<String> emails = new HashSet<String>();
        for (ExternalId extId : ids) {
            if (!extId.isScheme("mailto")) continue;
            emails.add(extId.key().id());
        }
        return emails;
    }

    @Nullable
    public <T> T get(CurrentUser.PropertyKey<T> key) {
        Cache<CurrentUser.PropertyKey<Object>, Object> p = this.properties(false);
        if (p != null) {
            Object value = p.getIfPresent(key);
            return (T)value;
        }
        return null;
    }

    public <T> void put(CurrentUser.PropertyKey<T> key, @Nullable T value) {
        Cache<CurrentUser.PropertyKey<Object>, Object> p = this.properties(value != null);
        if (p != null) {
            CurrentUser.PropertyKey<T> k = key;
            if (value != null) {
                p.put(k, value);
            } else {
                p.invalidate(k);
            }
        }
    }

    private synchronized Cache<CurrentUser.PropertyKey<Object>, Object> properties(boolean allocate) {
        if (this.properties == null && allocate) {
            this.properties = CacheBuilder.newBuilder().concurrencyLevel(1).initialCapacity(16).weakKeys().build();
        }
        return this.properties;
    }
}

