/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.Iterables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.project.ProjectControl;
import java.util.Collection;
import java.util.Comparator;

public class GroupBackends {
    public static final Comparator<GroupReference> GROUP_REF_NAME_COMPARATOR = new Comparator<GroupReference>(){

        @Override
        public int compare(GroupReference a, GroupReference b) {
            return a.getName().compareTo(b.getName());
        }
    };

    @Nullable
    public static GroupReference findBestSuggestion(GroupBackend groupBackend, String name) {
        return GroupBackends.findBestSuggestion(groupBackend, name, null);
    }

    @Nullable
    public static GroupReference findBestSuggestion(GroupBackend groupBackend, String name, @Nullable ProjectControl project) {
        Collection<GroupReference> refs = groupBackend.suggest(name, project);
        if (refs.size() == 1) {
            return Iterables.getOnlyElement(refs);
        }
        for (GroupReference ref : refs) {
            if (!GroupBackends.isExactSuggestion(ref, name)) continue;
            return ref;
        }
        return null;
    }

    @Nullable
    public static GroupReference findExactSuggestion(GroupBackend groupBackend, String name) {
        return GroupBackends.findExactSuggestion(groupBackend, name, null);
    }

    @Nullable
    public static GroupReference findExactSuggestion(GroupBackend groupBackend, String name, ProjectControl project) {
        Collection<GroupReference> refs = groupBackend.suggest(name, project);
        for (GroupReference ref : refs) {
            if (!GroupBackends.isExactSuggestion(ref, name)) continue;
            return ref;
        }
        return null;
    }

    public static boolean isExactSuggestion(GroupReference ref, String name) {
        return ref.getName().equalsIgnoreCase(name) || ref.getUUID().get().equals(name);
    }

    private GroupBackends() {
    }
}

