/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.DiffPreferencesInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetDiffPreferences;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;

@Singleton
public class SetDiffPreferences
implements RestModifyView<AccountResource, DiffPreferencesInfo> {
    private final Provider<CurrentUser> self;
    private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
    private final AllUsersName allUsersName;
    private final GitRepositoryManager gitMgr;

    @Inject
    SetDiffPreferences(Provider<CurrentUser> self, Provider<MetaDataUpdate.User> metaDataUpdateFactory, AllUsersName allUsersName, GitRepositoryManager gitMgr) {
        this.self = self;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allUsersName = allUsersName;
        this.gitMgr = gitMgr;
    }

    public DiffPreferencesInfo apply(AccountResource rsrc, DiffPreferencesInfo in) throws AuthException, BadRequestException, ConfigInvalidException, RepositoryNotFoundException, IOException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("requires Modify Account capability");
        }
        if (in == null) {
            throw new BadRequestException("input must be provided");
        }
        Account.Id id = rsrc.getUser().getAccountId();
        return this.writeToGit(GetDiffPreferences.readFromGit(id, this.gitMgr, this.allUsersName, in), id);
    }

    private DiffPreferencesInfo writeToGit(DiffPreferencesInfo in, Account.Id userId) throws RepositoryNotFoundException, IOException, ConfigInvalidException {
        DiffPreferencesInfo out = new DiffPreferencesInfo();
        try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(this.allUsersName);){
            DiffPreferencesInfo allUserPrefs = GetDiffPreferences.readDefaultsFromGit(md.getRepository(), null);
            VersionedAccountPreferences prefs = VersionedAccountPreferences.forUser(userId);
            prefs.load(md);
            ConfigUtil.storeSection(prefs.getConfig(), "diff", null, in, allUserPrefs);
            prefs.commit(md);
            ConfigUtil.loadSection(prefs.getConfig(), "diff", null, out, allUserPrefs, null);
        }
        return out;
    }
}

