/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.changes;

import com.google.gerrit.extensions.api.changes.ChangeEditApi;
import com.google.gerrit.extensions.api.changes.PublishChangeEditInput;
import com.google.gerrit.extensions.common.EditInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.RawInput;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.change.ChangeEditResource;
import com.google.gerrit.server.change.ChangeEdits;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.DeleteChangeEdit;
import com.google.gerrit.server.change.PublishChangeEdit;
import com.google.gerrit.server.change.RebaseChangeEdit;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Optional;

public class ChangeEditApiImpl
implements ChangeEditApi {
    private final ChangeEdits.Detail editDetail;
    private final ChangeEdits.Post changeEditsPost;
    private final DeleteChangeEdit deleteChangeEdit;
    private final RebaseChangeEdit.Rebase rebaseChangeEdit;
    private final PublishChangeEdit.Publish publishChangeEdit;
    private final ChangeEdits.Get changeEditsGet;
    private final ChangeEdits.Put changeEditsPut;
    private final ChangeEdits.DeleteContent changeEditDeleteContent;
    private final ChangeEdits.GetMessage getChangeEditCommitMessage;
    private final ChangeEdits.EditMessage modifyChangeEditCommitMessage;
    private final ChangeEdits changeEdits;
    private final ChangeResource changeResource;

    @Inject
    public ChangeEditApiImpl(ChangeEdits.Detail editDetail, ChangeEdits.Post changeEditsPost, DeleteChangeEdit deleteChangeEdit, RebaseChangeEdit.Rebase rebaseChangeEdit, PublishChangeEdit.Publish publishChangeEdit, ChangeEdits.Get changeEditsGet, ChangeEdits.Put changeEditsPut, ChangeEdits.DeleteContent changeEditDeleteContent, ChangeEdits.GetMessage getChangeEditCommitMessage, ChangeEdits.EditMessage modifyChangeEditCommitMessage, ChangeEdits changeEdits, @Assisted ChangeResource changeResource) {
        this.editDetail = editDetail;
        this.changeEditsPost = changeEditsPost;
        this.deleteChangeEdit = deleteChangeEdit;
        this.rebaseChangeEdit = rebaseChangeEdit;
        this.publishChangeEdit = publishChangeEdit;
        this.changeEditsGet = changeEditsGet;
        this.changeEditsPut = changeEditsPut;
        this.changeEditDeleteContent = changeEditDeleteContent;
        this.getChangeEditCommitMessage = getChangeEditCommitMessage;
        this.modifyChangeEditCommitMessage = modifyChangeEditCommitMessage;
        this.changeEdits = changeEdits;
        this.changeResource = changeResource;
    }

    @Override
    public Optional<EditInfo> get() throws RestApiException {
        try {
            Response<EditInfo> edit = this.editDetail.apply(this.changeResource);
            return edit.isNone() ? Optional.empty() : Optional.of(edit.value());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot retrieve change edit", e);
        }
    }

    @Override
    public void create() throws RestApiException {
        try {
            this.changeEditsPost.apply(this.changeResource, null);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot create change edit", e);
        }
    }

    @Override
    public void delete() throws RestApiException {
        try {
            this.deleteChangeEdit.apply(this.changeResource, new DeleteChangeEdit.Input());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot delete change edit", e);
        }
    }

    @Override
    public void rebase() throws RestApiException {
        try {
            this.rebaseChangeEdit.apply(this.changeResource, null);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot rebase change edit", e);
        }
    }

    @Override
    public void publish() throws RestApiException {
        this.publish(null);
    }

    @Override
    public void publish(PublishChangeEditInput publishChangeEditInput) throws RestApiException {
        try {
            this.publishChangeEdit.apply(this.changeResource, publishChangeEditInput);
        }
        catch (UpdateException | OrmException | IOException e) {
            throw new RestApiException("Cannot publish change edit", e);
        }
    }

    @Override
    public Optional<BinaryResult> getFile(String filePath) throws RestApiException {
        try {
            ChangeEditResource changeEditResource = this.getChangeEditResource(filePath);
            Response<BinaryResult> fileResponse = this.changeEditsGet.apply(changeEditResource);
            return fileResponse.isNone() ? Optional.empty() : Optional.of(fileResponse.value());
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot retrieve file of change edit", e);
        }
    }

    @Override
    public void renameFile(String oldFilePath, String newFilePath) throws RestApiException {
        try {
            ChangeEdits.Post.Input renameInput = new ChangeEdits.Post.Input();
            renameInput.oldPath = oldFilePath;
            renameInput.newPath = newFilePath;
            this.changeEditsPost.apply(this.changeResource, renameInput);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot rename file of change edit", e);
        }
    }

    @Override
    public void restoreFile(String filePath) throws RestApiException {
        try {
            ChangeEdits.Post.Input restoreInput = new ChangeEdits.Post.Input();
            restoreInput.restorePath = filePath;
            this.changeEditsPost.apply(this.changeResource, restoreInput);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot restore file of change edit", e);
        }
    }

    @Override
    public void modifyFile(String filePath, RawInput newContent) throws RestApiException {
        try {
            this.changeEditsPut.apply(this.changeResource.getControl(), filePath, newContent);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot modify file of change edit", e);
        }
    }

    @Override
    public void deleteFile(String filePath) throws RestApiException {
        try {
            this.changeEditDeleteContent.apply(this.changeResource.getControl(), filePath);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot delete file of change edit", e);
        }
    }

    @Override
    public String getCommitMessage() throws RestApiException {
        String string;
        block8: {
            BinaryResult binaryResult = this.getChangeEditCommitMessage.apply(this.changeResource);
            try {
                string = binaryResult.asString();
                if (binaryResult == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (binaryResult != null) {
                        try {
                            binaryResult.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OrmException | IOException e) {
                    throw new RestApiException("Cannot get commit message of change edit", e);
                }
            }
            binaryResult.close();
        }
        return string;
    }

    @Override
    public void modifyCommitMessage(String newCommitMessage) throws RestApiException {
        ChangeEdits.EditMessage.Input input = new ChangeEdits.EditMessage.Input();
        input.message = newCommitMessage;
        try {
            this.modifyChangeEditCommitMessage.apply(this.changeResource, input);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot modify commit message of change edit", e);
        }
    }

    private ChangeEditResource getChangeEditResource(String filePath) throws ResourceNotFoundException, AuthException, IOException, OrmException {
        return this.changeEdits.parse(this.changeResource, IdString.fromDecoded(filePath));
    }

    static interface Factory {
        public ChangeEditApiImpl create(ChangeResource var1);
    }
}

