/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.projects;

import com.google.gerrit.extensions.api.access.ProjectAccessInfo;
import com.google.gerrit.extensions.api.access.ProjectAccessInput;
import com.google.gerrit.extensions.api.projects.BranchApi;
import com.google.gerrit.extensions.api.projects.BranchInfo;
import com.google.gerrit.extensions.api.projects.ChildProjectApi;
import com.google.gerrit.extensions.api.projects.ConfigInfo;
import com.google.gerrit.extensions.api.projects.ConfigInput;
import com.google.gerrit.extensions.api.projects.DeleteBranchesInput;
import com.google.gerrit.extensions.api.projects.DeleteTagsInput;
import com.google.gerrit.extensions.api.projects.DescriptionInput;
import com.google.gerrit.extensions.api.projects.ProjectApi;
import com.google.gerrit.extensions.api.projects.ProjectInput;
import com.google.gerrit.extensions.api.projects.TagApi;
import com.google.gerrit.extensions.api.projects.TagInfo;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.TopLevelResource;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.CapabilityUtils;
import com.google.gerrit.server.api.projects.BranchApiImpl;
import com.google.gerrit.server.api.projects.ChildProjectApiImpl;
import com.google.gerrit.server.api.projects.TagApiImpl;
import com.google.gerrit.server.project.ChildProjectsCollection;
import com.google.gerrit.server.project.CreateProject;
import com.google.gerrit.server.project.DeleteBranches;
import com.google.gerrit.server.project.DeleteTags;
import com.google.gerrit.server.project.GetAccess;
import com.google.gerrit.server.project.GetConfig;
import com.google.gerrit.server.project.GetDescription;
import com.google.gerrit.server.project.ListBranches;
import com.google.gerrit.server.project.ListChildProjects;
import com.google.gerrit.server.project.ListTags;
import com.google.gerrit.server.project.ProjectJson;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.gerrit.server.project.PutConfig;
import com.google.gerrit.server.project.PutDescription;
import com.google.gerrit.server.project.SetAccess;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;

public class ProjectApiImpl
implements ProjectApi {
    private final CurrentUser user;
    private final CreateProject.Factory createProjectFactory;
    private final Factory projectApi;
    private final ProjectsCollection projects;
    private final GetDescription getDescription;
    private final PutDescription putDescription;
    private final ChildProjectApiImpl.Factory childApi;
    private final ChildProjectsCollection children;
    private final ProjectResource project;
    private final ProjectJson projectJson;
    private final String name;
    private final BranchApiImpl.Factory branchApi;
    private final TagApiImpl.Factory tagApi;
    private final GetAccess getAccess;
    private final SetAccess setAccess;
    private final GetConfig getConfig;
    private final PutConfig putConfig;
    private final ListBranches listBranches;
    private final ListTags listTags;
    private final DeleteBranches deleteBranches;
    private final DeleteTags deleteTags;

    @AssistedInject
    ProjectApiImpl(CurrentUser user, CreateProject.Factory createProjectFactory, Factory projectApi, ProjectsCollection projects, GetDescription getDescription, PutDescription putDescription, ChildProjectApiImpl.Factory childApi, ChildProjectsCollection children, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, TagApiImpl.Factory tagApiFactory, GetAccess getAccess, SetAccess setAccess, GetConfig getConfig, PutConfig putConfig, ListBranches listBranches, ListTags listTags, DeleteBranches deleteBranches, DeleteTags deleteTags, @Assisted ProjectResource project) {
        this(user, createProjectFactory, projectApi, projects, getDescription, putDescription, childApi, children, projectJson, branchApiFactory, tagApiFactory, getAccess, setAccess, getConfig, putConfig, listBranches, listTags, deleteBranches, deleteTags, project, null);
    }

    @AssistedInject
    ProjectApiImpl(CurrentUser user, CreateProject.Factory createProjectFactory, Factory projectApi, ProjectsCollection projects, GetDescription getDescription, PutDescription putDescription, ChildProjectApiImpl.Factory childApi, ChildProjectsCollection children, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, TagApiImpl.Factory tagApiFactory, GetAccess getAccess, SetAccess setAccess, GetConfig getConfig, PutConfig putConfig, ListBranches listBranches, ListTags listTags, DeleteBranches deleteBranches, DeleteTags deleteTags, @Assisted String name) {
        this(user, createProjectFactory, projectApi, projects, getDescription, putDescription, childApi, children, projectJson, branchApiFactory, tagApiFactory, getAccess, setAccess, getConfig, putConfig, listBranches, listTags, deleteBranches, deleteTags, null, name);
    }

    private ProjectApiImpl(CurrentUser user, CreateProject.Factory createProjectFactory, Factory projectApi, ProjectsCollection projects, GetDescription getDescription, PutDescription putDescription, ChildProjectApiImpl.Factory childApi, ChildProjectsCollection children, ProjectJson projectJson, BranchApiImpl.Factory branchApiFactory, TagApiImpl.Factory tagApiFactory, GetAccess getAccess, SetAccess setAccess, GetConfig getConfig, PutConfig putConfig, ListBranches listBranches, ListTags listTags, DeleteBranches deleteBranches, DeleteTags deleteTags, ProjectResource project, String name) {
        this.user = user;
        this.createProjectFactory = createProjectFactory;
        this.projectApi = projectApi;
        this.projects = projects;
        this.getDescription = getDescription;
        this.putDescription = putDescription;
        this.childApi = childApi;
        this.children = children;
        this.projectJson = projectJson;
        this.project = project;
        this.name = name;
        this.branchApi = branchApiFactory;
        this.tagApi = tagApiFactory;
        this.getAccess = getAccess;
        this.setAccess = setAccess;
        this.getConfig = getConfig;
        this.putConfig = putConfig;
        this.listBranches = listBranches;
        this.listTags = listTags;
        this.deleteBranches = deleteBranches;
        this.deleteTags = deleteTags;
    }

    @Override
    public ProjectApi create() throws RestApiException {
        return this.create(new ProjectInput());
    }

    @Override
    public ProjectApi create(ProjectInput in) throws RestApiException {
        try {
            if (this.name == null) {
                throw new ResourceConflictException("Project already exists");
            }
            if (in.name != null && !this.name.equals(in.name)) {
                throw new BadRequestException("name must match input.name");
            }
            CapabilityUtils.checkRequiresCapability(this.user, null, CreateProject.class);
            this.createProjectFactory.create(this.name).apply(TopLevelResource.INSTANCE, in);
            return this.projectApi.create(this.projects.parse(this.name));
        }
        catch (IOException | ConfigInvalidException e) {
            throw new RestApiException("Cannot create project: " + e.getMessage(), e);
        }
    }

    @Override
    public ProjectInfo get() throws RestApiException {
        if (this.project == null) {
            throw new ResourceNotFoundException(this.name);
        }
        return this.projectJson.format(this.project);
    }

    @Override
    public String description() throws RestApiException {
        return this.getDescription.apply(this.checkExists());
    }

    @Override
    public ProjectAccessInfo access() throws RestApiException {
        try {
            return this.getAccess.apply(this.checkExists());
        }
        catch (IOException e) {
            throw new RestApiException("Cannot get access rights", e);
        }
    }

    @Override
    public ProjectAccessInfo access(ProjectAccessInput p) throws RestApiException {
        try {
            return this.setAccess.apply(this.checkExists(), p);
        }
        catch (IOException e) {
            throw new RestApiException("Cannot put access rights", e);
        }
    }

    @Override
    public void description(DescriptionInput in) throws RestApiException {
        try {
            this.putDescription.apply(this.checkExists(), in);
        }
        catch (IOException e) {
            throw new RestApiException("Cannot put project description", e);
        }
    }

    @Override
    public ConfigInfo config() throws RestApiException {
        return this.getConfig.apply(this.checkExists());
    }

    @Override
    public ConfigInfo config(ConfigInput in) throws RestApiException {
        return this.putConfig.apply(this.checkExists(), in);
    }

    @Override
    public ProjectApi.ListRefsRequest<BranchInfo> branches() {
        return new ProjectApi.ListRefsRequest<BranchInfo>(){

            @Override
            public List<BranchInfo> get() throws RestApiException {
                return ProjectApiImpl.this.listBranches(this);
            }
        };
    }

    private List<BranchInfo> listBranches(ProjectApi.ListRefsRequest<BranchInfo> request) throws RestApiException {
        this.listBranches.setLimit(request.getLimit());
        this.listBranches.setStart(request.getStart());
        this.listBranches.setMatchSubstring(request.getSubstring());
        this.listBranches.setMatchRegex(request.getRegex());
        try {
            return this.listBranches.apply(this.checkExists());
        }
        catch (IOException e) {
            throw new RestApiException("Cannot list branches", e);
        }
    }

    @Override
    public ProjectApi.ListRefsRequest<TagInfo> tags() {
        return new ProjectApi.ListRefsRequest<TagInfo>(){

            @Override
            public List<TagInfo> get() throws RestApiException {
                return ProjectApiImpl.this.listTags(this);
            }
        };
    }

    private List<TagInfo> listTags(ProjectApi.ListRefsRequest<TagInfo> request) throws RestApiException {
        this.listTags.setLimit(request.getLimit());
        this.listTags.setStart(request.getStart());
        this.listTags.setMatchSubstring(request.getSubstring());
        this.listTags.setMatchRegex(request.getRegex());
        try {
            return this.listTags.apply(this.checkExists());
        }
        catch (IOException e) {
            throw new RestApiException("Cannot list tags", e);
        }
    }

    @Override
    public List<ProjectInfo> children() throws RestApiException {
        return this.children(false);
    }

    @Override
    public List<ProjectInfo> children(boolean recursive) throws RestApiException {
        ListChildProjects list = this.children.list();
        list.setRecursive(recursive);
        return list.apply(this.checkExists());
    }

    @Override
    public ChildProjectApi child(String name) throws RestApiException {
        try {
            return this.childApi.create(this.children.parse(this.checkExists(), IdString.fromDecoded(name)));
        }
        catch (IOException e) {
            throw new RestApiException("Cannot parse child project", e);
        }
    }

    @Override
    public BranchApi branch(String ref) throws ResourceNotFoundException {
        return this.branchApi.create(this.checkExists(), ref);
    }

    @Override
    public TagApi tag(String ref) throws ResourceNotFoundException {
        return this.tagApi.create(this.checkExists(), ref);
    }

    @Override
    public void deleteBranches(DeleteBranchesInput in) throws RestApiException {
        try {
            this.deleteBranches.apply(this.checkExists(), in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot delete branches", e);
        }
    }

    @Override
    public void deleteTags(DeleteTagsInput in) throws RestApiException {
        try {
            this.deleteTags.apply(this.checkExists(), in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot delete tags", e);
        }
    }

    private ProjectResource checkExists() throws ResourceNotFoundException {
        if (this.project == null) {
            throw new ResourceNotFoundException(this.name);
        }
        return this.project;
    }

    static interface Factory {
        public ProjectApiImpl create(ProjectResource var1);

        public ProjectApiImpl create(String var1);
    }
}

