/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.PatchSetInserter;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.InvalidChangeOperationException;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.TimeZone;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class CherryPickChange {
    private final Provider<ReviewDb> db;
    private final Sequences seq;
    private final Provider<InternalChangeQuery> queryProvider;
    private final GitRepositoryManager gitManager;
    private final TimeZone serverTimeZone;
    private final Provider<IdentifiedUser> user;
    private final ChangeInserter.Factory changeInserterFactory;
    private final PatchSetInserter.Factory patchSetInserterFactory;
    private final MergeUtil.Factory mergeUtilFactory;
    private final ChangeMessagesUtil changeMessagesUtil;
    private final PatchSetUtil psUtil;
    private final BatchUpdate.Factory batchUpdateFactory;

    @Inject
    CherryPickChange(Provider<ReviewDb> db, Sequences seq, Provider<InternalChangeQuery> queryProvider, @GerritPersonIdent PersonIdent myIdent, GitRepositoryManager gitManager, Provider<IdentifiedUser> user, ChangeInserter.Factory changeInserterFactory, PatchSetInserter.Factory patchSetInserterFactory, MergeUtil.Factory mergeUtilFactory, ChangeMessagesUtil changeMessagesUtil, PatchSetUtil psUtil, BatchUpdate.Factory batchUpdateFactory) {
        this.db = db;
        this.seq = seq;
        this.queryProvider = queryProvider;
        this.gitManager = gitManager;
        this.serverTimeZone = myIdent.getTimeZone();
        this.user = user;
        this.changeInserterFactory = changeInserterFactory;
        this.patchSetInserterFactory = patchSetInserterFactory;
        this.mergeUtilFactory = mergeUtilFactory;
        this.changeMessagesUtil = changeMessagesUtil;
        this.psUtil = psUtil;
        this.batchUpdateFactory = batchUpdateFactory;
    }

    /*
     * Exception decompiling
     */
    public Change.Id cherryPick(Change change, PatchSet patch, String message, String ref, RefControl refControl, int parent) throws NoSuchChangeException, OrmException, MissingObjectException, IncorrectObjectTypeException, IOException, InvalidChangeOperationException, IntegrationException, UpdateException, RestApiException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 32[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Change.Id insertPatchSet(BatchUpdate bu, Repository git, ChangeControl destCtl, CodeReviewCommit cherryPickCommit) throws IOException, OrmException {
        Change destChange = destCtl.getChange();
        PatchSet.Id psId = ChangeUtil.nextPatchSetId(git, destChange.currentPatchSetId());
        PatchSetInserter inserter = this.patchSetInserterFactory.create(destCtl, psId, cherryPickCommit);
        PatchSet.Id newPatchSetId = inserter.getPatchSetId();
        PatchSet current = this.psUtil.current(this.db.get(), destCtl.getNotes());
        bu.addOp(destChange.getId(), inserter.setMessage("Uploaded patch set " + newPatchSetId.get() + ".").setDraft(current.isDraft()).setNotify(NotifyHandling.NONE));
        return destChange.getId();
    }

    private Change.Id createNewChange(BatchUpdate bu, CodeReviewCommit cherryPickCommit, String refName, String topic, Branch.NameKey sourceBranch) throws OrmException {
        Change.Id changeId = new Change.Id(this.seq.nextChangeId());
        ChangeInserter ins = this.changeInserterFactory.create(changeId, cherryPickCommit, refName).setValidatePolicy(CommitValidators.Policy.GERRIT).setTopic(topic);
        ins.setMessage(this.messageForDestinationChange(ins.getPatchSetId(), sourceBranch));
        bu.insertChange(ins);
        return changeId;
    }

    private String messageForDestinationChange(PatchSet.Id patchSetId, Branch.NameKey sourceBranch) {
        return "Patch Set " + patchSetId.get() + ": Cherry Picked from branch " + sourceBranch.getShortName() + ".";
    }

    private static class AddMessageToSourceChangeOp
    implements BatchUpdateOp {
        private final ChangeMessagesUtil cmUtil;
        private final PatchSet.Id psId;
        private final String destBranch;
        private final ObjectId cherryPickCommit;

        private AddMessageToSourceChangeOp(ChangeMessagesUtil cmUtil, PatchSet.Id psId, String destBranch, ObjectId cherryPickCommit) {
            this.cmUtil = cmUtil;
            this.psId = psId;
            this.destBranch = destBranch;
            this.cherryPickCommit = cherryPickCommit;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException {
            StringBuilder sb = new StringBuilder("Patch Set ").append(this.psId.get()).append(": Cherry Picked").append("\n\n").append("This patchset was cherry picked to branch ").append(this.destBranch).append(" as commit ").append(this.cherryPickCommit.name());
            ChangeMessage changeMessage = ChangeMessagesUtil.newMessage(this.psId, ctx.getUser(), ctx.getWhen(), sb.toString(), "autogenerated:gerrit:cherryPickChange");
            this.cmUtil.addChangeMessage(ctx.getDb(), ctx.getUpdate(this.psId), changeMessage);
            return true;
        }
    }
}

