/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.PatchScript;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.mime.FileTypeRegistry;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import eu.medsea.mimeutil.MimeType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.jgit.errors.LargeObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.NB;

@Singleton
public class FileContentUtil {
    public static final String TEXT_X_GERRIT_COMMIT_MESSAGE = "text/x-gerrit-commit-message";
    public static final String TEXT_X_GERRIT_MERGE_LIST = "text/x-gerrit-merge-list";
    private static final String X_GIT_SYMLINK = "x-git/symlink";
    private static final String X_GIT_GITLINK = "x-git/gitlink";
    private static final int MAX_SIZE = 0x500000;
    private static final String ZIP_TYPE = "application/zip";
    private static final Random rng = new Random();
    private final GitRepositoryManager repoManager;
    private final FileTypeRegistry registry;

    @Inject
    FileContentUtil(GitRepositoryManager repoManager, FileTypeRegistry ftr) {
        this.repoManager = repoManager;
        this.registry = ftr;
    }

    public BinaryResult getContent(ProjectState project, ObjectId revstr, String path) throws ResourceNotFoundException, IOException {
        try (Repository repo = this.openRepository(project);){
            String type;
            byte[] raw;
            ObjectId id;
            FileMode mode;
            RevWalk rw;
            block18: {
                rw = new RevWalk(repo);
                try {
                    RevCommit commit = rw.parseCommit(revstr);
                    ObjectReader reader = rw.getObjectReader();
                    TreeWalk tw = TreeWalk.forPath(reader, path, commit.getTree());
                    if (tw == null) {
                        throw new ResourceNotFoundException();
                    }
                    mode = tw.getFileMode(0);
                    id = tw.getObjectId(0);
                    if (mode != FileMode.GITLINK) break block18;
                    BinaryResult binaryResult = BinaryResult.create(id.name()).setContentType(X_GIT_GITLINK).base64();
                    rw.close();
                    return binaryResult;
                }
                catch (Throwable throwable) {
                    try {
                        rw.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            ObjectLoader obj = repo.open(id, 3);
            try {
                raw = obj.getCachedBytes(0x500000);
            }
            catch (LargeObjectException e) {
                raw = null;
            }
            if (mode == FileMode.SYMLINK) {
                type = X_GIT_SYMLINK;
            } else {
                type = this.registry.getMimeType(path, raw).toString();
                type = FileContentUtil.resolveContentType(project, path, PatchScript.FileMode.FILE, type);
            }
            BinaryResult binaryResult = FileContentUtil.asBinaryResult(raw, obj).setContentType(type).base64();
            rw.close();
            return binaryResult;
        }
    }

    private static BinaryResult asBinaryResult(byte[] raw, final ObjectLoader obj) {
        if (raw != null) {
            return BinaryResult.create(raw);
        }
        BinaryResult result = new BinaryResult(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                obj.copyTo(os);
            }
        };
        result.setContentLength(obj.getSize());
        return result;
    }

    public BinaryResult downloadContent(ProjectState project, ObjectId revstr, String path, @Nullable Integer parent) throws ResourceNotFoundException, IOException {
        try (Repository repo = this.openRepository(project);){
            RevWalk rw = new RevWalk(repo);
            try {
                byte[] raw;
                ObjectReader reader;
                TreeWalk tw;
                String suffix = "new";
                RevCommit commit = rw.parseCommit(revstr);
                if (parent != null && parent > 0) {
                    suffix = commit.getParentCount() == 1 ? "old" : "old" + parent;
                    commit = rw.parseCommit(commit.getParent(parent - 1));
                }
                if ((tw = TreeWalk.forPath(reader = rw.getObjectReader(), path, commit.getTree())) == null) {
                    throw new ResourceNotFoundException();
                }
                int mode = tw.getFileMode(0).getObjectType();
                if (mode != 3) {
                    throw new ResourceNotFoundException();
                }
                ObjectId id = tw.getObjectId(0);
                ObjectLoader obj = repo.open(id, 3);
                try {
                    raw = obj.getCachedBytes(0x500000);
                }
                catch (LargeObjectException e) {
                    raw = null;
                }
                MimeType contentType = this.registry.getMimeType(path, raw);
                BinaryResult binaryResult = this.registry.isSafeInline(contentType) ? this.wrapBlob(path, obj, raw, contentType, suffix) : this.zipBlob(path, obj, commit, suffix);
                rw.close();
                return binaryResult;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private BinaryResult wrapBlob(String path, ObjectLoader obj, byte[] raw, MimeType contentType, @Nullable String suffix) {
        return FileContentUtil.asBinaryResult(raw, obj).setContentType(contentType.toString()).setAttachmentName(FileContentUtil.safeFileName(path, suffix));
    }

    private BinaryResult zipBlob(final String path, final ObjectLoader obj, RevCommit commit, final @Nullable String suffix) {
        final String commitName = commit.getName();
        final long when = (long)commit.getCommitTime() * 1000L;
        return new BinaryResult(){

            @Override
            public void writeTo(OutputStream os) throws IOException {
                try (ZipOutputStream zipOut = new ZipOutputStream(os);){
                    String decoration = FileContentUtil.randSuffix();
                    if (!Strings.isNullOrEmpty(suffix)) {
                        decoration = suffix + '-' + decoration;
                    }
                    ZipEntry e = new ZipEntry(FileContentUtil.safeFileName(path, decoration));
                    e.setComment(commitName + ":" + path);
                    e.setSize(obj.getSize());
                    e.setTime(when);
                    zipOut.putNextEntry(e);
                    obj.copyTo(zipOut);
                    zipOut.closeEntry();
                }
            }
        }.setContentType(ZIP_TYPE).setAttachmentName(FileContentUtil.safeFileName(path, suffix) + ".zip").disableGzip();
    }

    private static String safeFileName(String fileName, @Nullable String suffix) {
        int slash = fileName.lastIndexOf(47);
        if (slash >= 0) {
            fileName = fileName.substring(slash + 1);
        }
        StringBuilder r = new StringBuilder(fileName.length());
        for (int i = 0; i < fileName.length(); ++i) {
            char c = fileName.charAt(i);
            if (c == '_' || c == '-' || c == '.' || c == '@') {
                r.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                r.append(c);
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                r.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                r.append(c);
                continue;
            }
            if (c == ' ' || c == '\n' || c == '\r' || c == '\t') {
                r.append('-');
                continue;
            }
            r.append('_');
        }
        fileName = r.toString();
        int ext = fileName.lastIndexOf(46);
        if (suffix == null) {
            return fileName;
        }
        if (ext <= 0) {
            return fileName + "_" + suffix;
        }
        return fileName.substring(0, ext) + "_" + suffix + fileName.substring(ext);
    }

    private static String randSuffix() {
        Hasher h = Hashing.md5().newHasher();
        byte[] buf = new byte[8];
        NB.encodeInt64(buf, 0, TimeUtil.nowMs());
        h.putBytes(buf);
        rng.nextBytes(buf);
        h.putBytes(buf);
        return h.hash().toString();
    }

    public static String resolveContentType(ProjectState project, String path, PatchScript.FileMode fileMode, String mimeType) {
        switch (fileMode) {
            case FILE: {
                if ("/COMMIT_MSG".equals(path)) {
                    return TEXT_X_GERRIT_COMMIT_MESSAGE;
                }
                if ("/MERGE_LIST".equals(path)) {
                    return TEXT_X_GERRIT_MERGE_LIST;
                }
                if (project != null) {
                    for (ProjectState p : project.tree()) {
                        String t = p.getConfig().getMimeTypes().getMimeType(path);
                        if (t == null) continue;
                        return t;
                    }
                }
                return mimeType;
            }
            case GITLINK: {
                return X_GIT_GITLINK;
            }
            case SYMLINK: {
                return X_GIT_SYMLINK;
            }
        }
        throw new IllegalStateException("file mode: " + (Object)((Object)fileMode));
    }

    private Repository openRepository(ProjectState project) throws RepositoryNotFoundException, IOException {
        return this.repoManager.openRepository(project.getProject().getNameKey());
    }
}

