/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.change.AllowedFormats;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class GetArchive
implements RestReadView<RevisionResource> {
    private final GitRepositoryManager repoManager;
    private final AllowedFormats allowedFormats;
    @Option(name="--format")
    private String format;

    @Inject
    GetArchive(GitRepositoryManager repoManager, AllowedFormats allowedFormats) {
        this.repoManager = repoManager;
        this.allowedFormats = allowedFormats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BinaryResult apply(RevisionResource rsrc) throws BadRequestException, IOException, MethodNotAllowedException {
        if (Strings.isNullOrEmpty(this.format)) {
            throw new BadRequestException("format is not specified");
        }
        final ArchiveFormat f = this.allowedFormats.extensions.get("." + this.format);
        if (f == null) {
            throw new BadRequestException("unknown archive format");
        }
        if (f == ArchiveFormat.ZIP) {
            throw new MethodNotAllowedException("zip format is disabled");
        }
        boolean close = true;
        final Repository repo = this.repoManager.openRepository(rsrc.getControl().getProject().getNameKey());
        try {
            String name;
            RevCommit commit;
            try (RevWalk rw = new RevWalk(repo);){
                commit = rw.parseCommit(ObjectId.fromString(rsrc.getPatchSet().getRevision().get()));
                name = GetArchive.name(f, rw, commit);
            }
            BinaryResult bin = new BinaryResult(){

                @Override
                public void writeTo(OutputStream out) throws IOException {
                    try {
                        new ArchiveCommand(repo).setFormat(f.name()).setTree(commit.getTree()).setOutputStream(out).call();
                    }
                    catch (GitAPIException e) {
                        throw new IOException(e);
                    }
                }

                @Override
                public void close() throws IOException {
                    repo.close();
                }
            };
            bin.disableGzip().setContentType(f.getMimeType()).setAttachmentName(name);
            close = false;
            BinaryResult binaryResult = bin;
            return binaryResult;
        }
        finally {
            if (close) {
                repo.close();
            }
        }
    }

    private static String name(ArchiveFormat format, RevWalk rw, RevCommit commit) throws IOException {
        return String.format("%s%s", rw.getObjectReader().abbreviate(commit, 7).name(), format.getDefaultSuffix());
    }
}

