/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.CommitInfo;
import com.google.gerrit.extensions.restapi.CacheControl;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.kohsuke.args4j.Option;

public class GetCommit
implements RestReadView<RevisionResource> {
    private final GitRepositoryManager repoManager;
    private final ChangeJson.Factory json;
    @Option(name="--links", usage="Include weblinks")
    private boolean addLinks;

    @Inject
    GetCommit(GitRepositoryManager repoManager, ChangeJson.Factory json) {
        this.repoManager = repoManager;
        this.json = json;
    }

    public Response<CommitInfo> apply(RevisionResource rsrc) throws IOException {
        Project.NameKey p = rsrc.getChange().getProject();
        try (Repository repo = this.repoManager.openRepository(p);){
            RevWalk rw = new RevWalk(repo);
            try {
                String rev = rsrc.getPatchSet().getRevision().get();
                RevCommit commit = rw.parseCommit(ObjectId.fromString(rev));
                rw.parseBody(commit);
                CommitInfo info = this.json.noOptions().toCommit(rsrc.getControl(), rw, commit, this.addLinks, true);
                Response<CommitInfo> r = Response.ok(info);
                if (rsrc.isCacheable()) {
                    r.caching(CacheControl.PRIVATE(7L, TimeUnit.DAYS));
                }
                Response<CommitInfo> response = r;
                rw.close();
                return response;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

