/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.gerrit.extensions.api.changes.IncludedInInfo;
import com.google.gerrit.extensions.config.ExternalIncludedIn;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.change.IncludedInResolver;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class IncludedIn {
    private final GitRepositoryManager repoManager;
    private final DynamicSet<ExternalIncludedIn> externalIncludedIn;

    @Inject
    IncludedIn(GitRepositoryManager repoManager, DynamicSet<ExternalIncludedIn> externalIncludedIn) {
        this.repoManager = repoManager;
        this.externalIncludedIn = externalIncludedIn;
    }

    public IncludedInInfo apply(Project.NameKey project, String revisionId) throws RestApiException, IOException {
        try (Repository r = this.repoManager.openRepository(project);){
            RevWalk rw = new RevWalk(r);
            try {
                RevCommit rev;
                rw.setRetainBody(false);
                try {
                    rev = rw.parseCommit(ObjectId.fromString(revisionId));
                }
                catch (IncorrectObjectTypeException err) {
                    throw new BadRequestException(err.getMessage());
                }
                catch (MissingObjectException err) {
                    throw new ResourceConflictException(err.getMessage());
                }
                IncludedInResolver.Result d = IncludedInResolver.resolve(r, rw, rev);
                Multimap external = MultimapBuilder.hashKeys().arrayListValues().build();
                for (ExternalIncludedIn ext : this.externalIncludedIn) {
                    ListMultimap<String, String> extIncludedIns = ext.getIncludedIn(project.get(), rev.name(), d.getTags(), d.getBranches());
                    if (extIncludedIns == null) continue;
                    external.putAll(extIncludedIns);
                }
                IncludedInInfo includedInInfo = new IncludedInInfo(d.getBranches(), d.getTags(), !external.isEmpty() ? external.asMap() : null);
                rw.close();
                return includedInInfo;
            }
            catch (Throwable throwable) {
                try {
                    rw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

