/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.extensions.api.changes.MoveInput;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class Move
implements RestModifyView<ChangeResource, MoveInput> {
    private final Provider<ReviewDb> dbProvider;
    private final ChangeJson.Factory json;
    private final GitRepositoryManager repoManager;
    private final Provider<InternalChangeQuery> queryProvider;
    private final ChangeMessagesUtil cmUtil;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final PatchSetUtil psUtil;

    @Inject
    Move(Provider<ReviewDb> dbProvider, ChangeJson.Factory json, GitRepositoryManager repoManager, Provider<InternalChangeQuery> queryProvider, ChangeMessagesUtil cmUtil, BatchUpdate.Factory batchUpdateFactory, PatchSetUtil psUtil) {
        this.dbProvider = dbProvider;
        this.json = json;
        this.repoManager = repoManager;
        this.queryProvider = queryProvider;
        this.cmUtil = cmUtil;
        this.batchUpdateFactory = batchUpdateFactory;
        this.psUtil = psUtil;
    }

    public ChangeInfo apply(ChangeResource req, MoveInput input) throws RestApiException, OrmException, UpdateException {
        ChangeControl control = req.getControl();
        input.destinationBranch = RefNames.fullName(input.destinationBranch);
        if (!control.canMoveTo(input.destinationBranch, this.dbProvider.get())) {
            throw new AuthException("Move not permitted");
        }
        Op op = new Op(input);
        try (BatchUpdate u = this.batchUpdateFactory.create(this.dbProvider.get(), req.getChange().getProject(), control.getUser(), TimeUtil.nowTs());){
            u.addOp(req.getChange().getId(), op);
            u.execute();
        }
        return this.json.noOptions().format(op.getChange());
    }

    private static String status(Change change) {
        return change != null ? change.getStatus().name().toLowerCase() : "deleted";
    }

    private class Op
    implements BatchUpdateOp {
        private final MoveInput input;
        private Change change;
        private Branch.NameKey newDestKey;

        Op(MoveInput input) {
            this.input = input;
        }

        @Nullable
        public Change getChange() {
            return this.change;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException, ResourceConflictException, RepositoryNotFoundException, IOException {
            this.change = ctx.getChange();
            if (this.change.getStatus() != Change.Status.NEW && this.change.getStatus() != Change.Status.DRAFT) {
                throw new ResourceConflictException("Change is " + Move.status(this.change));
            }
            Project.NameKey projectKey = this.change.getProject();
            this.newDestKey = new Branch.NameKey(projectKey, this.input.destinationBranch);
            Branch.NameKey changePrevDest = this.change.getDest();
            if (changePrevDest.equals(this.newDestKey)) {
                throw new ResourceConflictException("Change is already destined for the specified branch");
            }
            PatchSet.Id patchSetId = this.change.currentPatchSetId();
            try (Repository repo = Move.this.repoManager.openRepository(projectKey);
                 RevWalk revWalk = new RevWalk(repo);){
                RevCommit currPatchsetRevCommit = revWalk.parseCommit(ObjectId.fromString(Move.this.psUtil.current(ctx.getDb(), ctx.getNotes()).getRevision().get()));
                if (currPatchsetRevCommit.getParentCount() > 1) {
                    throw new ResourceConflictException("Merge commit cannot be moved");
                }
                ObjectId refId = repo.resolve(this.input.destinationBranch);
                if (refId == null) {
                    throw new ResourceConflictException("Destination " + this.input.destinationBranch + " not found in the project");
                }
                RevCommit refCommit = revWalk.parseCommit(refId);
                if (revWalk.isMergedInto(currPatchsetRevCommit, refCommit)) {
                    throw new ResourceConflictException("Current patchset revision is reachable from tip of " + this.input.destinationBranch);
                }
            }
            Change.Key changeKey = this.change.getKey();
            if (!ChangeData.asChanges(((InternalChangeQuery)Move.this.queryProvider.get()).byBranchKey(this.newDestKey, changeKey)).isEmpty()) {
                throw new ResourceConflictException("Destination " + this.newDestKey.getShortName() + " has a different change with same change key " + changeKey);
            }
            if (!this.change.currentPatchSetId().equals(patchSetId)) {
                throw new ResourceConflictException("Patch set is not current");
            }
            ChangeUpdate update = ctx.getUpdate(this.change.currentPatchSetId());
            update.setBranch(this.newDestKey.get());
            this.change.setDest(this.newDestKey);
            StringBuilder msgBuf = new StringBuilder();
            msgBuf.append("Change destination moved from ");
            msgBuf.append(changePrevDest.getShortName());
            msgBuf.append(" to ");
            msgBuf.append(this.newDestKey.getShortName());
            if (!Strings.isNullOrEmpty(this.input.message)) {
                msgBuf.append("\n\n");
                msgBuf.append(this.input.message);
            }
            ChangeMessage cmsg = ChangeMessagesUtil.newMessage(ctx, msgBuf.toString(), "autogenerated:gerrit:move");
            Move.this.cmUtil.addChangeMessage(ctx.getDb(), update, cmsg);
            return true;
        }
    }
}

