/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRange;
import com.google.gerrit.extensions.api.changes.AddReviewerInput;
import com.google.gerrit.extensions.api.changes.AddReviewerResult;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.ReviewInput;
import com.google.gerrit.extensions.api.changes.ReviewResult;
import com.google.gerrit.extensions.api.changes.ReviewerInfo;
import com.google.gerrit.extensions.client.Comment;
import com.google.gerrit.extensions.client.ReviewerState;
import com.google.gerrit.extensions.client.Side;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.FixReplacementInfo;
import com.google.gerrit.extensions.common.FixSuggestionInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.FixReplacement;
import com.google.gerrit.reviewdb.client.FixSuggestion;
import com.google.gerrit.reviewdb.client.LabelId;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.change.AutoValue_PostReview_CommentSetEntry;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.change.EmailReviewComments;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.change.PostReviewers;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.extensions.events.CommentAdded;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.LabelVote;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PostReview
implements RestModifyView<RevisionResource, ReviewInput> {
    private static final Logger log = LoggerFactory.getLogger(PostReview.class);
    private final Provider<ReviewDb> db;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final ChangesCollection changes;
    private final ChangeData.Factory changeDataFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil cmUtil;
    private final CommentsUtil commentsUtil;
    private final PatchSetUtil psUtil;
    private final PatchListCache patchListCache;
    private final AccountsCollection accounts;
    private final EmailReviewComments.Factory email;
    private final CommentAdded commentAdded;
    private final PostReviewers postReviewers;
    private final NotesMigration migration;
    private final NotifyUtil notifyUtil;

    @Inject
    PostReview(Provider<ReviewDb> db, BatchUpdate.Factory batchUpdateFactory, ChangesCollection changes, ChangeData.Factory changeDataFactory, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CommentsUtil commentsUtil, PatchSetUtil psUtil, PatchListCache patchListCache, AccountsCollection accounts, EmailReviewComments.Factory email, CommentAdded commentAdded, PostReviewers postReviewers, NotesMigration migration, NotifyUtil notifyUtil) {
        this.db = db;
        this.batchUpdateFactory = batchUpdateFactory;
        this.changes = changes;
        this.changeDataFactory = changeDataFactory;
        this.commentsUtil = commentsUtil;
        this.psUtil = psUtil;
        this.patchListCache = patchListCache;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.accounts = accounts;
        this.email = email;
        this.commentAdded = commentAdded;
        this.postReviewers = postReviewers;
        this.migration = migration;
        this.notifyUtil = notifyUtil;
    }

    public Response<ReviewResult> apply(RevisionResource revision, ReviewInput input) throws RestApiException, UpdateException, OrmException, IOException {
        return this.apply(revision, input, TimeUtil.nowTs());
    }

    public Response<ReviewResult> apply(RevisionResource revision, ReviewInput input, Timestamp ts) throws RestApiException, UpdateException, OrmException, IOException {
        ts = Ordering.natural().max(ts, revision.getChange().getCreatedOn());
        if (revision.getEdit().isPresent()) {
            throw new ResourceConflictException("cannot post review on edit");
        }
        if (input.onBehalfOf != null) {
            revision = this.onBehalfOf(revision, input);
        } else if (input.drafts == null) {
            input.drafts = ReviewInput.DraftHandling.DELETE;
        }
        if (input.labels != null) {
            this.checkLabels(revision, input.strictLabels, input.labels);
        }
        if (input.comments != null) {
            this.cleanUpComments(input.comments);
            this.checkComments(revision, input.comments);
        }
        if (input.robotComments != null) {
            if (!this.migration.readChanges()) {
                throw new MethodNotAllowedException("robot comments not supported");
            }
            this.checkRobotComments(revision, input.robotComments);
        }
        if (input.notify == null) {
            log.warn("notify = null; assuming notify = NONE");
            input.notify = NotifyHandling.NONE;
        }
        ListMultimap<RecipientType, Account.Id> accountsToNotify = this.notifyUtil.resolveAccounts(input.notifyDetails);
        HashMap<String, AddReviewerResult> reviewerJsonResults = null;
        ArrayList<PostReviewers.Addition> reviewerResults = Lists.newArrayList();
        boolean hasError = false;
        boolean confirm = false;
        if (input.reviewers != null) {
            reviewerJsonResults = Maps.newHashMap();
            for (AddReviewerInput reviewerInput : input.reviewers) {
                reviewerInput.notify = NotifyHandling.NONE;
                PostReviewers.Addition result = this.postReviewers.prepareApplication(revision.getChangeResource(), reviewerInput, true);
                reviewerJsonResults.put(reviewerInput.reviewer, result.result);
                if (result.result.error != null) {
                    hasError = true;
                    continue;
                }
                if (result.result.confirm != null) {
                    confirm = true;
                    continue;
                }
                reviewerResults.add(result);
            }
        }
        ReviewResult output = new ReviewResult();
        output.reviewers = reviewerJsonResults;
        if (hasError || confirm) {
            return Response.withStatusCode(400, output);
        }
        output.labels = input.labels;
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db.get(), revision.getChange().getProject(), revision.getUser(), ts);){
            Account.Id id = revision.getUser().getAccountId();
            boolean ccOrReviewer = false;
            if (input.labels != null && !input.labels.isEmpty()) {
                ccOrReviewer = input.labels.values().stream().filter(v -> v != 0).findFirst().isPresent();
            }
            if (!ccOrReviewer) {
                ReviewerSet currentReviewers = this.approvalsUtil.getReviewers(this.db.get(), revision.getChangeResource().getNotes());
                ccOrReviewer = currentReviewers.all().contains(id);
            }
            block6: for (PostReviewers.Addition reviewerResult : reviewerResults) {
                bu.addOp(revision.getChange().getId(), reviewerResult.op);
                if (!ccOrReviewer && reviewerResult.result.reviewers != null) {
                    for (ReviewerInfo reviewerInfo : reviewerResult.result.reviewers) {
                        if (!Objects.equals(id.get(), reviewerInfo._accountId)) continue;
                        ccOrReviewer = true;
                        break;
                    }
                }
                if (ccOrReviewer || reviewerResult.result.ccs == null) continue;
                for (AccountInfo accountInfo : reviewerResult.result.ccs) {
                    if (!Objects.equals(id.get(), accountInfo._accountId)) continue;
                    ccOrReviewer = true;
                    continue block6;
                }
            }
            if (!ccOrReviewer) {
                PostReviewers.Addition selfAddition = this.postReviewers.ccCurrentUser(revision.getUser(), revision);
                bu.addOp(revision.getChange().getId(), selfAddition.op);
            }
            bu.addOp(revision.getChange().getId(), new Op(revision.getPatchSet().getId(), input, accountsToNotify, reviewerResults));
            bu.execute();
            for (PostReviewers.Addition reviewerResult : reviewerResults) {
                reviewerResult.gatherResults();
            }
            this.emailReviewers(revision.getChange(), reviewerResults, input.notify, accountsToNotify);
        }
        return Response.ok(output);
    }

    private void emailReviewers(Change change, List<PostReviewers.Addition> reviewerAdditions, NotifyHandling notify, ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        ArrayList<Account.Id> to = new ArrayList<Account.Id>();
        ArrayList<Account.Id> cc = new ArrayList<Account.Id>();
        for (PostReviewers.Addition addition : reviewerAdditions) {
            if (addition.op.state == ReviewerState.REVIEWER) {
                to.addAll(addition.op.reviewers.keySet());
                continue;
            }
            if (addition.op.state != ReviewerState.CC) continue;
            cc.addAll(addition.op.reviewers.keySet());
        }
        this.postReviewers.emailReviewers(change, to, cc, notify, accountsToNotify);
    }

    private RevisionResource onBehalfOf(RevisionResource rev, ReviewInput in) throws BadRequestException, AuthException, UnprocessableEntityException, OrmException {
        if (in.labels == null || in.labels.isEmpty()) {
            throw new AuthException(String.format("label required to post review on behalf of \"%s\"", in.onBehalfOf));
        }
        if (in.drafts == null) {
            in.drafts = ReviewInput.DraftHandling.KEEP;
        }
        if (in.drafts != ReviewInput.DraftHandling.KEEP) {
            throw new AuthException("not allowed to modify other user's drafts");
        }
        ChangeControl caller = rev.getControl();
        Iterator<Map.Entry<String, Short>> itr = in.labels.entrySet().iterator();
        while (itr.hasNext()) {
            PermissionRange r;
            Map.Entry<String, Short> ent = itr.next();
            LabelType type = caller.getLabelTypes().byLabel(ent.getKey());
            if (type == null && in.strictLabels) {
                throw new BadRequestException(String.format("label \"%s\" is not a configured label", ent.getKey()));
            }
            if (type == null) {
                itr.remove();
                continue;
            }
            if (caller.getUser().isInternalUser() || (r = caller.getRange(Permission.forLabelAs(type.getName()))) != null && !r.isEmpty() && r.contains(ent.getValue().shortValue())) continue;
            throw new AuthException(String.format("not permitted to modify label \"%s\" on behalf of \"%s\"", ent.getKey(), in.onBehalfOf));
        }
        if (in.labels.isEmpty()) {
            throw new AuthException(String.format("label required to post review on behalf of \"%s\"", in.onBehalfOf));
        }
        ChangeControl target = caller.forUser(this.accounts.parseOnBehalfOf(caller.getUser(), in.onBehalfOf));
        if (!target.getRefControl().isVisible()) {
            throw new UnprocessableEntityException(String.format("on_behalf_of account %s cannot see destination ref", target.getUser().getAccountId()));
        }
        return new RevisionResource(this.changes.parse(target), rev.getPatchSet());
    }

    private void checkLabels(RevisionResource revision, boolean strict, Map<String, Short> labels) throws BadRequestException, AuthException {
        ChangeControl ctl = revision.getControl();
        Iterator<Map.Entry<String, Short>> itr = labels.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, Short> ent = itr.next();
            LabelType lt = revision.getControl().getLabelTypes().byLabel(ent.getKey());
            if (lt == null) {
                if (strict) {
                    throw new BadRequestException(String.format("label \"%s\" is not a configured label", ent.getKey()));
                }
                itr.remove();
                continue;
            }
            if (ent.getValue() == null || ent.getValue() == 0) continue;
            if (lt.getValue(ent.getValue()) == null) {
                if (strict) {
                    throw new BadRequestException(String.format("label \"%s\": %d is not a valid value", ent.getKey(), ent.getValue()));
                }
                itr.remove();
                continue;
            }
            String name = lt.getName();
            PermissionRange range = ctl.getRange(Permission.forLabel(name));
            if (range != null && range.contains(ent.getValue().shortValue())) continue;
            if (strict) {
                throw new AuthException(String.format("Applying label \"%s\": %d is restricted", ent.getKey(), ent.getValue()));
            }
            if (range == null || range.isEmpty()) {
                ent.setValue((short)0);
                continue;
            }
            ent.setValue((short)range.squash(ent.getValue().shortValue()));
        }
    }

    private <T extends ReviewInput.CommentInput> void cleanUpComments(Map<String, List<T>> commentsPerPath) {
        Iterator<List<T>> mapValueIterator = commentsPerPath.values().iterator();
        while (mapValueIterator.hasNext()) {
            List<T> comments = mapValueIterator.next();
            if (comments == null) {
                mapValueIterator.remove();
                continue;
            }
            this.cleanUpComments(comments);
            if (!comments.isEmpty()) continue;
            mapValueIterator.remove();
        }
    }

    private <T extends ReviewInput.CommentInput> void cleanUpComments(List<T> comments) {
        Iterator<T> commentsIterator = comments.iterator();
        while (commentsIterator.hasNext()) {
            ReviewInput.CommentInput comment = (ReviewInput.CommentInput)commentsIterator.next();
            if (comment == null) {
                commentsIterator.remove();
                continue;
            }
            comment.message = Strings.nullToEmpty(comment.message).trim();
            if (!comment.message.isEmpty()) continue;
            commentsIterator.remove();
        }
    }

    private <T extends ReviewInput.CommentInput> void checkComments(RevisionResource revision, Map<String, List<T>> commentsPerPath) throws OrmException, BadRequestException {
        Set<String> revisionFilePaths = this.getAffectedFilePaths(revision);
        for (Map.Entry<String, List<T>> entry : commentsPerPath.entrySet()) {
            String path = entry.getKey();
            PatchSet.Id patchSetId = revision.getChange().currentPatchSetId();
            this.ensurePathRefersToAvailableOrMagicFile(path, revisionFilePaths, patchSetId);
            List<T> comments = entry.getValue();
            for (ReviewInput.CommentInput comment : comments) {
                this.ensureLineIsNonNegative(comment.line, path);
                this.ensureCommentNotOnMagicFilesOfAutoMerge(path, comment);
                this.ensureRangeIsValid(path, comment.range);
            }
        }
    }

    private Set<String> getAffectedFilePaths(RevisionResource revision) throws OrmException {
        ChangeData changeData = this.changeDataFactory.create(this.db.get(), revision.getControl());
        return new HashSet<String>(changeData.filePaths(revision.getPatchSet()));
    }

    private void ensurePathRefersToAvailableOrMagicFile(String path, Set<String> availableFilePaths, PatchSet.Id patchSetId) throws BadRequestException {
        if (!availableFilePaths.contains(path) && !Patch.isMagic(path)) {
            throw new BadRequestException(String.format("file %s not found in revision %s", path, patchSetId));
        }
    }

    private void ensureLineIsNonNegative(Integer line, String path) throws BadRequestException {
        if (line != null && line < 0) {
            throw new BadRequestException(String.format("negative line number %d not allowed on %s", line, path));
        }
    }

    private <T extends ReviewInput.CommentInput> void ensureCommentNotOnMagicFilesOfAutoMerge(String path, T comment) throws BadRequestException {
        if (Patch.isMagic(path) && comment.side == Side.PARENT && comment.parent == null) {
            throw new BadRequestException(String.format("cannot comment on %s on auto-merge", path));
        }
    }

    private void checkRobotComments(RevisionResource revision, Map<String, List<ReviewInput.RobotCommentInput>> in) throws BadRequestException, OrmException {
        this.cleanUpComments(in);
        for (Map.Entry e : in.entrySet()) {
            String commentPath = e.getKey();
            for (ReviewInput.RobotCommentInput c : e.getValue()) {
                this.ensureRobotIdIsSet(c.robotId, commentPath);
                this.ensureRobotRunIdIsSet(c.robotRunId, commentPath);
                this.ensureFixSuggestionsAreAddable(c.fixSuggestions, commentPath);
            }
        }
        this.checkComments(revision, in);
    }

    private void ensureRobotIdIsSet(String robotId, String commentPath) throws BadRequestException {
        if (robotId == null) {
            throw new BadRequestException(String.format("robotId is missing for robot comment on %s", commentPath));
        }
    }

    private void ensureRobotRunIdIsSet(String robotRunId, String commentPath) throws BadRequestException {
        if (robotRunId == null) {
            throw new BadRequestException(String.format("robotRunId is missing for robot comment on %s", commentPath));
        }
    }

    private void ensureFixSuggestionsAreAddable(List<FixSuggestionInfo> fixSuggestionInfos, String commentPath) throws BadRequestException {
        if (fixSuggestionInfos == null) {
            return;
        }
        for (FixSuggestionInfo fixSuggestionInfo : fixSuggestionInfos) {
            this.ensureDescriptionIsSet(commentPath, fixSuggestionInfo.description);
            this.ensureFixReplacementsAreAddable(commentPath, fixSuggestionInfo.replacements);
        }
    }

    private void ensureDescriptionIsSet(String commentPath, String description) throws BadRequestException {
        if (description == null) {
            throw new BadRequestException(String.format("A description is required for the suggested fix of the robot comment on %s", commentPath));
        }
    }

    private void ensureFixReplacementsAreAddable(String commentPath, List<FixReplacementInfo> fixReplacementInfos) throws BadRequestException {
        this.ensureReplacementsArePresent(commentPath, fixReplacementInfos);
        for (FixReplacementInfo fixReplacementInfo : fixReplacementInfos) {
            this.ensureReplacementPathIsSet(commentPath, fixReplacementInfo.path);
            this.ensureReplacementPathRefersToFileOfComment(commentPath, fixReplacementInfo.path);
            this.ensureRangeIsSet(commentPath, fixReplacementInfo.range);
            this.ensureRangeIsValid(commentPath, fixReplacementInfo.range);
            this.ensureReplacementStringIsSet(commentPath, fixReplacementInfo.replacement);
        }
    }

    private void ensureReplacementsArePresent(String commentPath, List<FixReplacementInfo> fixReplacementInfos) throws BadRequestException {
        if (fixReplacementInfos == null || fixReplacementInfos.isEmpty()) {
            throw new BadRequestException(String.format("At least one replacement is required for the suggested fix of the robot comment on %s", commentPath));
        }
    }

    private void ensureReplacementPathIsSet(String commentPath, String replacementPath) throws BadRequestException {
        if (replacementPath == null) {
            throw new BadRequestException(String.format("A file path must be given for the replacement of the robot comment on %s", commentPath));
        }
    }

    private void ensureReplacementPathRefersToFileOfComment(String commentPath, String replacementPath) throws BadRequestException {
        if (!Objects.equals(commentPath, replacementPath)) {
            throw new BadRequestException(String.format("Replacements may only be specified for the file %s on which the robot comment was added", commentPath));
        }
    }

    private void ensureRangeIsSet(String commentPath, Comment.Range range) throws BadRequestException {
        if (range == null) {
            throw new BadRequestException(String.format("A range must be given for the replacement of the robot comment on %s", commentPath));
        }
    }

    private void ensureRangeIsValid(String commentPath, Comment.Range range) throws BadRequestException {
        if (range == null) {
            return;
        }
        if (!range.isValid()) {
            throw new BadRequestException(String.format("Range (%s:%s - %s:%s) is not valid for the comment on %s", range.startLine, range.startCharacter, range.endLine, range.endCharacter, commentPath));
        }
    }

    private void ensureReplacementStringIsSet(String commentPath, String replacement) throws BadRequestException {
        if (replacement == null) {
            throw new BadRequestException(String.format("A content for replacement must be indicated for the replacement of the robot comment on %s", commentPath));
        }
    }

    private class Op
    implements BatchUpdateOp {
        private final PatchSet.Id psId;
        private final ReviewInput in;
        private final ListMultimap<RecipientType, Account.Id> accountsToNotify;
        private final List<PostReviewers.Addition> reviewerResults;
        private IdentifiedUser user;
        private ChangeNotes notes;
        private PatchSet ps;
        private ChangeMessage message;
        private List<Comment> comments = new ArrayList<Comment>();
        private List<LabelVote> labelDelta = new ArrayList<LabelVote>();
        private Map<String, Short> approvals = new HashMap<String, Short>();
        private Map<String, Short> oldApprovals = new HashMap<String, Short>();

        private Op(PatchSet.Id psId, ReviewInput in, ListMultimap<RecipientType, Account.Id> accountsToNotify, List<PostReviewers.Addition> reviewerResults) {
            this.psId = psId;
            this.in = in;
            this.accountsToNotify = Preconditions.checkNotNull(accountsToNotify);
            this.reviewerResults = reviewerResults;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws OrmException, ResourceConflictException, UnprocessableEntityException {
            this.user = ctx.getIdentifiedUser();
            this.notes = ctx.getNotes();
            this.ps = PostReview.this.psUtil.get(ctx.getDb(), ctx.getNotes(), this.psId);
            boolean dirty = false;
            dirty |= this.insertComments(ctx);
            dirty |= this.insertRobotComments(ctx);
            dirty |= this.updateLabels(ctx);
            return dirty |= this.insertMessage(ctx);
        }

        @Override
        public void postUpdate(Context ctx) throws OrmException {
            if (this.message == null) {
                return;
            }
            if (this.in.notify.compareTo(NotifyHandling.NONE) > 0 || !this.accountsToNotify.isEmpty()) {
                PostReview.this.email.create(this.in.notify, this.accountsToNotify, this.notes, this.ps, this.user, this.message, this.comments, this.in.message, this.labelDelta).sendAsync();
            }
            PostReview.this.commentAdded.fire(this.notes.getChange(), this.ps, this.user.getAccount(), this.message.getMessage(), this.approvals, this.oldApprovals, ctx.getWhen());
        }

        private boolean insertComments(ChangeContext ctx) throws OrmException, UnprocessableEntityException {
            Map<String, List<ReviewInput.CommentInput>> map = this.in.comments;
            if (map == null) {
                map = Collections.emptyMap();
            }
            Map<Object, Object> drafts = Collections.emptyMap();
            if (!map.isEmpty() || this.in.drafts != ReviewInput.DraftHandling.KEEP) {
                drafts = this.in.drafts == ReviewInput.DraftHandling.PUBLISH_ALL_REVISIONS ? this.changeDrafts(ctx) : this.patchSetDrafts(ctx);
            }
            ArrayList<Comment> toDel = new ArrayList<Comment>();
            ArrayList<Comment> toPublish = new ArrayList<Comment>();
            Set existingIds = this.in.omitDuplicateComments ? this.readExistingComments(ctx) : Collections.emptySet();
            for (Map.Entry<String, List<ReviewInput.CommentInput>> entry : map.entrySet()) {
                String path = entry.getKey();
                for (ReviewInput.CommentInput c : entry.getValue()) {
                    String parent = Url.decode(c.inReplyTo);
                    Comment e = (Comment)drafts.remove(Url.decode(c.id));
                    if (e == null) {
                        e = PostReview.this.commentsUtil.newComment(ctx, path, this.psId, c.side(), c.message, c.unresolved, parent);
                    } else {
                        e.writtenOn = ctx.getWhen();
                        e.side = c.side();
                        e.message = c.message;
                    }
                    CommentsUtil.setCommentRevId(e, PostReview.this.patchListCache, ctx.getChange(), this.ps);
                    e.setLineNbrAndRange(c.line, c.range);
                    e.tag = this.in.tag;
                    if (existingIds.contains(CommentSetEntry.create(e))) continue;
                    toPublish.add(e);
                }
            }
            switch (this.in.drafts) {
                default: {
                    break;
                }
                case DELETE: {
                    toDel.addAll(drafts.values());
                    break;
                }
                case PUBLISH: {
                    for (Comment comment : drafts.values()) {
                        toPublish.add(this.publishComment(ctx, comment, this.ps));
                    }
                    break;
                }
                case PUBLISH_ALL_REVISIONS: {
                    this.publishAllRevisions(ctx, drafts, toPublish);
                }
            }
            ChangeUpdate u = ctx.getUpdate(this.psId);
            PostReview.this.commentsUtil.deleteComments(ctx.getDb(), u, toDel);
            PostReview.this.commentsUtil.putComments(ctx.getDb(), u, PatchLineComment.Status.PUBLISHED, toPublish);
            this.comments.addAll(toPublish);
            return !toDel.isEmpty() || !toPublish.isEmpty();
        }

        private boolean insertRobotComments(ChangeContext ctx) throws OrmException {
            if (this.in.robotComments == null) {
                return false;
            }
            List<RobotComment> newRobotComments = this.getNewRobotComments(ctx);
            PostReview.this.commentsUtil.putRobotComments(ctx.getUpdate(this.psId), newRobotComments);
            this.comments.addAll(newRobotComments);
            return !newRobotComments.isEmpty();
        }

        private List<RobotComment> getNewRobotComments(ChangeContext ctx) throws OrmException {
            ArrayList<RobotComment> toAdd = new ArrayList<RobotComment>(this.in.robotComments.size());
            Set existingIds = this.in.omitDuplicateComments ? this.readExistingRobotComments(ctx) : Collections.emptySet();
            for (Map.Entry<String, List<ReviewInput.RobotCommentInput>> ent : this.in.robotComments.entrySet()) {
                String path = ent.getKey();
                for (ReviewInput.RobotCommentInput c : ent.getValue()) {
                    RobotComment e = this.createRobotCommentFromInput(ctx, path, c);
                    if (existingIds.contains(CommentSetEntry.create(e))) continue;
                    toAdd.add(e);
                }
            }
            return toAdd;
        }

        private RobotComment createRobotCommentFromInput(ChangeContext ctx, String path, ReviewInput.RobotCommentInput robotCommentInput) throws OrmException {
            RobotComment robotComment = PostReview.this.commentsUtil.newRobotComment(ctx, path, this.psId, robotCommentInput.side(), robotCommentInput.message, robotCommentInput.robotId, robotCommentInput.robotRunId);
            robotComment.parentUuid = Url.decode(robotCommentInput.inReplyTo);
            robotComment.url = robotCommentInput.url;
            robotComment.properties = robotCommentInput.properties;
            robotComment.setLineNbrAndRange(robotCommentInput.line, robotCommentInput.range);
            robotComment.tag = this.in.tag;
            CommentsUtil.setCommentRevId(robotComment, PostReview.this.patchListCache, ctx.getChange(), this.ps);
            robotComment.fixSuggestions = this.createFixSuggestionsFromInput(robotCommentInput.fixSuggestions);
            return robotComment;
        }

        private List<FixSuggestion> createFixSuggestionsFromInput(List<FixSuggestionInfo> fixSuggestionInfos) {
            if (fixSuggestionInfos == null) {
                return Collections.emptyList();
            }
            ArrayList<FixSuggestion> fixSuggestions = new ArrayList<FixSuggestion>(fixSuggestionInfos.size());
            for (FixSuggestionInfo fixSuggestionInfo : fixSuggestionInfos) {
                fixSuggestions.add(this.createFixSuggestionFromInput(fixSuggestionInfo));
            }
            return fixSuggestions;
        }

        private FixSuggestion createFixSuggestionFromInput(FixSuggestionInfo fixSuggestionInfo) {
            List<FixReplacement> fixReplacements = this.toFixReplacements(fixSuggestionInfo.replacements);
            String fixId = ChangeUtil.messageUuid();
            return new FixSuggestion(fixId, fixSuggestionInfo.description, fixReplacements);
        }

        private List<FixReplacement> toFixReplacements(List<FixReplacementInfo> fixReplacementInfos) {
            return fixReplacementInfos.stream().map(this::toFixReplacement).collect(Collectors.toList());
        }

        private FixReplacement toFixReplacement(FixReplacementInfo fixReplacementInfo) {
            Comment.Range range = new Comment.Range(fixReplacementInfo.range);
            return new FixReplacement(fixReplacementInfo.path, range, fixReplacementInfo.replacement);
        }

        private Set<CommentSetEntry> readExistingComments(ChangeContext ctx) throws OrmException {
            return PostReview.this.commentsUtil.publishedByChange(ctx.getDb(), ctx.getNotes()).stream().map(CommentSetEntry::create).collect(Collectors.toSet());
        }

        private Set<CommentSetEntry> readExistingRobotComments(ChangeContext ctx) throws OrmException {
            return PostReview.this.commentsUtil.robotCommentsByChange(ctx.getNotes()).stream().map(CommentSetEntry::create).collect(Collectors.toSet());
        }

        private Map<String, Comment> changeDrafts(ChangeContext ctx) throws OrmException {
            HashMap<String, Comment> drafts = new HashMap<String, Comment>();
            for (Comment c : PostReview.this.commentsUtil.draftByChangeAuthor(ctx.getDb(), ctx.getNotes(), this.user.getAccountId())) {
                c.tag = this.in.tag;
                drafts.put(c.key.uuid, c);
            }
            return drafts;
        }

        private Map<String, Comment> patchSetDrafts(ChangeContext ctx) throws OrmException {
            HashMap<String, Comment> drafts = new HashMap<String, Comment>();
            for (Comment c : PostReview.this.commentsUtil.draftByPatchSetAuthor(ctx.getDb(), this.psId, this.user.getAccountId(), ctx.getNotes())) {
                drafts.put(c.key.uuid, c);
            }
            return drafts;
        }

        private Map<String, Short> approvalsByKey(Collection<PatchSetApproval> patchsetApprovals) {
            HashMap<String, Short> labels = new HashMap<String, Short>();
            for (PatchSetApproval psa : patchsetApprovals) {
                labels.put(psa.getLabel(), psa.getValue());
            }
            return labels;
        }

        private Comment publishComment(ChangeContext ctx, Comment c, PatchSet ps) throws OrmException {
            c.writtenOn = ctx.getWhen();
            c.tag = this.in.tag;
            ctx.getUser().updateRealAccountId(c::setRealAuthor);
            CommentsUtil.setCommentRevId(c, PostReview.this.patchListCache, ctx.getChange(), Preconditions.checkNotNull(ps));
            return c;
        }

        private void publishAllRevisions(ChangeContext ctx, Map<String, Comment> drafts, List<Comment> ups) throws OrmException {
            boolean needOtherPatchSets = false;
            for (Comment c : drafts.values()) {
                if (c.key.patchSetId == this.psId.get()) continue;
                needOtherPatchSets = true;
                break;
            }
            ImmutableMap<PatchSet.Id, PatchSet> patchSets = needOtherPatchSets ? PostReview.this.psUtil.byChangeAsMap(ctx.getDb(), ctx.getNotes()) : ImmutableMap.of(this.psId, this.ps);
            for (Comment e : drafts.values()) {
                ups.add(this.publishComment(ctx, e, (PatchSet)patchSets.get(new PatchSet.Id(ctx.getChange().getId(), e.key.patchSetId))));
            }
        }

        private Map<String, Short> getAllApprovals(LabelTypes labelTypes, Map<String, Short> current, Map<String, Short> input) {
            HashMap<String, Short> allApprovals = new HashMap<String, Short>();
            for (LabelType lt : labelTypes.getLabelTypes()) {
                allApprovals.put(lt.getName(), (short)0);
            }
            if (current != null) {
                allApprovals.putAll(current);
            }
            if (input != null) {
                allApprovals.putAll(input);
            }
            return allApprovals;
        }

        private Map<String, Short> getPreviousApprovals(Map<String, Short> allApprovals, Map<String, Short> current) {
            HashMap<String, Short> previous = new HashMap<String, Short>();
            for (Map.Entry<String, Short> approval : allApprovals.entrySet()) {
                if (!current.containsKey(approval.getKey())) {
                    previous.put(approval.getKey(), (short)0);
                    continue;
                }
                previous.put(approval.getKey(), current.get(approval.getKey()));
            }
            return previous;
        }

        private boolean isReviewer(ChangeContext ctx) throws OrmException {
            if (ctx.getAccountId().equals(ctx.getChange().getOwner())) {
                return true;
            }
            for (PostReviewers.Addition addition : this.reviewerResults) {
                if (addition.op.addedReviewers == null) continue;
                for (PatchSetApproval psa : addition.op.addedReviewers) {
                    if (!psa.getAccountId().equals(ctx.getAccountId())) continue;
                    return true;
                }
            }
            ChangeData cd = PostReview.this.changeDataFactory.create((ReviewDb)PostReview.this.db.get(), ctx.getControl());
            ReviewerSet reviewers = cd.reviewers();
            return reviewers.byState(ReviewerStateInternal.REVIEWER).contains(ctx.getAccountId());
        }

        private boolean updateLabels(ChangeContext ctx) throws OrmException, ResourceConflictException {
            Map<String, Short> inLabels = MoreObjects.firstNonNull(this.in.labels, Collections.emptyMap());
            if (inLabels.isEmpty() && ctx.getChange().getStatus().isClosed()) {
                return false;
            }
            ArrayList<PatchSetApproval> del = new ArrayList<PatchSetApproval>();
            ArrayList<PatchSetApproval> ups = new ArrayList<PatchSetApproval>();
            Map<String, PatchSetApproval> current = this.scanLabels(ctx, del);
            LabelTypes labelTypes = ctx.getControl().getLabelTypes();
            Map<String, Short> allApprovals = this.getAllApprovals(labelTypes, this.approvalsByKey(current.values()), inLabels);
            Map<String, Short> previous = this.getPreviousApprovals(allApprovals, this.approvalsByKey(current.values()));
            ChangeUpdate update = ctx.getUpdate(this.psId);
            for (Map.Entry<String, Short> ent : allApprovals.entrySet()) {
                String name = ent.getKey();
                LabelType lt = Preconditions.checkNotNull(labelTypes.byLabel(name), name);
                PatchSetApproval c = current.remove(lt.getName());
                String normName = lt.getName();
                this.approvals.put(normName, (short)0);
                if (ent.getValue() == null || ent.getValue() == 0) {
                    this.oldApprovals.put(normName, null);
                    if (c == null) continue;
                    if (c.getValue() != 0) {
                        this.addLabelDelta(normName, (short)0);
                        this.oldApprovals.put(normName, previous.get(normName));
                    }
                    del.add(c);
                    update.putApproval(normName, (short)0);
                    continue;
                }
                if (c != null && c.getValue() != ent.getValue().shortValue()) {
                    c.setValue(ent.getValue());
                    c.setGranted(ctx.getWhen());
                    c.setTag(this.in.tag);
                    ctx.getUser().updateRealAccountId(c::setRealAccountId);
                    ups.add(c);
                    this.addLabelDelta(normName, c.getValue());
                    this.oldApprovals.put(normName, previous.get(normName));
                    this.approvals.put(normName, c.getValue());
                    update.putApproval(normName, ent.getValue());
                    continue;
                }
                if (c != null && c.getValue() == ent.getValue().shortValue()) {
                    current.put(normName, c);
                    this.oldApprovals.put(normName, null);
                    this.approvals.put(normName, c.getValue());
                    continue;
                }
                if (c != null) continue;
                c = ApprovalsUtil.newApproval(this.psId, this.user, lt.getLabelId(), ent.getValue().shortValue(), ctx.getWhen());
                c.setTag(this.in.tag);
                c.setGranted(ctx.getWhen());
                ups.add(c);
                this.addLabelDelta(normName, c.getValue());
                this.oldApprovals.put(normName, previous.get(normName));
                this.approvals.put(normName, c.getValue());
                update.putReviewer(this.user.getAccountId(), ReviewerStateInternal.REVIEWER);
                update.putApproval(normName, ent.getValue());
            }
            this.validatePostSubmitLabels(ctx, labelTypes, previous, ups, del);
            if (current.isEmpty() && del.isEmpty() && ups.isEmpty() && !this.isReviewer(ctx)) {
                return false;
            }
            this.forceCallerAsReviewer(ctx, current, ups, del);
            ctx.getDb().patchSetApprovals().delete(del);
            ctx.getDb().patchSetApprovals().upsert(ups);
            return !del.isEmpty() || !ups.isEmpty();
        }

        private void validatePostSubmitLabels(ChangeContext ctx, LabelTypes labelTypes, Map<String, Short> previous, List<PatchSetApproval> ups, List<PatchSetApproval> del) throws ResourceConflictException {
            Short prev;
            String normName;
            LabelType lt;
            if (ctx.getChange().getStatus().isOpen()) {
                return;
            }
            if (del.isEmpty() && ups.isEmpty()) {
                return;
            }
            if (ctx.getChange().getStatus() != Change.Status.MERGED) {
                throw new ResourceConflictException("change is closed");
            }
            ArrayList<PatchSetApproval> reduced = new ArrayList<PatchSetApproval>(ups.size() + del.size());
            ArrayList<String> disallowed = new ArrayList<String>(labelTypes.getLabelTypes().size());
            for (PatchSetApproval psa : del) {
                lt = Preconditions.checkNotNull(labelTypes.byLabel(psa.getLabel()));
                normName = lt.getName();
                if (!lt.allowPostSubmit()) {
                    disallowed.add(normName);
                }
                if ((prev = previous.get(normName)) == null || prev == 0) continue;
                reduced.add(psa);
            }
            for (PatchSetApproval psa : ups) {
                lt = Preconditions.checkNotNull(labelTypes.byLabel(psa.getLabel()));
                normName = lt.getName();
                if (!lt.allowPostSubmit()) {
                    disallowed.add(normName);
                }
                if ((prev = previous.get(normName)) == null) continue;
                Preconditions.checkState(prev.shortValue() != psa.getValue());
                if (prev > psa.getValue()) {
                    reduced.add(psa);
                    continue;
                }
                psa.setPostSubmit(true);
            }
            if (!disallowed.isEmpty()) {
                throw new ResourceConflictException("Voting on labels disallowed after submit: " + disallowed.stream().distinct().sorted().collect(Collectors.joining(", ")));
            }
            if (!reduced.isEmpty()) {
                throw new ResourceConflictException("Cannot reduce vote on labels for closed change: " + reduced.stream().map(p -> p.getLabel()).distinct().sorted().collect(Collectors.joining(", ")));
            }
        }

        private void forceCallerAsReviewer(ChangeContext ctx, Map<String, PatchSetApproval> current, List<PatchSetApproval> ups, List<PatchSetApproval> del) {
            if (current.isEmpty() && ups.isEmpty()) {
                if (del.isEmpty()) {
                    LabelId labelId = ctx.getControl().getLabelTypes().getLabelTypes().get(0).getLabelId();
                    PatchSetApproval c = ApprovalsUtil.newApproval(this.psId, this.user, labelId, 0, ctx.getWhen());
                    c.setTag(this.in.tag);
                    c.setGranted(ctx.getWhen());
                    ups.add(c);
                } else {
                    Iterator<PatchSetApproval> i = del.iterator();
                    PatchSetApproval c = i.next();
                    c.setValue((short)0);
                    c.setGranted(ctx.getWhen());
                    i.remove();
                    ups.add(c);
                }
            }
            ctx.getUpdate(ctx.getChange().currentPatchSetId()).putReviewer(this.user.getAccountId(), ReviewerStateInternal.REVIEWER);
        }

        private Map<String, PatchSetApproval> scanLabels(ChangeContext ctx, List<PatchSetApproval> del) throws OrmException {
            LabelTypes labelTypes = ctx.getControl().getLabelTypes();
            HashMap<String, PatchSetApproval> current = new HashMap<String, PatchSetApproval>();
            for (PatchSetApproval a : PostReview.this.approvalsUtil.byPatchSetUser(ctx.getDb(), ctx.getControl(), this.psId, this.user.getAccountId())) {
                if (a.isLegacySubmit()) continue;
                LabelType lt = labelTypes.byLabel(a.getLabelId());
                if (lt != null) {
                    current.put(lt.getName(), a);
                    continue;
                }
                del.add(a);
            }
            return current;
        }

        private boolean insertMessage(ChangeContext ctx) throws OrmException {
            String msg = Strings.nullToEmpty(this.in.message).trim();
            StringBuilder buf = new StringBuilder();
            for (LabelVote d : this.labelDelta) {
                buf.append(" ").append(d.format());
            }
            if (this.comments.size() == 1) {
                buf.append("\n\n(1 comment)");
            } else if (this.comments.size() > 1) {
                buf.append(String.format("\n\n(%d comments)", this.comments.size()));
            }
            if (!msg.isEmpty()) {
                buf.append("\n\n").append(msg);
            }
            if (buf.length() == 0) {
                return false;
            }
            this.message = ChangeMessagesUtil.newMessage(this.psId, this.user, ctx.getWhen(), "Patch Set " + this.psId.get() + ":" + buf, this.in.tag);
            PostReview.this.cmUtil.addChangeMessage(ctx.getDb(), ctx.getUpdate(this.psId), this.message);
            return true;
        }

        private void addLabelDelta(String name, short value) {
            this.labelDelta.add(LabelVote.create(name, value));
        }
    }

    @AutoValue
    static abstract class CommentSetEntry {
        CommentSetEntry() {
        }

        private static CommentSetEntry create(String filename, int patchSetId, Integer line, Side side, HashCode message, Comment.Range range) {
            return new AutoValue_PostReview_CommentSetEntry(filename, patchSetId, line, side, message, range);
        }

        public static CommentSetEntry create(Comment comment) {
            return CommentSetEntry.create(comment.key.filename, comment.key.patchSetId, comment.lineNbr, Side.fromShort(comment.side), Hashing.sha1().hashString(comment.message, StandardCharsets.UTF_8), comment.range);
        }

        abstract String filename();

        abstract int patchSetId();

        @Nullable
        abstract Integer line();

        abstract Side side();

        abstract HashCode message();

        @Nullable
        abstract Comment.Range range();
    }
}

