/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.errors.EmailException;
import com.google.gerrit.extensions.api.changes.RebaseInput;
import com.google.gerrit.extensions.client.ListChangesOption;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.RebaseChangeOp;
import com.google.gerrit.server.change.RebaseUtil;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Rebase
implements RestModifyView<RevisionResource, RebaseInput>,
UiAction<RevisionResource> {
    private static final Logger log = LoggerFactory.getLogger(Rebase.class);
    private static final ImmutableSet<ListChangesOption> OPTIONS = Sets.immutableEnumSet((Enum)ListChangesOption.CURRENT_REVISION, (Enum[])new ListChangesOption[]{ListChangesOption.CURRENT_COMMIT});
    private final BatchUpdate.Factory updateFactory;
    private final GitRepositoryManager repoManager;
    private final RebaseChangeOp.Factory rebaseFactory;
    private final RebaseUtil rebaseUtil;
    private final ChangeJson.Factory json;
    private final Provider<ReviewDb> dbProvider;

    @Inject
    public Rebase(BatchUpdate.Factory updateFactory, GitRepositoryManager repoManager, RebaseChangeOp.Factory rebaseFactory, RebaseUtil rebaseUtil, ChangeJson.Factory json, Provider<ReviewDb> dbProvider) {
        this.updateFactory = updateFactory;
        this.repoManager = repoManager;
        this.rebaseFactory = rebaseFactory;
        this.rebaseUtil = rebaseUtil;
        this.json = json;
        this.dbProvider = dbProvider;
    }

    public ChangeInfo apply(RevisionResource rsrc, RebaseInput input) throws EmailException, OrmException, UpdateException, RestApiException, IOException, NoSuchChangeException {
        ChangeControl control = rsrc.getControl();
        Change change = rsrc.getChange();
        try (Repository repo = this.repoManager.openRepository(change.getProject());
             RevWalk rw = new RevWalk(repo);
             ObjectInserter oi = repo.newObjectInserter();
             BatchUpdate bu = this.updateFactory.create(this.dbProvider.get(), change.getProject(), rsrc.getUser(), TimeUtil.nowTs());){
            if (!control.canRebase(this.dbProvider.get())) {
                throw new AuthException("rebase not permitted");
            }
            if (!change.getStatus().isOpen()) {
                throw new ResourceConflictException("change is " + change.getStatus().name().toLowerCase());
            }
            if (!this.hasOneParent(rw, rsrc.getPatchSet())) {
                throw new ResourceConflictException("cannot rebase merge commits or commit with no ancestor");
            }
            bu.setRepository(repo, rw, oi);
            bu.addOp(change.getId(), this.rebaseFactory.create(control, rsrc.getPatchSet(), this.findBaseRev(rw, rsrc, input)).setForceContentMerge(true).setFireRevisionCreated(true).setValidatePolicy(CommitValidators.Policy.GERRIT));
            bu.execute();
        }
        return this.json.create(OPTIONS).format(change.getProject(), change.getId());
    }

    private String findBaseRev(RevWalk rw, RevisionResource rsrc, RebaseInput input) throws AuthException, ResourceConflictException, OrmException, IOException, NoSuchChangeException {
        if (input == null || input.base == null) {
            return null;
        }
        Change change = rsrc.getChange();
        String str = input.base.trim();
        if (str.equals("")) {
            return change.getDest().get();
        }
        ReviewDb db = this.dbProvider.get();
        RebaseUtil.Base base = this.rebaseUtil.parseBase(rsrc, str);
        if (base == null) {
            throw new ResourceConflictException("base revision is missing: " + str);
        }
        PatchSet.Id baseId = base.patchSet().getId();
        if (!base.control().isPatchVisible(base.patchSet(), db)) {
            throw new AuthException("base revision not accessible: " + str);
        }
        if (change.getId().equals(baseId.getParentKey())) {
            throw new ResourceConflictException("cannot rebase change onto itself");
        }
        Change baseChange = base.control().getChange();
        if (!baseChange.getProject().equals(change.getProject())) {
            throw new ResourceConflictException("base change is in wrong project: " + baseChange.getProject());
        }
        if (!baseChange.getDest().equals(change.getDest())) {
            throw new ResourceConflictException("base change is targeting wrong branch: " + baseChange.getDest());
        }
        if (baseChange.getStatus() == Change.Status.ABANDONED) {
            throw new ResourceConflictException("base change is abandoned: " + baseChange.getKey());
        }
        if (this.isMergedInto(rw, rsrc.getPatchSet(), base.patchSet())) {
            throw new ResourceConflictException("base change " + baseChange.getKey() + " is a descendant of the current change - recursion not allowed");
        }
        return base.patchSet().getRevision().get();
    }

    private boolean isMergedInto(RevWalk rw, PatchSet base, PatchSet tip) throws IOException {
        ObjectId baseId = ObjectId.fromString(base.getRevision().get());
        ObjectId tipId = ObjectId.fromString(tip.getRevision().get());
        return rw.isMergedInto(rw.parseCommit(baseId), rw.parseCommit(tipId));
    }

    private boolean hasOneParent(RevWalk rw, PatchSet ps) throws IOException {
        RevCommit c = rw.parseCommit(ObjectId.fromString(ps.getRevision().get()));
        return c.getParentCount() == 1;
    }

    @Override
    public UiAction.Description getDescription(RevisionResource resource) {
        PatchSet patchSet = resource.getPatchSet();
        Branch.NameKey dest = resource.getChange().getDest();
        boolean canRebase = false;
        try {
            canRebase = resource.getControl().canRebase(this.dbProvider.get());
        }
        catch (OrmException e) {
            log.error("Cannot check canRebase status. Assuming false.", e);
        }
        boolean visible = resource.getChange().getStatus().isOpen() && resource.isCurrent() && canRebase;
        boolean enabled = true;
        if (visible) {
            try (Repository repo = this.repoManager.openRepository(dest.getParentKey());
                 RevWalk rw = new RevWalk(repo);){
                visible = this.hasOneParent(rw, resource.getPatchSet());
                enabled = this.rebaseUtil.canRebase(patchSet, dest, repo, rw);
            }
            catch (IOException e) {
                log.error("Failed to check if patch set can be rebased: " + resource.getPatchSet(), e);
                visible = false;
            }
        }
        UiAction.Description descr = new UiAction.Description().setLabel("Rebase").setTitle("Rebase onto tip of branch or parent change").setVisible(visible).setEnabled(enabled);
        return descr;
    }

    public static class CurrentRevision
    implements RestModifyView<ChangeResource, RebaseInput> {
        private final PatchSetUtil psUtil;
        private final Rebase rebase;

        @Inject
        CurrentRevision(PatchSetUtil psUtil, Rebase rebase) {
            this.psUtil = psUtil;
            this.rebase = rebase;
        }

        public ChangeInfo apply(ChangeResource rsrc, RebaseInput input) throws EmailException, OrmException, UpdateException, RestApiException, IOException {
            PatchSet ps = this.psUtil.current((ReviewDb)this.rebase.dbProvider.get(), rsrc.getNotes());
            if (ps == null) {
                throw new ResourceConflictException("current revision is missing");
            }
            if (!rsrc.getControl().isPatchVisible(ps, (ReviewDb)this.rebase.dbProvider.get())) {
                throw new AuthException("current revision not accessible");
            }
            return this.rebase.apply(new RevisionResource(rsrc, ps), input);
        }
    }
}

