/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.extensions.api.changes.RevertInput;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.webui.UiAction;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.ChangeJson;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.extensions.events.ChangeReverted;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.mail.send.RevertedSender;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.UpdateException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Revert
implements RestModifyView<ChangeResource, RevertInput>,
UiAction<ChangeResource> {
    private static final Logger log = LoggerFactory.getLogger(Revert.class);
    private final Provider<ReviewDb> db;
    private final GitRepositoryManager repoManager;
    private final ChangeInserter.Factory changeInserterFactory;
    private final ChangeMessagesUtil cmUtil;
    private final BatchUpdate.Factory updateFactory;
    private final Sequences seq;
    private final PatchSetUtil psUtil;
    private final RevertedSender.Factory revertedSenderFactory;
    private final ChangeJson.Factory json;
    private final PersonIdent serverIdent;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeReverted changeReverted;

    @Inject
    Revert(Provider<ReviewDb> db, GitRepositoryManager repoManager, ChangeInserter.Factory changeInserterFactory, ChangeMessagesUtil cmUtil, BatchUpdate.Factory updateFactory, Sequences seq, PatchSetUtil psUtil, RevertedSender.Factory revertedSenderFactory, ChangeJson.Factory json, @GerritPersonIdent PersonIdent serverIdent, ApprovalsUtil approvalsUtil, ChangeReverted changeReverted) {
        this.db = db;
        this.repoManager = repoManager;
        this.changeInserterFactory = changeInserterFactory;
        this.cmUtil = cmUtil;
        this.updateFactory = updateFactory;
        this.seq = seq;
        this.psUtil = psUtil;
        this.revertedSenderFactory = revertedSenderFactory;
        this.json = json;
        this.serverIdent = serverIdent;
        this.approvalsUtil = approvalsUtil;
        this.changeReverted = changeReverted;
    }

    public ChangeInfo apply(ChangeResource req, RevertInput input) throws IOException, OrmException, RestApiException, UpdateException, NoSuchChangeException {
        RefControl refControl = req.getControl().getRefControl();
        ProjectControl projectControl = req.getControl().getProjectControl();
        Capable capable = projectControl.canPushToAtLeastOneRef();
        if (capable != Capable.OK) {
            throw new AuthException(capable.getMessage());
        }
        Change change = req.getChange();
        if (!refControl.canUpload()) {
            throw new AuthException("revert not permitted");
        }
        if (change.getStatus() != Change.Status.MERGED) {
            throw new ResourceConflictException("change is " + Revert.status(change));
        }
        Change.Id revertedChangeId = this.revert(req.getControl(), Strings.emptyToNull(input.message));
        return this.json.noOptions().format(req.getProject(), revertedChangeId);
    }

    /*
     * Exception decompiling
     */
    private Change.Id revert(ChangeControl ctl, String message) throws OrmException, IOException, RestApiException, UpdateException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 29[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public UiAction.Description getDescription(ChangeResource resource) {
        return new UiAction.Description().setLabel("Revert").setTitle("Revert the change").setVisible(resource.getChange().getStatus() == Change.Status.MERGED && resource.getControl().getRefControl().canUpload());
    }

    private static String status(Change change) {
        return change != null ? change.getStatus().name().toLowerCase() : "deleted";
    }

    private class PostRevertedMessageOp
    implements BatchUpdateOp {
        private final ObjectId computedChangeId;

        PostRevertedMessageOp(ObjectId computedChangeId) {
            this.computedChangeId = computedChangeId;
        }

        @Override
        public boolean updateChange(ChangeContext ctx) throws Exception {
            Change change = ctx.getChange();
            PatchSet.Id patchSetId = change.currentPatchSetId();
            ChangeMessage changeMessage = ChangeMessagesUtil.newMessage(ctx, "Created a revert of this change as I" + this.computedChangeId.name(), "autogenerated:gerrit:revert");
            Revert.this.cmUtil.addChangeMessage(ctx.getDb(), ctx.getUpdate(patchSetId), changeMessage);
            return true;
        }
    }

    private class NotifyOp
    implements BatchUpdateOp {
        private final Change change;
        private final ChangeInserter ins;

        NotifyOp(Change change, ChangeInserter ins) {
            this.change = change;
            this.ins = ins;
        }

        @Override
        public void postUpdate(Context ctx) throws Exception {
            Revert.this.changeReverted.fire(this.change, this.ins.getChange(), ctx.getWhen());
            Change.Id changeId = this.ins.getChange().getId();
            try {
                RevertedSender cm = Revert.this.revertedSenderFactory.create(ctx.getProject(), changeId);
                cm.setFrom(ctx.getAccountId());
                cm.setChangeMessage(this.ins.getChangeMessage().getMessage(), ctx.getWhen());
                cm.send();
            }
            catch (Exception err) {
                log.error("Cannot send email for revert change " + changeId, err);
            }
        }
    }
}

