/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.restapi.RestResource;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.inject.TypeLiteral;
import java.util.Optional;

public class RevisionResource
implements RestResource,
RestResource.HasETag {
    public static final TypeLiteral<RestView<RevisionResource>> REVISION_KIND = new TypeLiteral<RestView<RevisionResource>>(){};
    private final ChangeResource change;
    private final PatchSet ps;
    private final Optional<ChangeEdit> edit;
    private boolean cacheable = true;

    public RevisionResource(ChangeResource change, PatchSet ps) {
        this(change, ps, Optional.empty());
    }

    public RevisionResource(ChangeResource change, PatchSet ps, Optional<ChangeEdit> edit) {
        this.change = change;
        this.ps = ps;
        this.edit = edit;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public ChangeResource getChangeResource() {
        return this.change;
    }

    public ChangeControl getControl() {
        return this.getChangeResource().getControl();
    }

    public Change getChange() {
        return this.getControl().getChange();
    }

    public Project.NameKey getProject() {
        return this.getChange().getProject();
    }

    public ChangeNotes getNotes() {
        return this.getChangeResource().getNotes();
    }

    public PatchSet getPatchSet() {
        return this.ps;
    }

    @Override
    public String getETag() {
        return this.change.getETag();
    }

    Account.Id getAccountId() {
        return this.getUser().getAccountId();
    }

    CurrentUser getUser() {
        return this.getControl().getUser();
    }

    RevisionResource doNotCache() {
        this.cacheable = false;
        return this;
    }

    public Optional<ChangeEdit> getEdit() {
        return this.edit;
    }

    public String toString() {
        String s = this.ps.getId().toString();
        if (this.edit.isPresent()) {
            s = "edit:" + s;
        }
        return s;
    }

    public boolean isCurrent() {
        return this.ps.getId().equals(this.getChange().currentPatchSetId());
    }
}

