/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.SuggestedReviewerInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.ReviewersUtil;
import com.google.gerrit.server.account.AccountVisibility;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.SuggestReviewers;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.List;
import org.eclipse.jgit.lib.Config;
import org.kohsuke.args4j.Option;

public class SuggestChangeReviewers
extends SuggestReviewers
implements RestReadView<ChangeResource> {
    @Option(name="--exclude-groups", aliases={"-e"}, usage="exclude groups from query")
    boolean excludeGroups;
    private final Provider<CurrentUser> self;

    @Inject
    SuggestChangeReviewers(AccountVisibility av, IdentifiedUser.GenericFactory identifiedUserFactory, Provider<ReviewDb> dbProvider, Provider<CurrentUser> self, @GerritServerConfig Config cfg, ReviewersUtil reviewersUtil) {
        super(av, identifiedUserFactory, dbProvider, cfg, reviewersUtil);
        this.self = self;
    }

    public List<SuggestedReviewerInfo> apply(ChangeResource rsrc) throws AuthException, BadRequestException, OrmException, IOException {
        if (!this.self.get().isIdentifiedUser()) {
            throw new AuthException("Authentication required");
        }
        return this.reviewersUtil.suggestReviewers(rsrc.getNotes(), this, rsrc.getControl().getProjectControl(), this.getVisibility(rsrc), this.excludeGroups);
    }

    private ReviewersUtil.VisibilityControl getVisibility(final ChangeResource rsrc) {
        if (rsrc.getControl().getRefControl().isVisibleByRegisteredUsers()) {
            return new ReviewersUtil.VisibilityControl(){

                @Override
                public boolean isVisibleTo(Account.Id account) throws OrmException {
                    return true;
                }
            };
        }
        return new ReviewersUtil.VisibilityControl(){

            @Override
            public boolean isVisibleTo(Account.Id account) throws OrmException {
                IdentifiedUser who = SuggestChangeReviewers.this.identifiedUserFactory.create(account);
                return rsrc.getControl().forUser(who).isRefVisible();
            }
        };
    }
}

