/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.gerrit.server.securestore.SecureStore;
import org.eclipse.jgit.lib.Config;

class GerritConfig
extends Config {
    private final SecureStore secureStore;

    GerritConfig(Config baseConfig, SecureStore secureStore) {
        super(baseConfig);
        this.secureStore = secureStore;
    }

    @Override
    public String getString(String section, String subsection, String name) {
        String secure = this.secureStore.get(section, subsection, name);
        if (secure != null) {
            return secure;
        }
        return super.getString(section, subsection, name);
    }

    @Override
    public String[] getStringList(String section, String subsection, String name) {
        String[] secure = this.secureStore.getList(section, subsection, name);
        if (secure != null && secure.length > 0) {
            return secure;
        }
        return super.getStringList(section, subsection, name);
    }
}

