/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.config;

import com.google.common.base.Joiner;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.gerrit.extensions.annotations.RequiresAnyCapability;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.server.cache.PersistentCache;
import com.google.gerrit.server.config.CacheResource;
import com.google.gerrit.server.config.ConfigResource;
import com.google.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.kohsuke.args4j.Option;

@RequiresAnyCapability(value={"viewCaches", "maintainServer"})
public class ListCaches
implements RestReadView<ConfigResource> {
    private final DynamicMap<Cache<?, ?>> cacheMap;
    @Option(name="--format", usage="output format")
    private OutputFormat format;

    public ListCaches setFormat(OutputFormat format) {
        this.format = format;
        return this;
    }

    @Inject
    public ListCaches(DynamicMap<Cache<?, ?>> cacheMap) {
        this.cacheMap = cacheMap;
    }

    public Map<String, CacheInfo> getCacheInfos() {
        TreeMap<String, CacheInfo> cacheInfos = new TreeMap<String, CacheInfo>();
        for (DynamicMap.Entry<Cache<?, ?>> entry : this.cacheMap) {
            cacheInfos.put(CacheResource.cacheNameOf(entry.getPluginName(), entry.getExportName()), new CacheInfo(entry.getProvider().get()));
        }
        return cacheInfos;
    }

    @Override
    public Object apply(ConfigResource rsrc) {
        if (this.format == null) {
            return this.getCacheInfos();
        }
        ArrayList<String> cacheNames = new ArrayList<String>();
        for (DynamicMap.Entry<Cache<?, ?>> entry : this.cacheMap) {
            cacheNames.add(CacheResource.cacheNameOf(entry.getPluginName(), entry.getExportName()));
        }
        Collections.sort(cacheNames);
        if (OutputFormat.TEXT_LIST.equals((Object)this.format)) {
            return BinaryResult.create(Joiner.on('\n').join(cacheNames)).base64().setContentType("text/plain").setCharacterEncoding(StandardCharsets.UTF_8);
        }
        return cacheNames;
    }

    public static class HitRatioInfo {
        public Integer mem;
        public Integer disk;

        public void setMem(long value, long total) {
            this.mem = HitRatioInfo.percent(value, total);
        }

        public void setDisk(long value, long total) {
            this.disk = HitRatioInfo.percent(value, total);
        }

        private static Integer percent(long value, long total) {
            if (total <= 0L) {
                return null;
            }
            return (int)(100L * value / total);
        }
    }

    public static class EntriesInfo {
        public Long mem;
        public Long disk;
        public String space;

        public void setMem(long mem) {
            this.mem = mem != 0L ? Long.valueOf(mem) : null;
        }

        public void setDisk(long disk) {
            this.disk = disk != 0L ? Long.valueOf(disk) : null;
        }

        public void setSpace(double value) {
            this.space = EntriesInfo.bytes(value);
        }

        private static String bytes(double value) {
            value /= 1024.0;
            String suffix = "k";
            if (value > 1024.0) {
                value /= 1024.0;
                suffix = "m";
            }
            if (value > 1024.0) {
                value /= 1024.0;
                suffix = "g";
            }
            return String.format("%1$6.2f%2$s", value, suffix).trim();
        }
    }

    public static class CacheInfo {
        public String name;
        public CacheType type;
        public EntriesInfo entries;
        public String averageGet;
        public HitRatioInfo hitRatio;

        public CacheInfo(Cache<?, ?> cache) {
            this(null, cache);
        }

        public CacheInfo(String name, Cache<?, ?> cache) {
            this.name = name;
            CacheStats stat = cache.stats();
            this.entries = new EntriesInfo();
            this.entries.setMem(cache.size());
            this.averageGet = CacheInfo.duration(stat.averageLoadPenalty());
            this.hitRatio = new HitRatioInfo();
            this.hitRatio.setMem(stat.hitCount(), stat.requestCount());
            if (cache instanceof PersistentCache) {
                this.type = CacheType.DISK;
                PersistentCache.DiskStats diskStats = ((PersistentCache)((Object)cache)).diskStats();
                this.entries.setDisk(diskStats.size());
                this.entries.setSpace(diskStats.space());
                this.hitRatio.setDisk(diskStats.hitCount(), diskStats.requestCount());
            } else {
                this.type = CacheType.MEM;
            }
        }

        private static String duration(double ns) {
            if (ns < 0.5) {
                return null;
            }
            String suffix = "ns";
            if (ns >= 1000.0) {
                ns /= 1000.0;
                suffix = "us";
            }
            if (ns >= 1000.0) {
                ns /= 1000.0;
                suffix = "ms";
            }
            if (ns >= 1000.0) {
                ns /= 1000.0;
                suffix = "s";
            }
            return String.format("%4.1f%s", ns, suffix).trim();
        }
    }

    public static enum CacheType {
        MEM,
        DISK;

    }

    public static enum OutputFormat {
        LIST,
        TEXT_LIST;

    }
}

