/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.documentation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QueryDocumentationExecutor {
    private static final Logger log = LoggerFactory.getLogger(QueryDocumentationExecutor.class);
    private static Map<String, Float> WEIGHTS = ImmutableMap.of("title", Float.valueOf(2.0f), "doc", Float.valueOf(1.0f));
    private IndexSearcher searcher;
    private SimpleQueryParser parser;

    @Inject
    public QueryDocumentationExecutor() {
        try {
            Directory dir = this.readIndexDirectory();
            if (dir == null) {
                this.searcher = null;
                this.parser = null;
                return;
            }
            DirectoryReader reader = DirectoryReader.open(dir);
            this.searcher = new IndexSearcher(reader);
            this.parser = new SimpleQueryParser((Analyzer)new StandardAnalyzer(), WEIGHTS);
        }
        catch (IOException e) {
            log.error("Cannot initialize documentation full text index", e);
            this.searcher = null;
            this.parser = null;
        }
    }

    public List<DocResult> doQuery(String q) throws DocQueryException {
        if (!this.isAvailable()) {
            throw new DocQueryException("Documentation search not available");
        }
        Query query = this.parser.parse(q);
        try {
            TopDocs results = this.searcher.search(query, Integer.MAX_VALUE);
            ScoreDoc[] hits = results.scoreDocs;
            int totalHits = results.totalHits;
            ArrayList<DocResult> out = Lists.newArrayListWithCapacity(totalHits);
            for (int i = 0; i < totalHits; ++i) {
                DocResult result = new DocResult();
                Document doc = this.searcher.doc(hits[i].doc);
                result.url = doc.get("url");
                result.title = doc.get("title");
                out.add(result);
            }
            return out;
        }
        catch (IOException e) {
            throw new DocQueryException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Directory readIndexDirectory() throws IOException {
        RAMDirectory dir = new RAMDirectory();
        byte[] buffer = new byte[4096];
        InputStream index = this.getClass().getResourceAsStream("index.zip");
        if (index == null) {
            log.warn("No index available");
            return null;
        }
        try (ZipInputStream zip = new ZipInputStream(index);){
            ZipEntry entry;
            while ((entry = zip.getNextEntry()) != null) {
                IndexOutput out = ((Directory)dir).createOutput(entry.getName(), null);
                try {
                    int count;
                    while ((count = zip.read(buffer)) != -1) {
                        out.writeBytes(buffer, count);
                    }
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
            return dir;
        }
    }

    public boolean isAvailable() {
        return this.parser != null && this.searcher != null;
    }

    public static class DocQueryException
    extends Exception {
        DocQueryException() {
        }

        DocQueryException(String msg) {
            super(msg);
        }

        DocQueryException(String msg, Throwable e) {
            super(msg, e);
        }

        DocQueryException(Throwable e) {
            super(e);
        }
    }

    public static class DocResult {
        public String title;
        public String url;
        public String content;
    }
}

