/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.edit.tree;

import com.google.gerrit.server.edit.tree.AddPath;
import com.google.gerrit.server.edit.tree.TreeModification;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.dircache.DirCacheEditor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;

public class RestoreFileModification
implements TreeModification {
    private final String filePath;

    public RestoreFileModification(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public List<DirCacheEditor.PathEdit> getPathEdits(Repository repository, RevCommit baseCommit) throws IOException {
        if (baseCommit.getParentCount() == 0) {
            DirCacheEditor.DeletePath deletePath = new DirCacheEditor.DeletePath(this.filePath);
            return Collections.singletonList(deletePath);
        }
        RevCommit base = baseCommit.getParent(0);
        try (RevWalk revWalk = new RevWalk(repository);){
            TreeWalk treeWalk;
            block16: {
                revWalk.parseHeaders(base);
                treeWalk = TreeWalk.forPath(revWalk.getObjectReader(), this.filePath, base.getTree());
                try {
                    if (treeWalk != null) break block16;
                    DirCacheEditor.DeletePath deletePath = new DirCacheEditor.DeletePath(this.filePath);
                    List<DirCacheEditor.PathEdit> list = Collections.singletonList(deletePath);
                    if (treeWalk != null) {
                        treeWalk.close();
                    }
                    return list;
                }
                catch (Throwable throwable) {
                    if (treeWalk != null) {
                        try {
                            treeWalk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            AddPath addPath = new AddPath(this.filePath, treeWalk.getFileMode(0), treeWalk.getObjectId(0));
            List<DirCacheEditor.PathEdit> list = Collections.singletonList(addPath);
            if (treeWalk != null) {
                treeWalk.close();
            }
            return list;
        }
    }
}

