/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.events;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Comment;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.client.UserIdentity;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.account.AccountByEmailCache;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.change.ChangeKindCache;
import com.google.gerrit.server.config.CanonicalWebUrl;
import com.google.gerrit.server.data.AccountAttribute;
import com.google.gerrit.server.data.ApprovalAttribute;
import com.google.gerrit.server.data.ChangeAttribute;
import com.google.gerrit.server.data.DependencyAttribute;
import com.google.gerrit.server.data.MessageAttribute;
import com.google.gerrit.server.data.PatchAttribute;
import com.google.gerrit.server.data.PatchSetAttribute;
import com.google.gerrit.server.data.PatchSetCommentAttribute;
import com.google.gerrit.server.data.RefUpdateAttribute;
import com.google.gerrit.server.data.SubmitLabelAttribute;
import com.google.gerrit.server.data.SubmitRecordAttribute;
import com.google.gerrit.server.data.TrackingIdAttribute;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.patch.PatchList;
import com.google.gerrit.server.patch.PatchListCache;
import com.google.gerrit.server.patch.PatchListEntry;
import com.google.gerrit.server.patch.PatchListNotAvailableException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventFactory {
    private static final Logger log = LoggerFactory.getLogger(EventFactory.class);
    private final AccountCache accountCache;
    private final Provider<String> urlProvider;
    private final PatchListCache patchListCache;
    private final AccountByEmailCache byEmailCache;
    private final PersonIdent myIdent;
    private final ChangeData.Factory changeDataFactory;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeKindCache changeKindCache;
    private final Provider<InternalChangeQuery> queryProvider;
    private final SchemaFactory<ReviewDb> schema;

    @Inject
    EventFactory(AccountCache accountCache, @CanonicalWebUrl @Nullable Provider<String> urlProvider, AccountByEmailCache byEmailCache, PatchListCache patchListCache, @GerritPersonIdent PersonIdent myIdent, ChangeData.Factory changeDataFactory, ApprovalsUtil approvalsUtil, ChangeKindCache changeKindCache, Provider<InternalChangeQuery> queryProvider, SchemaFactory<ReviewDb> schema) {
        this.accountCache = accountCache;
        this.urlProvider = urlProvider;
        this.patchListCache = patchListCache;
        this.byEmailCache = byEmailCache;
        this.myIdent = myIdent;
        this.changeDataFactory = changeDataFactory;
        this.approvalsUtil = approvalsUtil;
        this.changeKindCache = changeKindCache;
        this.queryProvider = queryProvider;
        this.schema = schema;
    }

    public ChangeAttribute asChangeAttribute(Change change) {
        ChangeAttribute changeAttribute;
        block8: {
            ReviewDb db = this.schema.open();
            try {
                changeAttribute = this.asChangeAttribute(db, change);
                if (db == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (db != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OrmException e) {
                    log.error("Cannot open database connection", e);
                    return new ChangeAttribute();
                }
            }
            db.close();
        }
        return changeAttribute;
    }

    public ChangeAttribute asChangeAttribute(ReviewDb db, Change change) {
        ChangeAttribute a = new ChangeAttribute();
        a.project = change.getProject().get();
        a.branch = change.getDest().getShortName();
        a.topic = change.getTopic();
        a.id = change.getKey().get();
        a.number = change.getId().get();
        a.subject = change.getSubject();
        try {
            a.commitMessage = this.changeDataFactory.create(db, change).commitMessage();
        }
        catch (Exception e) {
            log.error("Error while getting full commit message for change {}", (Object)a.number, (Object)e);
        }
        a.url = this.getChangeUrl(change);
        a.owner = this.asAccountAttribute(change.getOwner());
        a.assignee = this.asAccountAttribute(change.getAssignee());
        a.status = change.getStatus();
        a.createdOn = change.getCreatedOn().getTime() / 1000L;
        return a;
    }

    public RefUpdateAttribute asRefUpdateAttribute(ObjectId oldId, ObjectId newId, Branch.NameKey refName) {
        RefUpdateAttribute ru = new RefUpdateAttribute();
        ru.newRev = newId != null ? newId.getName() : ObjectId.zeroId().getName();
        ru.oldRev = oldId != null ? oldId.getName() : ObjectId.zeroId().getName();
        ru.project = refName.getParentKey().get();
        ru.refName = refName.get();
        return ru;
    }

    public void extend(ChangeAttribute a, Change change) {
        a.lastUpdated = change.getLastUpdatedOn().getTime() / 1000L;
        a.open = change.getStatus().isOpen();
    }

    public void addAllReviewers(ReviewDb db, ChangeAttribute a, ChangeNotes notes) throws OrmException {
        ImmutableSet<Account.Id> reviewers = this.approvalsUtil.getReviewers(db, notes).all();
        if (!reviewers.isEmpty()) {
            a.allReviewers = Lists.newArrayListWithCapacity(reviewers.size());
            for (Account.Id id : reviewers) {
                a.allReviewers.add(this.asAccountAttribute(id));
            }
        }
    }

    public void addSubmitRecords(ChangeAttribute ca, List<SubmitRecord> submitRecords) {
        ca.submitRecords = new ArrayList<SubmitRecordAttribute>();
        for (SubmitRecord submitRecord : submitRecords) {
            SubmitRecordAttribute sa = new SubmitRecordAttribute();
            sa.status = submitRecord.status.name();
            if (submitRecord.status != SubmitRecord.Status.RULE_ERROR) {
                this.addSubmitRecordLabels(submitRecord, sa);
            }
            ca.submitRecords.add(sa);
        }
        if (ca.submitRecords.isEmpty()) {
            ca.submitRecords = null;
        }
    }

    private void addSubmitRecordLabels(SubmitRecord submitRecord, SubmitRecordAttribute sa) {
        if (submitRecord.labels != null && !submitRecord.labels.isEmpty()) {
            sa.labels = new ArrayList<SubmitLabelAttribute>();
            for (SubmitRecord.Label lbl : submitRecord.labels) {
                SubmitLabelAttribute la = new SubmitLabelAttribute();
                la.label = lbl.label;
                la.status = lbl.status.name();
                if (lbl.appliedBy != null) {
                    Account a = this.accountCache.get(lbl.appliedBy).getAccount();
                    la.by = this.asAccountAttribute(a);
                }
                sa.labels.add(la);
            }
        }
    }

    public void addDependencies(RevWalk rw, ChangeAttribute ca, Change change, PatchSet currentPs) {
        if (change == null || currentPs == null) {
            return;
        }
        ca.dependsOn = new ArrayList<DependencyAttribute>();
        ca.neededBy = new ArrayList<DependencyAttribute>();
        try {
            this.addDependsOn(rw, ca, change, currentPs);
            this.addNeededBy(rw, ca, change, currentPs);
        }
        catch (OrmException | IOException exception) {
            // empty catch block
        }
        if (ca.dependsOn.isEmpty()) {
            ca.dependsOn = null;
        }
        if (ca.neededBy.isEmpty()) {
            ca.neededBy = null;
        }
    }

    private void addDependsOn(RevWalk rw, ChangeAttribute ca, Change change, PatchSet currentPs) throws OrmException, IOException {
        RevCommit commit = rw.parseCommit(ObjectId.fromString(currentPs.getRevision().get()));
        ArrayList<String> parentNames = new ArrayList<String>(commit.getParentCount());
        for (RevCommit p : commit.getParents()) {
            parentNames.add(p.name());
        }
        for (ChangeData cd : this.queryProvider.get().byProjectCommits(change.getProject(), parentNames)) {
            for (PatchSet ps : cd.patchSets()) {
                for (String p : parentNames) {
                    if (!ps.getRevision().get().equals(p)) continue;
                    ca.dependsOn.add(this.newDependsOn(Preconditions.checkNotNull(cd.change()), ps));
                }
            }
        }
        Collections.sort(ca.dependsOn, Comparator.comparing(d -> {
            for (int i = 0; i < parentNames.size(); ++i) {
                if (!((String)parentNames.get(i)).equals(d.revision)) continue;
                return i;
            }
            return parentNames.size() + 1;
        }));
    }

    private void addNeededBy(RevWalk rw, ChangeAttribute ca, Change change, PatchSet currentPs) throws OrmException, IOException {
        if (currentPs.getGroups().isEmpty()) {
            return;
        }
        String rev = currentPs.getRevision().get();
        for (ChangeData cd : this.queryProvider.get().byProjectGroups(change.getProject(), currentPs.getGroups())) {
            block1: for (PatchSet ps : cd.patchSets()) {
                RevCommit commit = rw.parseCommit(ObjectId.fromString(ps.getRevision().get()));
                for (RevCommit p : commit.getParents()) {
                    if (!p.name().equals(rev)) continue;
                    ca.neededBy.add(this.newNeededBy(Preconditions.checkNotNull(cd.change()), ps));
                    continue block1;
                }
            }
        }
    }

    private DependencyAttribute newDependsOn(Change c, PatchSet ps) {
        DependencyAttribute d = this.newDependencyAttribute(c, ps);
        d.isCurrentPatchSet = ps.getId().equals(c.currentPatchSetId());
        return d;
    }

    private DependencyAttribute newNeededBy(Change c, PatchSet ps) {
        return this.newDependencyAttribute(c, ps);
    }

    private DependencyAttribute newDependencyAttribute(Change c, PatchSet ps) {
        DependencyAttribute d = new DependencyAttribute();
        d.number = c.getId().get();
        d.id = c.getKey().toString();
        d.revision = ps.getRevision().get();
        d.ref = ps.getRefName();
        return d;
    }

    public void addTrackingIds(ChangeAttribute a, ListMultimap<String, String> set) {
        if (!set.isEmpty()) {
            a.trackingIds = new ArrayList<TrackingIdAttribute>(set.size());
            for (Map.Entry<String, Collection<String>> e : set.asMap().entrySet()) {
                for (String id : e.getValue()) {
                    TrackingIdAttribute t = new TrackingIdAttribute();
                    t.system = e.getKey();
                    t.id = id;
                    a.trackingIds.add(t);
                }
            }
        }
    }

    public void addCommitMessage(ChangeAttribute a, String commitMessage) {
        a.commitMessage = commitMessage;
    }

    public void addPatchSets(ReviewDb db, RevWalk revWalk, ChangeAttribute ca, Collection<PatchSet> ps, Map<PatchSet.Id, Collection<PatchSetApproval>> approvals, LabelTypes labelTypes) {
        this.addPatchSets(db, revWalk, ca, ps, approvals, false, null, labelTypes);
    }

    public void addPatchSets(ReviewDb db, RevWalk revWalk, ChangeAttribute ca, Collection<PatchSet> ps, Map<PatchSet.Id, Collection<PatchSetApproval>> approvals, boolean includeFiles, Change change, LabelTypes labelTypes) {
        if (!ps.isEmpty()) {
            ca.patchSets = new ArrayList<PatchSetAttribute>(ps.size());
            for (PatchSet p : ps) {
                PatchSetAttribute psa = this.asPatchSetAttribute(db, revWalk, change, p);
                if (approvals != null) {
                    this.addApprovals(psa, p.getId(), approvals, labelTypes);
                }
                ca.patchSets.add(psa);
                if (!includeFiles) continue;
                this.addPatchSetFileNames(psa, change, p);
            }
        }
    }

    public void addPatchSetComments(PatchSetAttribute patchSetAttribute, Collection<Comment> comments) {
        for (Comment comment : comments) {
            if (comment.key.patchSetId != patchSetAttribute.number) continue;
            if (patchSetAttribute.comments == null) {
                patchSetAttribute.comments = new ArrayList<PatchSetCommentAttribute>();
            }
            patchSetAttribute.comments.add(this.asPatchSetLineAttribute(comment));
        }
    }

    public void addPatchSetFileNames(PatchSetAttribute patchSetAttribute, Change change, PatchSet patchSet) {
        try {
            PatchList patchList = this.patchListCache.get(change, patchSet);
            for (PatchListEntry patch : patchList.getPatches()) {
                if (patchSetAttribute.files == null) {
                    patchSetAttribute.files = new ArrayList<PatchAttribute>();
                }
                PatchAttribute p = new PatchAttribute();
                p.file = patch.getNewName();
                p.fileOld = patch.getOldName();
                p.type = patch.getChangeType();
                p.deletions -= patch.getDeletions();
                p.insertions = patch.getInsertions();
                patchSetAttribute.files.add(p);
            }
        }
        catch (PatchListNotAvailableException e) {
            log.error("Cannot get patch list", e);
        }
    }

    public void addComments(ChangeAttribute ca, Collection<ChangeMessage> messages) {
        if (!messages.isEmpty()) {
            ca.comments = new ArrayList<MessageAttribute>();
            for (ChangeMessage message : messages) {
                ca.comments.add(this.asMessageAttribute(message));
            }
        }
    }

    public PatchSetAttribute asPatchSetAttribute(RevWalk revWalk, Change change, PatchSet patchSet) {
        PatchSetAttribute patchSetAttribute;
        block8: {
            ReviewDb db = this.schema.open();
            try {
                patchSetAttribute = this.asPatchSetAttribute(db, revWalk, change, patchSet);
                if (db == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (db != null) {
                        try {
                            db.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (OrmException e) {
                    log.error("Cannot open database connection", e);
                    return new PatchSetAttribute();
                }
            }
            db.close();
        }
        return patchSetAttribute;
    }

    public PatchSetAttribute asPatchSetAttribute(ReviewDb db, RevWalk revWalk, Change change, PatchSet patchSet) {
        PatchSetAttribute p = new PatchSetAttribute();
        p.revision = patchSet.getRevision().get();
        p.number = patchSet.getPatchSetId();
        p.ref = patchSet.getRefName();
        p.uploader = this.asAccountAttribute(patchSet.getUploader());
        p.createdOn = patchSet.getCreatedOn().getTime() / 1000L;
        p.isDraft = patchSet.isDraft();
        PatchSet.Id pId = patchSet.getId();
        try {
            p.parents = new ArrayList<String>();
            RevCommit c = revWalk.parseCommit(ObjectId.fromString(p.revision));
            for (RevCommit parent : c.getParents()) {
                p.parents.add(parent.name());
            }
            UserIdentity author = this.toUserIdentity(c.getAuthorIdent());
            if (author.getAccount() == null) {
                p.author = new AccountAttribute();
                p.author.email = author.getEmail();
                p.author.name = author.getName();
                p.author.username = "";
            } else {
                p.author = this.asAccountAttribute(author.getAccount());
            }
            List<Patch> list = this.patchListCache.get(change, patchSet).toPatchList(pId);
            for (Patch pe : list) {
                if (Patch.isMagic(pe.getFileName())) continue;
                p.sizeDeletions -= pe.getDeletions();
                p.sizeInsertions += pe.getInsertions();
            }
            p.kind = this.changeKindCache.getChangeKind(db, change, patchSet);
        }
        catch (IOException e) {
            log.error("Cannot load patch set data for {}", (Object)patchSet.getId(), (Object)e);
        }
        catch (PatchListNotAvailableException e) {
            log.error("Cannot get size information for {}.", (Object)pId, (Object)e);
        }
        return p;
    }

    private UserIdentity toUserIdentity(PersonIdent who) {
        UserIdentity u = new UserIdentity();
        u.setName(who.getName());
        u.setEmail(who.getEmailAddress());
        u.setDate(new Timestamp(who.getWhen().getTime()));
        u.setTimeZone(who.getTimeZoneOffset());
        Set<Account.Id> a = this.byEmailCache.get(u.getEmail());
        if (a.size() == 1) {
            u.setAccount(a.iterator().next());
        }
        return u;
    }

    public void addApprovals(PatchSetAttribute p, PatchSet.Id id, Map<PatchSet.Id, Collection<PatchSetApproval>> all, LabelTypes labelTypes) {
        Collection<PatchSetApproval> list = all.get(id);
        if (list != null) {
            this.addApprovals(p, list, labelTypes);
        }
    }

    public void addApprovals(PatchSetAttribute p, Collection<PatchSetApproval> list, LabelTypes labelTypes) {
        if (!list.isEmpty()) {
            p.approvals = new ArrayList<ApprovalAttribute>(list.size());
            for (PatchSetApproval a : list) {
                if (a.getValue() == 0) continue;
                p.approvals.add(this.asApprovalAttribute(a, labelTypes));
            }
            if (p.approvals.isEmpty()) {
                p.approvals = null;
            }
        }
    }

    public AccountAttribute asAccountAttribute(Account.Id id) {
        if (id == null) {
            return null;
        }
        return this.asAccountAttribute(this.accountCache.get(id).getAccount());
    }

    public AccountAttribute asAccountAttribute(Account account) {
        if (account == null) {
            return null;
        }
        AccountAttribute who = new AccountAttribute();
        who.name = account.getFullName();
        who.email = account.getPreferredEmail();
        who.username = account.getUserName();
        return who;
    }

    public AccountAttribute asAccountAttribute(PersonIdent ident) {
        AccountAttribute who = new AccountAttribute();
        who.name = ident.getName();
        who.email = ident.getEmailAddress();
        return who;
    }

    public ApprovalAttribute asApprovalAttribute(PatchSetApproval approval, LabelTypes labelTypes) {
        ApprovalAttribute a = new ApprovalAttribute();
        a.type = approval.getLabelId().get();
        a.value = Short.toString(approval.getValue());
        a.by = this.asAccountAttribute(approval.getAccountId());
        a.grantedOn = approval.getGranted().getTime() / 1000L;
        a.oldValue = null;
        LabelType lt = labelTypes.byLabel(approval.getLabelId());
        if (lt != null) {
            a.description = lt.getName();
        }
        return a;
    }

    public MessageAttribute asMessageAttribute(ChangeMessage message) {
        MessageAttribute a = new MessageAttribute();
        a.timestamp = message.getWrittenOn().getTime() / 1000L;
        a.reviewer = message.getAuthor() != null ? this.asAccountAttribute(message.getAuthor()) : this.asAccountAttribute(this.myIdent);
        a.message = message.getMessage();
        return a;
    }

    public PatchSetCommentAttribute asPatchSetLineAttribute(Comment c) {
        PatchSetCommentAttribute a = new PatchSetCommentAttribute();
        a.reviewer = this.asAccountAttribute(c.author.getId());
        a.file = c.key.filename;
        a.line = c.lineNbr;
        a.message = c.message;
        return a;
    }

    private String getChangeUrl(Change change) {
        if (change != null && this.urlProvider.get() != null) {
            StringBuilder r = new StringBuilder();
            r.append(this.urlProvider.get());
            r.append(change.getChangeId());
            return r.toString();
        }
        return null;
    }
}

