/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.extensions.events;

import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.ChangeInfo;
import com.google.gerrit.extensions.events.TopicEditedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.extensions.events.AbstractChangeEvent;
import com.google.gerrit.server.extensions.events.EventUtil;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TopicEdited {
    private static final Logger log = LoggerFactory.getLogger(TopicEdited.class);
    private final DynamicSet<TopicEditedListener> listeners;
    private final EventUtil util;

    @Inject
    TopicEdited(DynamicSet<TopicEditedListener> listeners, EventUtil util) {
        this.listeners = listeners;
        this.util = util;
    }

    public void fire(Change change, Account account, String oldTopicName, Timestamp when) {
        if (!this.listeners.iterator().hasNext()) {
            return;
        }
        try {
            Event event = new Event(this.util.changeInfo(change), this.util.accountInfo(account), oldTopicName, when);
            for (TopicEditedListener l : this.listeners) {
                try {
                    l.onTopicEdited(event);
                }
                catch (Exception e) {
                    this.util.logEventListenerError(this, l, e);
                }
            }
        }
        catch (OrmException e) {
            log.error("Couldn't fire event", e);
        }
    }

    private static class Event
    extends AbstractChangeEvent
    implements TopicEditedListener.Event {
        private final String oldTopic;

        Event(ChangeInfo change, AccountInfo editor, String oldTopic, Timestamp when) {
            super(change, editor, when, NotifyHandling.ALL);
            this.oldTopic = oldTopic;
        }

        @Override
        public String getOldTopic() {
            return this.oldTopic;
        }
    }
}

