/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.auto.value.AutoValue;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.SubmitRecord;
import com.google.gerrit.common.data.SubmitTypeRecord;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.change.NotifyUtil;
import com.google.gerrit.server.git.AutoValue_MergeOp_BranchBatch;
import com.google.gerrit.server.git.ChangeSet;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.git.MergeSuperSet;
import com.google.gerrit.server.git.MergeTip;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.strategy.SubmitStrategy;
import com.google.gerrit.server.git.strategy.SubmitStrategyFactory;
import com.google.gerrit.server.git.strategy.SubmitStrategyListener;
import com.google.gerrit.server.git.validators.MergeValidationException;
import com.google.gerrit.server.git.validators.MergeValidators;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.SubmitRuleOptions;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.RequestId;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MergeOp
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MergeOp.class);
    private static final SubmitRuleOptions SUBMIT_RULE_OPTIONS = SubmitRuleOptions.defaults().build();
    private final ChangeMessagesUtil cmUtil;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final InternalUser.Factory internalUserFactory;
    private final MergeSuperSet mergeSuperSet;
    private final MergeValidators.Factory mergeValidatorsFactory;
    private final InternalChangeQuery internalChangeQuery;
    private final SubmitStrategyFactory submitStrategyFactory;
    private final SubmoduleOp.Factory subOpFactory;
    private final MergeOpRepoManager orm;
    private final NotifyUtil notifyUtil;
    private Timestamp ts;
    private RequestId submissionId;
    private IdentifiedUser caller;
    private CommitStatus commitStatus;
    private ReviewDb db;
    private SubmitInput submitInput;
    private ListMultimap<RecipientType, Account.Id> accountsToNotify;
    private Set<Project.NameKey> allProjects;
    private boolean dryrun;

    @Inject
    MergeOp(ChangeMessagesUtil cmUtil, BatchUpdate.Factory batchUpdateFactory, InternalUser.Factory internalUserFactory, MergeSuperSet mergeSuperSet, MergeValidators.Factory mergeValidatorsFactory, InternalChangeQuery internalChangeQuery, SubmitStrategyFactory submitStrategyFactory, SubmoduleOp.Factory subOpFactory, MergeOpRepoManager orm, NotifyUtil notifyUtil) {
        this.cmUtil = cmUtil;
        this.batchUpdateFactory = batchUpdateFactory;
        this.internalUserFactory = internalUserFactory;
        this.mergeSuperSet = mergeSuperSet;
        this.mergeValidatorsFactory = mergeValidatorsFactory;
        this.internalChangeQuery = internalChangeQuery;
        this.submitStrategyFactory = submitStrategyFactory;
        this.subOpFactory = subOpFactory;
        this.orm = orm;
        this.notifyUtil = notifyUtil;
    }

    @Override
    public void close() {
        this.orm.close();
    }

    public static void checkSubmitRule(ChangeData cd) throws ResourceConflictException, OrmException {
        PatchSet patchSet = cd.currentPatchSet();
        if (patchSet == null) {
            throw new ResourceConflictException("missing current patch set for change " + cd.getId());
        }
        List<SubmitRecord> results = MergeOp.getSubmitRecords(cd);
        if (SubmitRecord.findOkRecord(results).isPresent()) {
            return;
        }
        if (results.isEmpty()) {
            throw new IllegalStateException(String.format("SubmitRuleEvaluator.evaluate for change %s returned empty list for %s in %s", cd.getId(), patchSet.getId(), cd.change().getProject().get()));
        }
        Iterator<SubmitRecord> iterator = results.iterator();
        if (iterator.hasNext()) {
            SubmitRecord record = iterator.next();
            switch (record.status) {
                case CLOSED: {
                    throw new ResourceConflictException("change is closed");
                }
                case RULE_ERROR: {
                    throw new ResourceConflictException("submit rule error: " + record.errorMessage);
                }
                case NOT_READY: {
                    throw new ResourceConflictException(MergeOp.describeLabels(cd, record.labels));
                }
            }
            throw new IllegalStateException(String.format("Unexpected SubmitRecord status %s for %s in %s", new Object[]{record.status, patchSet.getId().getId(), cd.change().getProject().get()}));
        }
        throw new IllegalStateException();
    }

    private static List<SubmitRecord> getSubmitRecords(ChangeData cd) throws OrmException {
        return cd.submitRecords(SUBMIT_RULE_OPTIONS);
    }

    private static String describeLabels(ChangeData cd, List<SubmitRecord.Label> labels) throws OrmException {
        ArrayList<String> labelResults = new ArrayList<String>();
        block6: for (SubmitRecord.Label lbl : labels) {
            switch (lbl.status) {
                case OK: 
                case MAY: {
                    continue block6;
                }
                case REJECT: {
                    labelResults.add("blocked by " + lbl.label);
                    continue block6;
                }
                case NEED: {
                    labelResults.add("needs " + lbl.label);
                    continue block6;
                }
                case IMPOSSIBLE: {
                    labelResults.add("needs " + lbl.label + " (check project access)");
                    continue block6;
                }
            }
            throw new IllegalStateException(String.format("Unsupported SubmitRecord.Label %s for %s in %s", lbl, cd.change().currentPatchSetId(), cd.change().getProject()));
        }
        return Joiner.on("; ").join(labelResults);
    }

    private void checkSubmitRulesAndState(ChangeSet cs) throws ResourceConflictException {
        Preconditions.checkArgument(!cs.furtherHiddenChanges(), "checkSubmitRulesAndState called for topic with hidden change");
        for (ChangeData cd : cs.changes()) {
            try {
                if (cd.change().getStatus() != Change.Status.NEW) {
                    this.commitStatus.problem(cd.getId(), "Change " + cd.getId() + " is " + cd.change().getStatus().toString().toLowerCase());
                    continue;
                }
                MergeOp.checkSubmitRule(cd);
            }
            catch (ResourceConflictException e) {
                this.commitStatus.problem(cd.getId(), e.getMessage());
            }
            catch (OrmException e) {
                String msg = "Error checking submit rules for change";
                log.warn(msg + " " + cd.getId(), e);
                this.commitStatus.problem(cd.getId(), msg);
            }
        }
        this.commitStatus.maybeFailVerbose();
    }

    private void bypassSubmitRules(ChangeSet cs) {
        Preconditions.checkArgument(!cs.furtherHiddenChanges(), "cannot bypass submit rules for topic with hidden change");
        for (ChangeData cd : cs.changes()) {
            ArrayList<SubmitRecord> records;
            try {
                records = new ArrayList<SubmitRecord>(MergeOp.getSubmitRecords(cd));
            }
            catch (OrmException e) {
                log.warn("Error checking submit rules for change " + cd.getId(), e);
                records = new ArrayList(1);
            }
            SubmitRecord forced = new SubmitRecord();
            forced.status = SubmitRecord.Status.FORCED;
            records.add(forced);
            cd.setSubmitRecords(SUBMIT_RULE_OPTIONS, records);
        }
    }

    public void merge(ReviewDb db, Change change, IdentifiedUser caller, boolean checkSubmitRules, SubmitInput submitInput, boolean dryrun) throws OrmException, RestApiException {
        this.submitInput = submitInput;
        this.accountsToNotify = this.notifyUtil.resolveAccounts(submitInput.notifyDetails);
        this.dryrun = dryrun;
        this.caller = caller;
        this.ts = TimeUtil.nowTs();
        this.submissionId = RequestId.forChange(change);
        this.db = db;
        this.orm.setContext(db, this.ts, caller, this.submissionId);
        this.logDebug("Beginning integration of {}", change);
        try {
            ChangeSet cs = this.mergeSuperSet.setMergeOpRepoManager(this.orm).completeChangeSet(db, change, caller);
            Preconditions.checkState(cs.ids().contains(change.getId()), "change %s missing from %s", (Object)change.getId(), (Object)cs);
            if (cs.furtherHiddenChanges()) {
                throw new AuthException("A change to be submitted with " + change.getId() + " is not visible");
            }
            this.commitStatus = new CommitStatus(cs);
            MergeSuperSet.reloadChanges(cs);
            this.logDebug("Calculated to merge {}", cs);
            if (checkSubmitRules) {
                this.logDebug("Checking submit rules and state", new Object[0]);
                this.checkSubmitRulesAndState(cs);
            } else {
                this.logDebug("Bypassing submit rules", new Object[0]);
                this.bypassSubmitRules(cs);
            }
            try {
                this.integrateIntoHistory(cs);
            }
            catch (IntegrationException e) {
                this.logError("Error from integrateIntoHistory", e);
                throw new ResourceConflictException(e.getMessage(), e);
            }
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    private void integrateIntoHistory(ChangeSet cs) throws IntegrationException, RestApiException {
        ListMultimap<Branch.NameKey, ChangeData> cbb;
        Preconditions.checkArgument(!cs.furtherHiddenChanges(), "cannot integrate hidden changes into history");
        this.logDebug("Beginning merge attempt on {}", cs);
        HashMap<Branch.NameKey, BranchBatch> toSubmit = new HashMap<Branch.NameKey, BranchBatch>();
        try {
            cbb = cs.changesByBranch();
        }
        catch (OrmException e) {
            throw new IntegrationException("Error reading changes to submit", e);
        }
        Set<Branch.NameKey> branches = cbb.keySet();
        for (Branch.NameKey branch : branches) {
            MergeOpRepoManager.OpenRepo or = this.openRepo(branch.getParentKey());
            if (or == null) continue;
            toSubmit.put(branch, this.validateChangeList(or, cbb.get((Object)branch)));
        }
        this.commitStatus.maybeFailVerbose();
        SubmoduleOp submoduleOp = this.subOpFactory.create(branches, this.orm);
        try {
            List<SubmitStrategy> strategies = this.getSubmitStrategies(toSubmit, submoduleOp, this.dryrun);
            this.allProjects = submoduleOp.getProjectsInOrder();
            this.batchUpdateFactory.execute(this.orm.batchUpdates(this.allProjects), new SubmitStrategyListener(this.submitInput, strategies, this.commitStatus), this.submissionId, this.dryrun);
        }
        catch (NoSuchProjectException e) {
            throw new ResourceNotFoundException(e.getMessage());
        }
        catch (SubmoduleException | IOException e) {
            throw new IntegrationException(e);
        }
        catch (UpdateException e) {
            String msg = e.getCause() instanceof IntegrationException ? e.getCause().getMessage() : "Error submitting change" + (cs.size() != 1 ? "s" : "");
            throw new IntegrationException(msg, e);
        }
    }

    public Set<Project.NameKey> getAllProjects() {
        return this.allProjects;
    }

    public MergeOpRepoManager getMergeOpRepoManager() {
        return this.orm;
    }

    private List<SubmitStrategy> getSubmitStrategies(Map<Branch.NameKey, BranchBatch> toSubmit, SubmoduleOp submoduleOp, boolean dryrun) throws IntegrationException, NoSuchProjectException, IOException {
        ArrayList<SubmitStrategy> strategies = new ArrayList<SubmitStrategy>();
        ImmutableSet<Branch.NameKey> allBranches = submoduleOp.getBranchesInOrder();
        Set<CodeReviewCommit> allCommits = toSubmit.values().stream().map(BranchBatch::commits).flatMap(Collection::stream).collect(Collectors.toSet());
        for (Branch.NameKey branch : allBranches) {
            MergeOpRepoManager.OpenRepo or = this.orm.getRepo(branch.getParentKey());
            if (toSubmit.containsKey(branch)) {
                BranchBatch submitting = toSubmit.get(branch);
                MergeOpRepoManager.OpenBranch ob = or.getBranch(branch);
                Preconditions.checkNotNull(submitting.submitType(), "null submit type for %s; expected to previously fail fast", (Object)submitting);
                Set<CodeReviewCommit> commitsToSubmit = submitting.commits();
                ob.mergeTip = new MergeTip(ob.oldTip, commitsToSubmit);
                SubmitStrategy strategy = this.submitStrategyFactory.create(submitting.submitType(), this.db, or.repo, or.rw, or.ins, or.canMergeFlag, this.getAlreadyAccepted(or, ob.oldTip), allCommits, branch, this.caller, ob.mergeTip, this.commitStatus, this.submissionId, this.submitInput.notify, this.accountsToNotify, submoduleOp, dryrun);
                strategies.add(strategy);
                strategy.addOps(or.getUpdate(), commitsToSubmit);
                if (!submitting.submitType().equals((Object)SubmitType.FAST_FORWARD_ONLY) || !submoduleOp.hasSubscription(branch)) continue;
                submoduleOp.addOp(or.getUpdate(), branch);
                continue;
            }
            submoduleOp.addOp(or.getUpdate(), branch);
        }
        return strategies;
    }

    private Set<RevCommit> getAlreadyAccepted(MergeOpRepoManager.OpenRepo or, CodeReviewCommit branchTip) throws IntegrationException {
        HashSet<RevCommit> alreadyAccepted = new HashSet<RevCommit>();
        if (branchTip != null) {
            alreadyAccepted.add(branchTip);
        }
        try {
            for (Ref r : or.repo.getRefDatabase().getRefs("refs/heads/").values()) {
                try {
                    CodeReviewCommit aac = or.rw.parseCommit(r.getObjectId());
                    if (this.commitStatus.commits.values().contains(aac)) continue;
                    alreadyAccepted.add(aac);
                }
                catch (IncorrectObjectTypeException incorrectObjectTypeException) {}
            }
        }
        catch (IOException e) {
            throw new IntegrationException("Failed to determine already accepted commits.", e);
        }
        this.logDebug("Found {} existing heads", alreadyAccepted.size());
        return alreadyAccepted;
    }

    private BranchBatch validateChangeList(MergeOpRepoManager.OpenRepo or, Collection<ChangeData> submitted) throws IntegrationException {
        this.logDebug("Validating {} changes", submitted.size());
        LinkedHashSet<CodeReviewCommit> toSubmit = new LinkedHashSet<CodeReviewCommit>(submitted.size());
        SetMultimap<ObjectId, PatchSet.Id> revisions = this.getRevisions(or, submitted);
        SubmitType submitType = null;
        ChangeData choseSubmitTypeFrom = null;
        for (ChangeData cd : submitted) {
            CodeReviewCommit commit;
            ObjectId id;
            PatchSet ps;
            Change chg;
            ChangeControl ctl;
            Change.Id changeId = cd.getId();
            try {
                ctl = cd.changeControl();
                chg = cd.change();
            }
            catch (OrmException e) {
                this.commitStatus.logProblem(changeId, e);
                continue;
            }
            SubmitType st = this.getSubmitType(cd);
            if (st == null) {
                this.commitStatus.logProblem(changeId, "No submit type for change");
                continue;
            }
            if (submitType == null) {
                submitType = st;
                choseSubmitTypeFrom = cd;
            } else if (st != submitType) {
                this.commitStatus.problem(changeId, String.format("Change has submit type %s, but previously chose submit type %s from change %s in the same batch", new Object[]{st, submitType, choseSubmitTypeFrom.getId()}));
                continue;
            }
            if (chg.currentPatchSetId() == null) {
                String msg = "Missing current patch set on change";
                this.logError(msg + " " + changeId);
                this.commitStatus.problem(changeId, msg);
                continue;
            }
            Branch.NameKey destBranch = chg.getDest();
            try {
                ps = cd.currentPatchSet();
            }
            catch (OrmException e) {
                this.commitStatus.logProblem(changeId, e);
                continue;
            }
            if (ps == null || ps.getRevision() == null || ps.getRevision().get() == null) {
                this.commitStatus.logProblem(changeId, "Missing patch set or revision on change");
                continue;
            }
            String idstr = ps.getRevision().get();
            try {
                id = ObjectId.fromString(idstr);
            }
            catch (IllegalArgumentException e) {
                this.commitStatus.logProblem(changeId, e);
                continue;
            }
            if (!revisions.containsEntry(id, ps.getId())) {
                this.commitStatus.logProblem(changeId, "Revision " + idstr + " of patch set " + ps.getPatchSetId() + " does not match " + ps.getId().toRefName() + " for change");
                continue;
            }
            try {
                commit = or.rw.parseCommit(id);
            }
            catch (IOException e) {
                this.commitStatus.logProblem(changeId, e);
                continue;
            }
            commit.setControl(ctl);
            commit.setPatchsetId(ps.getId());
            this.commitStatus.put(commit);
            MergeValidators mergeValidators = this.mergeValidatorsFactory.create();
            try {
                mergeValidators.validatePreMerge(or.repo, commit, or.project, destBranch, ps.getId(), this.caller);
            }
            catch (MergeValidationException mve) {
                this.commitStatus.problem(changeId, mve.getMessage());
                continue;
            }
            commit.add(or.canMergeFlag);
            toSubmit.add(commit);
        }
        this.logDebug("Submitting on this run: {}", toSubmit);
        return new AutoValue_MergeOp_BranchBatch(submitType, toSubmit);
    }

    private SetMultimap<ObjectId, PatchSet.Id> getRevisions(MergeOpRepoManager.OpenRepo or, Collection<ChangeData> cds) throws IntegrationException {
        try {
            ArrayList<String> refNames = new ArrayList<String>(cds.size());
            for (ChangeData cd : cds) {
                Change c = cd.change();
                if (c == null) continue;
                refNames.add(c.currentPatchSetId().toRefName());
            }
            Multimap revisions = MultimapBuilder.hashKeys(cds.size()).hashSetValues(1).build();
            for (Map.Entry<String, Ref> e : or.repo.getRefDatabase().exactRef(refNames.toArray(new String[refNames.size()])).entrySet()) {
                revisions.put(e.getValue().getObjectId(), PatchSet.Id.fromRef(e.getKey()));
            }
            return revisions;
        }
        catch (OrmException | IOException e) {
            throw new IntegrationException("Failed to validate changes", e);
        }
    }

    private SubmitType getSubmitType(ChangeData cd) {
        try {
            SubmitTypeRecord str = cd.submitTypeRecord();
            return str.isOk() ? str.type : null;
        }
        catch (OrmException e) {
            this.logError("Failed to get submit type for " + cd.getId(), e);
            return null;
        }
    }

    private MergeOpRepoManager.OpenRepo openRepo(Project.NameKey project) throws IntegrationException {
        try {
            return this.orm.getRepo(project);
        }
        catch (NoSuchProjectException e) {
            this.logWarn("Project " + project + " no longer exists, abandoning open changes.");
            this.abandonAllOpenChangeForDeletedProject(project);
        }
        catch (IOException e) {
            throw new IntegrationException("Error opening project " + project, e);
        }
        return null;
    }

    private void abandonAllOpenChangeForDeletedProject(Project.NameKey destProject) {
        try {
            for (ChangeData cd : this.internalChangeQuery.byProjectOpen(destProject)) {
                BatchUpdate bu = this.batchUpdateFactory.create(this.db, destProject, this.internalUserFactory.create(), this.ts);
                try {
                    bu.setRequestId(this.submissionId);
                    bu.addOp(cd.getId(), new BatchUpdateOp(){

                        @Override
                        public boolean updateChange(ChangeContext ctx) throws OrmException {
                            Change change = ctx.getChange();
                            if (!change.getStatus().isOpen()) {
                                return false;
                            }
                            change.setStatus(Change.Status.ABANDONED);
                            ChangeMessage msg = ChangeMessagesUtil.newMessage(change.currentPatchSetId(), MergeOp.this.internalUserFactory.create(), change.getLastUpdatedOn(), "autogenerated:gerrit:merged", "Project was deleted.");
                            MergeOp.this.cmUtil.addChangeMessage(ctx.getDb(), ctx.getUpdate(change.currentPatchSetId()), msg);
                            return true;
                        }
                    });
                    try {
                        bu.execute();
                    }
                    catch (RestApiException | UpdateException e) {
                        this.logWarn("Cannot abandon changes for deleted project " + destProject, e);
                    }
                }
                finally {
                    if (bu == null) continue;
                    bu.close();
                }
            }
        }
        catch (OrmException e) {
            this.logWarn("Cannot abandon changes for deleted project " + destProject, e);
        }
    }

    private void logDebug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.submissionId + msg, args);
        }
    }

    private void logWarn(String msg, Throwable t) {
        if (log.isWarnEnabled()) {
            log.warn(this.submissionId + msg, t);
        }
    }

    private void logWarn(String msg) {
        if (log.isWarnEnabled()) {
            log.warn(this.submissionId + msg);
        }
    }

    private void logError(String msg, Throwable t) {
        if (log.isErrorEnabled()) {
            if (t != null) {
                log.error(this.submissionId + msg, t);
            } else {
                log.error(this.submissionId + msg);
            }
        }
    }

    private void logError(String msg) {
        this.logError(msg, null);
    }

    @AutoValue
    static abstract class BranchBatch {
        BranchBatch() {
        }

        @Nullable
        abstract SubmitType submitType();

        abstract Set<CodeReviewCommit> commits();
    }

    public static class CommitStatus {
        private final ImmutableMap<Change.Id, ChangeData> changes;
        private final ImmutableSetMultimap<Branch.NameKey, Change.Id> byBranch;
        private final Map<Change.Id, CodeReviewCommit> commits;
        private final ListMultimap<Change.Id, String> problems;

        private CommitStatus(ChangeSet cs) throws OrmException {
            Preconditions.checkArgument(!cs.furtherHiddenChanges(), "CommitStatus must not be called with hidden changes");
            this.changes = cs.changesById();
            ImmutableSetMultimap.Builder bb = ImmutableSetMultimap.builder();
            for (ChangeData cd : cs.changes()) {
                bb.put(cd.change().getDest(), cd.getId());
            }
            this.byBranch = bb.build();
            this.commits = new HashMap<Change.Id, CodeReviewCommit>();
            this.problems = MultimapBuilder.treeKeys(Comparator.comparing(Change.Id::get)).arrayListValues(1).build();
        }

        public ImmutableSet<Change.Id> getChangeIds() {
            return this.changes.keySet();
        }

        public ImmutableSet<Change.Id> getChangeIds(Branch.NameKey branch) {
            return this.byBranch.get((Object)branch);
        }

        public CodeReviewCommit get(Change.Id changeId) {
            return this.commits.get(changeId);
        }

        public void put(CodeReviewCommit c) {
            this.commits.put(c.change().getId(), c);
        }

        public void problem(Change.Id id, String problem) {
            this.problems.put(id, problem);
        }

        public void logProblem(Change.Id id, Throwable t) {
            String msg = "Error reading change";
            log.error(msg + " " + id, t);
            this.problems.put(id, msg);
        }

        public void logProblem(Change.Id id, String msg) {
            log.error(msg + " " + id);
            this.problems.put(id, msg);
        }

        public boolean isOk() {
            return this.problems.isEmpty();
        }

        public ImmutableListMultimap<Change.Id, String> getProblems() {
            return ImmutableListMultimap.copyOf(this.problems);
        }

        public List<SubmitRecord> getSubmitRecords(Change.Id id) {
            ChangeData cd = Preconditions.checkNotNull(this.changes.get(id), "ChangeData for %s", (Object)id);
            return Preconditions.checkNotNull(cd.getSubmitRecords(SUBMIT_RULE_OPTIONS), "getSubmitRecord only valid after submit rules are evalutated");
        }

        public void maybeFailVerbose() throws ResourceConflictException {
            if (this.isOk()) {
                return;
            }
            String msg = "Failed to submit " + this.changes.size() + " change" + (this.changes.size() > 1 ? "s" : "") + " due to the following problems:\n";
            ArrayList<String> ps = new ArrayList<String>(this.problems.keySet().size());
            for (Change.Id id : this.problems.keySet()) {
                ps.add("Change " + id + ": " + Joiner.on("; ").join(this.problems.get((Object)id)));
            }
            throw new ResourceConflictException(msg + Joiner.on('\n').join(ps));
        }

        public void maybeFail(String msgPrefix) throws ResourceConflictException {
            if (this.isOk()) {
                return;
            }
            StringBuilder msg = new StringBuilder(msgPrefix).append(" of change");
            Set ids = this.problems.keySet();
            if (ids.size() == 1) {
                msg.append(" ").append(ids.iterator().next());
            } else {
                msg.append("s ").append(Joiner.on(", ").join(ids));
            }
            throw new ResourceConflictException(msg.toString());
        }
    }
}

