/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.util.concurrent.CheckedFuture;
import com.google.gerrit.common.FooterConstants;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.api.changes.HashtagsInput;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.api.projects.ProjectConfigEntryType;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.Sequences;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.change.ChangeInserter;
import com.google.gerrit.server.change.HashtagsUtil;
import com.google.gerrit.server.change.SetHashtagsOp;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.config.PluginConfig;
import com.google.gerrit.server.config.ProjectConfigEntry;
import com.google.gerrit.server.edit.ChangeEdit;
import com.google.gerrit.server.edit.ChangeEditUtil;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.extensions.events.GitReferenceUpdated;
import com.google.gerrit.server.git.BanCommit;
import com.google.gerrit.server.git.ChangeProgressOp;
import com.google.gerrit.server.git.ChangeReportFormatter;
import com.google.gerrit.server.git.GroupCollector;
import com.google.gerrit.server.git.HackPushNegotiateHook;
import com.google.gerrit.server.git.LazyPostReceiveHookChain;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.git.MergedByPushOp;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.git.ReceiveCommitsAdvertiseRefsHook;
import com.google.gerrit.server.git.ReceiveConfig;
import com.google.gerrit.server.git.ReceivePackInitializer;
import com.google.gerrit.server.git.ReplaceOp;
import com.google.gerrit.server.git.SearchingChangeCacheImpl;
import com.google.gerrit.server.git.SubmoduleException;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.TransferConfig;
import com.google.gerrit.server.git.ValidationError;
import com.google.gerrit.server.git.VisibleRefFilter;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidationMessage;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.git.validators.RefOperationValidationException;
import com.google.gerrit.server.git.validators.RefOperationValidators;
import com.google.gerrit.server.git.validators.ValidationMessage;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.mail.MailUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.ssh.SshInfo;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.update.BatchUpdateOp;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.UpdateException;
import com.google.gerrit.server.util.LabelVote;
import com.google.gerrit.server.util.MagicBranch;
import com.google.gerrit.server.util.RequestId;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gerrit.util.cli.CmdLineParser;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.BatchRefUpdate;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.FooterLine;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevSort;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.RevFilter;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.AdvertiseRefsHookChain;
import org.eclipse.jgit.transport.BaseReceivePack;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.UploadPack;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceiveCommits {
    private static final Logger log = LoggerFactory.getLogger(ReceiveCommits.class);
    public static final Pattern NEW_PATCHSET = Pattern.compile("^refs/changes/(?:[0-9][0-9]/)?([1-9][0-9]*)(?:/[1-9][0-9]*)?$");
    private static final String COMMAND_REJECTION_MESSAGE_FOOTER = "Please read the documentation and contact an administrator\nif you feel the configuration is incorrect";
    private static final String SAME_CHANGE_ID_IN_MULTIPLE_CHANGES = "same Change-Id in multiple changes.\nSquash the commits with the same Change-Id or ensure Change-Ids are unique for each commit";
    private static final Function<Exception, RestApiException> INSERT_EXCEPTION = new Function<Exception, RestApiException>(){

        @Override
        public RestApiException apply(Exception input) {
            if (input instanceof RestApiException) {
                return (RestApiException)input;
            }
            if (input instanceof ExecutionException && input.getCause() instanceof RestApiException) {
                return (RestApiException)input.getCause();
            }
            return new RestApiException("Error inserting change/patchset", input);
        }
    };
    private Set<Account.Id> reviewersFromCommandLine = Sets.newLinkedHashSet();
    private Set<Account.Id> ccFromCommandLine = Sets.newLinkedHashSet();
    private final IdentifiedUser user;
    private final ReviewDb db;
    private final Sequences seq;
    private final Provider<InternalChangeQuery> queryProvider;
    private final ChangeNotes.Factory notesFactory;
    private final AccountResolver accountResolver;
    private final CmdLineParser.Factory optionParserFactory;
    private final GitReferenceUpdated gitRefUpdated;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final PatchSetUtil psUtil;
    private final ProjectCache projectCache;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final RefOperationValidators.Factory refValidatorsFactory;
    private final TagCache tagCache;
    private final AccountCache accountCache;
    private final ChangeInserter.Factory changeInserterFactory;
    private final RequestScopePropagator requestScopePropagator;
    private final SshInfo sshInfo;
    private final AllProjectsName allProjectsName;
    private final ReceiveConfig receiveConfig;
    private final DynamicSet<ReceivePackInitializer> initializers;
    private final BatchUpdate.Factory batchUpdateFactory;
    private final SetHashtagsOp.Factory hashtagsFactory;
    private final ReplaceOp.Factory replaceOpFactory;
    private final MergedByPushOp.Factory mergedByPushOpFactory;
    private final ProjectControl projectControl;
    private final Project project;
    private final LabelTypes labelTypes;
    private final Repository repo;
    private final ReceivePack rp;
    private final NoteMap rejectCommits;
    private final RequestId receiveId;
    private MagicBranchInput magicBranch;
    private boolean newChangeForAllNotInTarget;
    private final ListMultimap<String, String> pushOptions = LinkedListMultimap.create();
    private List<CreateRequest> newChanges = Collections.emptyList();
    private final Map<Change.Id, ReplaceRequest> replaceByChange = new LinkedHashMap<Change.Id, ReplaceRequest>();
    private final List<UpdateGroupsRequest> updateGroups = new ArrayList<UpdateGroupsRequest>();
    private final Set<ObjectId> validCommits = new HashSet<ObjectId>();
    private ListMultimap<Change.Id, Ref> refsByChange;
    private ListMultimap<ObjectId, Ref> refsById;
    private Map<String, Ref> allRefs;
    private final SubmoduleOp.Factory subOpFactory;
    private final Provider<MergeOp> mergeOpProvider;
    private final Provider<MergeOpRepoManager> ormProvider;
    private final DynamicMap<ProjectConfigEntry> pluginConfigEntries;
    private final NotesMigration notesMigration;
    private final ChangeEditUtil editUtil;
    private final ChangeIndexer indexer;
    private final List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
    private ListMultimap<Error, String> errors = LinkedListMultimap.create();
    private MultiProgressMonitor.Task newProgress;
    private MultiProgressMonitor.Task replaceProgress;
    private MultiProgressMonitor.Task closeProgress;
    private MultiProgressMonitor.Task commandProgress;
    private MessageSender messageSender;
    private BatchRefUpdate batch;
    private final ChangeReportFormatter changeFormatter;

    @Inject
    ReceiveCommits(ReviewDb db, Sequences seq, Provider<InternalChangeQuery> queryProvider, ChangeNotes.Factory notesFactory, AccountResolver accountResolver, CmdLineParser.Factory optionParserFactory, GitReferenceUpdated gitRefUpdated, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, ProjectCache projectCache, TagCache tagCache, AccountCache accountCache, @Nullable SearchingChangeCacheImpl changeCache, ChangeInserter.Factory changeInserterFactory, CommitValidators.Factory commitValidatorsFactory, RefOperationValidators.Factory refValidatorsFactory, RequestScopePropagator requestScopePropagator, SshInfo sshInfo, AllProjectsName allProjectsName, ReceiveConfig receiveConfig, TransferConfig transferConfig, DynamicSet<ReceivePackInitializer> initializers, Provider<LazyPostReceiveHookChain> lazyPostReceive, @Assisted ProjectControl projectControl, @Assisted Repository repo, SubmoduleOp.Factory subOpFactory, Provider<MergeOp> mergeOpProvider, Provider<MergeOpRepoManager> ormProvider, DynamicMap<ProjectConfigEntry> pluginConfigEntries, NotesMigration notesMigration, ChangeEditUtil editUtil, ChangeIndexer indexer, BatchUpdate.Factory batchUpdateFactory, SetHashtagsOp.Factory hashtagsFactory, ReplaceOp.Factory replaceOpFactory, MergedByPushOp.Factory mergedByPushOpFactory, DynamicItem<ChangeReportFormatter> changeFormatterProvider) throws IOException {
        this.user = projectControl.getUser().asIdentifiedUser();
        this.db = db;
        this.seq = seq;
        this.queryProvider = queryProvider;
        this.notesFactory = notesFactory;
        this.accountResolver = accountResolver;
        this.optionParserFactory = optionParserFactory;
        this.gitRefUpdated = gitRefUpdated;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.psUtil = psUtil;
        this.projectCache = projectCache;
        this.tagCache = tagCache;
        this.accountCache = accountCache;
        this.changeInserterFactory = changeInserterFactory;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.refValidatorsFactory = refValidatorsFactory;
        this.requestScopePropagator = requestScopePropagator;
        this.sshInfo = sshInfo;
        this.allProjectsName = allProjectsName;
        this.receiveConfig = receiveConfig;
        this.initializers = initializers;
        this.batchUpdateFactory = batchUpdateFactory;
        this.hashtagsFactory = hashtagsFactory;
        this.replaceOpFactory = replaceOpFactory;
        this.mergedByPushOpFactory = mergedByPushOpFactory;
        this.projectControl = projectControl;
        this.labelTypes = projectControl.getLabelTypes();
        this.project = projectControl.getProject();
        this.repo = repo;
        this.rp = new ReceivePack(repo);
        this.rejectCommits = BanCommit.loadRejectCommitsMap(repo, this.rp.getRevWalk());
        this.receiveId = RequestId.forProject(this.project.getNameKey());
        this.subOpFactory = subOpFactory;
        this.mergeOpProvider = mergeOpProvider;
        this.ormProvider = ormProvider;
        this.pluginConfigEntries = pluginConfigEntries;
        this.notesMigration = notesMigration;
        this.editUtil = editUtil;
        this.indexer = indexer;
        this.messageSender = new ReceivePackMessageSender();
        this.changeFormatter = changeFormatterProvider.get();
        ProjectState ps = projectControl.getProjectState();
        this.newChangeForAllNotInTarget = ps.isCreateNewChangeForAllNotInTarget();
        this.rp.setAllowCreates(true);
        this.rp.setAllowDeletes(true);
        this.rp.setAllowNonFastForwards(true);
        this.rp.setRefLogIdent(this.user.newRefLogIdent());
        this.rp.setTimeout(transferConfig.getTimeout());
        this.rp.setMaxObjectSizeLimit(projectControl.getProjectState().getEffectiveMaxObjectSizeLimit().value);
        this.rp.setCheckReceivedObjects(ps.getConfig().getCheckReceivedObjects());
        this.rp.setRefFilter(new RefFilter(){

            @Override
            public Map<String, Ref> filter(Map<String, Ref> refs) {
                HashMap<String, Ref> filteredRefs = Maps.newHashMapWithExpectedSize(refs.size());
                for (Map.Entry<String, Ref> e : refs.entrySet()) {
                    String name = e.getKey();
                    if (name.startsWith("refs/changes/") || name.startsWith("refs/cache-automerge/")) continue;
                    filteredRefs.put(name, e.getValue());
                }
                return filteredRefs;
            }
        });
        if (!projectControl.allRefsAreVisible()) {
            this.rp.setCheckReferencedObjectsAreReachable(receiveConfig.checkReferencedObjectsAreReachable);
        }
        this.rp.setAdvertiseRefsHook(new VisibleRefFilter(tagCache, notesFactory, changeCache, repo, projectControl, db, false));
        ArrayList<AdvertiseRefsHook> advHooks = new ArrayList<AdvertiseRefsHook>(3);
        advHooks.add(new AdvertiseRefsHook(){

            @Override
            public void advertiseRefs(BaseReceivePack rp) throws ServiceMayNotContinueException {
                ReceiveCommits.this.allRefs = rp.getAdvertisedRefs();
                if (ReceiveCommits.this.allRefs == null) {
                    try {
                        ReceiveCommits.this.allRefs = rp.getRepository().getRefDatabase().getRefs("");
                    }
                    catch (ServiceMayNotContinueException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        ServiceMayNotContinueException ex = new ServiceMayNotContinueException();
                        ex.initCause(e);
                        throw ex;
                    }
                }
                rp.setAdvertisedRefs(ReceiveCommits.this.allRefs, rp.getAdvertisedObjects());
            }

            @Override
            public void advertiseRefs(UploadPack uploadPack) {
            }
        });
        advHooks.add(this.rp.getAdvertiseRefsHook());
        advHooks.add(new ReceiveCommitsAdvertiseRefsHook(queryProvider, projectControl.getProject().getNameKey()));
        advHooks.add(new HackPushNegotiateHook());
        this.rp.setAdvertiseRefsHook(AdvertiseRefsHookChain.newChain(advHooks));
        this.rp.setPostReceiveHook(lazyPostReceive.get());
        this.rp.setAllowPushOptions(true);
    }

    public void init() {
        for (ReceivePackInitializer i : this.initializers) {
            i.init(this.projectControl.getProject().getNameKey(), this.rp);
        }
    }

    public void addReviewers(Collection<Account.Id> who) {
        this.reviewersFromCommandLine.addAll(who);
    }

    public void addExtraCC(Collection<Account.Id> who) {
        this.ccFromCommandLine.addAll(who);
    }

    public void setMessageSender(MessageSender ms) {
        this.messageSender = ms != null ? ms : new ReceivePackMessageSender();
    }

    MessageSender getMessageSender() {
        if (this.messageSender == null) {
            this.setMessageSender(null);
        }
        return this.messageSender;
    }

    Project getProject() {
        return this.project;
    }

    public ReceivePack getReceivePack() {
        return this.rp;
    }

    public Capable canUpload() {
        Capable result = this.projectControl.canPushToAtLeastOneRef();
        if (result != Capable.OK) {
            return result;
        }
        if (this.receiveConfig.checkMagicRefs) {
            result = MagicBranch.checkMagicBranchRefs(this.repo, this.project);
        }
        return result;
    }

    private void addMessage(String message) {
        this.messages.add(new CommitValidationMessage(message, false));
    }

    void addError(String error) {
        this.messages.add(new CommitValidationMessage(error, true));
    }

    void sendMessages() {
        for (ValidationMessage m : this.messages) {
            if (m.isError()) {
                this.messageSender.sendError(m.getMessage());
                continue;
            }
            this.messageSender.sendMessage(m.getMessage());
        }
    }

    void processCommands(Collection<ReceiveCommand> commands, MultiProgressMonitor progress) {
        this.newProgress = progress.beginSubTask("new", 0);
        this.replaceProgress = progress.beginSubTask("updated", 0);
        this.closeProgress = progress.beginSubTask("closed", 0);
        this.commandProgress = progress.beginSubTask("refs", 0);
        this.batch = this.repo.getRefDatabase().newBatchUpdate();
        this.batch.setPushCertificate(this.rp.getPushCertificate());
        this.batch.setRefLogIdent(this.rp.getRefLogIdent());
        this.batch.setRefLogMessage("push", true);
        this.parseCommands(commands);
        if (this.magicBranch != null && this.magicBranch.cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
            this.selectNewAndReplacedChangesFromMagicBranch();
        }
        this.preparePatchSetsForReplace();
        this.logDebug("Executing batch with {} commands", this.batch.getCommands().size());
        if (!this.batch.getCommands().isEmpty()) {
            try {
                if (!this.batch.isAllowNonFastForwards() && this.magicBranch != null && this.magicBranch.edit) {
                    this.logDebug("Allowing non-fast-forward for edit ref", new Object[0]);
                    this.batch.setAllowNonFastForwards(true);
                }
                this.batch.execute(this.rp.getRevWalk(), this.commandProgress);
            }
            catch (IOException err) {
                int cnt = 0;
                for (ReceiveCommand cmd : this.batch.getCommands()) {
                    if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                    cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
                    ++cnt;
                }
                this.logError(String.format("Failed to store %d refs in %s", cnt, this.project.getName()), err);
            }
        }
        this.insertChangesAndPatchSets();
        this.newProgress.end();
        this.replaceProgress.end();
        if (!this.errors.isEmpty()) {
            this.logDebug("Handling error conditions: {}", this.errors.keySet());
            for (Error error : this.errors.keySet()) {
                this.rp.sendMessage(this.buildError(error, (List<String>)this.errors.get((Object)error)));
            }
            this.rp.sendMessage(String.format("User: %s", ReceiveCommits.displayName(this.user)));
            this.rp.sendMessage(COMMAND_REJECTION_MESSAGE_FOOTER);
        }
        HashSet<Branch.NameKey> branches = new HashSet<Branch.NameKey>();
        for (ReceiveCommand c : this.batch.getCommands()) {
            if (c.getResult() != ReceiveCommand.Result.OK) continue;
            String refName = c.getRefName();
            if (c.getType() == ReceiveCommand.Type.UPDATE) {
                this.logDebug("Updating tag cache on fast-forward of {}", c.getRefName());
                this.tagCache.updateFastForward(this.project.getNameKey(), refName, c.getOldId(), c.getNewId());
            }
            if (ReceiveCommits.isHead(c) || ReceiveCommits.isConfig(c)) {
                switch (c.getType()) {
                    case CREATE: 
                    case UPDATE: 
                    case UPDATE_NONFASTFORWARD: {
                        this.autoCloseChanges(c);
                        branches.add(new Branch.NameKey(this.project.getNameKey(), refName));
                        break;
                    }
                }
            }
            if (ReceiveCommits.isConfig(c)) {
                this.logDebug("Reloading project in cache", new Object[0]);
                this.projectCache.evict(this.project);
                ProjectState ps = this.projectCache.get(this.project.getNameKey());
                try {
                    this.repo.setGitwebDescription(ps.getProject().getDescription());
                }
                catch (IOException e) {
                    log.warn("cannot update description of {}", (Object)this.project.getName(), (Object)e);
                }
            }
            if (!MagicBranch.isMagicBranch(refName)) {
                this.logDebug("Firing ref update for {}", c.getRefName());
                this.gitRefUpdated.fire(this.project.getNameKey(), c, this.user.getAccount());
                continue;
            }
            this.logDebug("Assuming ref update event for {} has fired", c.getRefName());
        }
        if (!branches.isEmpty()) {
            try (MergeOpRepoManager orm = this.ormProvider.get();){
                orm.setContext(this.db, TimeUtil.nowTs(), this.user, this.receiveId);
                SubmoduleOp op = this.subOpFactory.create(branches, orm);
                op.updateSuperProjects();
            }
            catch (SubmoduleException e) {
                this.logError("Can't update the superprojects", e);
            }
        }
        this.closeProgress.end();
        this.commandProgress.end();
        progress.end();
        this.reportMessages();
    }

    private void reportMessages() {
        List updated;
        List created = this.newChanges.stream().filter(r -> r.change != null).collect(Collectors.toList());
        if (!created.isEmpty()) {
            this.addMessage("");
            this.addMessage("New Changes:");
            for (CreateRequest c : created) {
                this.addMessage(this.changeFormatter.newChange(ChangeReportFormatter.Input.builder().setChange(c.change).build()));
            }
            this.addMessage("");
        }
        if (!(updated = this.replaceByChange.values().stream().filter(r -> !r.skip && r.inputCommand.getResult() == ReceiveCommand.Result.OK).sorted(Comparator.comparingInt(r -> r.notes.getChangeId().get())).collect(Collectors.toList())).isEmpty()) {
            this.addMessage("");
            this.addMessage("Updated Changes:");
            boolean edit = this.magicBranch != null && this.magicBranch.edit;
            for (ReplaceRequest u : updated) {
                String subject;
                if (edit) {
                    try {
                        subject = this.rp.getRevWalk().parseCommit(u.newCommitId).getShortMessage();
                    }
                    catch (IOException e) {
                        this.logWarn("failed to get subject for edit patch set", e);
                        subject = u.notes.getChange().getSubject();
                    }
                } else {
                    subject = u.info.getSubject();
                }
                ChangeReportFormatter.Input input = ChangeReportFormatter.Input.builder().setChange(u.notes.getChange()).setSubject(subject).setIsDraft(u.replaceOp != null && u.replaceOp.getPatchSet().isDraft()).setIsEdit(edit).build();
                this.addMessage(this.changeFormatter.changeUpdated(input));
            }
            this.addMessage("");
        }
    }

    private void insertChangesAndPatchSets() {
        int replaceCount = 0;
        int okToInsert = 0;
        for (Map.Entry<Change.Id, ReplaceRequest> entry : this.replaceByChange.entrySet()) {
            ReplaceRequest replace = entry.getValue();
            if (this.magicBranch != null && replace.inputCommand == this.magicBranch.cmd) {
                ++replaceCount;
                if (replace.cmd == null || replace.cmd.getResult() != ReceiveCommand.Result.OK) continue;
                ++okToInsert;
                continue;
            }
            if (replace.cmd != null && replace.cmd.getResult() == ReceiveCommand.Result.OK) {
                String refName = replace.inputCommand.getRefName();
                Preconditions.checkState(NEW_PATCHSET.matcher(refName).matches(), "expected a new patch set command as input when creating %s; got %s", (Object)replace.cmd.getRefName(), (Object)refName);
                try {
                    this.logDebug("One-off insertion of patch set for {}", refName);
                    replace.insertPatchSetWithoutBatchUpdate();
                    replace.inputCommand.setResult(ReceiveCommand.Result.OK);
                }
                catch (RestApiException | UpdateException | IOException err) {
                    this.reject(replace.inputCommand, "internal server error");
                    this.logError(String.format("Cannot add patch set to change %d in project %s", entry.getKey().get(), this.project.getName()), err);
                }
                continue;
            }
            if (replace.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
            this.reject(replace.inputCommand, "internal server error");
            this.logError(String.format("Replacement for project %s was not attempted", this.project.getName()));
        }
        if (this.magicBranch == null) {
            this.logDebug("No magic branch, nothing more to do", new Object[0]);
            return;
        }
        if (this.magicBranch.cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
            this.logWarn(String.format("Skipping change updates on %s because ref update failed: %s %s", new Object[]{this.project.getName(), this.magicBranch.cmd.getResult(), Strings.nullToEmpty(this.magicBranch.cmd.getMessage())}));
            return;
        }
        ArrayList<String> lastCreateChangeErrors = new ArrayList<String>();
        for (CreateRequest create : this.newChanges) {
            if (create.cmd.getResult() == ReceiveCommand.Result.OK) {
                ++okToInsert;
                continue;
            }
            Iterator<Object> createChangeResult = String.format("%s %s", new Object[]{create.cmd.getResult(), Strings.nullToEmpty(create.cmd.getMessage())}).trim();
            lastCreateChangeErrors.add((String)((Object)createChangeResult));
            this.logError(String.format("Command %s on %s:%s not completed: %s", new Object[]{create.cmd.getType(), this.project.getName(), create.cmd.getRefName(), createChangeResult}));
        }
        this.logDebug("Counted {} ok to insert, out of {} to replace and {} new", okToInsert, replaceCount, this.newChanges.size());
        if (okToInsert != replaceCount + this.newChanges.size()) {
            this.reject(this.magicBranch.cmd, "Unable to create changes: " + lastCreateChangeErrors.stream().collect(Collectors.joining(" ")));
            this.logError(String.format("Only %d of %d new change refs created in %s; aborting", okToInsert, replaceCount + this.newChanges.size(), this.project.getName()));
            return;
        }
        try (BatchUpdate batchUpdate = this.batchUpdateFactory.create(this.db, this.magicBranch.dest.getParentKey(), this.user.materializedCopy(), TimeUtil.nowTs());
             ObjectInserter ins = this.repo.newObjectInserter();){
            batchUpdate.setRepository(this.repo, this.rp.getRevWalk(), ins).updateChangesInParallel();
            batchUpdate.setRequestId(this.receiveId);
            for (ReplaceRequest replace : this.replaceByChange.values()) {
                if (replace.inputCommand != this.magicBranch.cmd) continue;
                replace.addOps(batchUpdate, this.replaceProgress);
            }
            for (CreateRequest create : this.newChanges) {
                create.addOps(batchUpdate);
            }
            for (UpdateGroupsRequest update : this.updateGroups) {
                update.addOps(batchUpdate);
            }
            this.logDebug("Executing batch", new Object[0]);
            try {
                batchUpdate.execute();
            }
            catch (UpdateException e) {
                throw INSERT_EXCEPTION.apply(e);
            }
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.OK);
            for (ReplaceRequest replace : this.replaceByChange.values()) {
                String rejectMessage = replace.getRejectMessage();
                if (rejectMessage == null) continue;
                this.logDebug("Rejecting due to message from ReplaceOp", new Object[0]);
                this.reject(replace.inputCommand, rejectMessage);
            }
        }
        catch (ResourceConflictException resourceConflictException) {
            this.addMessage(resourceConflictException.getMessage());
            this.reject(this.magicBranch.cmd, "conflict");
        }
        catch (RestApiException | IOException exception) {
            this.logError("Can't insert change/patch set for " + this.project.getName(), exception);
            this.reject(this.magicBranch.cmd, "internal server error: " + exception.getMessage());
        }
        if (this.magicBranch != null && this.magicBranch.submit) {
            try {
                this.submit(this.newChanges, this.replaceByChange.values());
            }
            catch (ResourceConflictException resourceConflictException) {
                this.addMessage(resourceConflictException.getMessage());
                this.reject(this.magicBranch.cmd, "conflict");
            }
            catch (RestApiException | OrmException exception) {
                this.logError("Error submitting changes to " + this.project.getName(), exception);
                this.reject(this.magicBranch.cmd, "error during submit");
            }
        }
    }

    private String buildError(Error error, List<String> branches) {
        StringBuilder sb = new StringBuilder();
        if (branches.size() == 1) {
            sb.append("Branch ").append(branches.get(0)).append(":\n");
            sb.append(error.get());
            return sb.toString();
        }
        sb.append("Branches");
        String delim = " ";
        for (String branch : branches) {
            sb.append(delim).append(branch);
            delim = ", ";
        }
        return sb.append(":\n").append(error.get()).toString();
    }

    private static String displayName(IdentifiedUser user) {
        String displayName = user.getUserName();
        if (displayName == null) {
            displayName = user.getAccount().getPreferredEmail();
        }
        return displayName;
    }

    private void parseCommands(Collection<ReceiveCommand> commands) {
        List<String> optionList = this.rp.getPushOptions();
        if (optionList != null) {
            for (String option : optionList) {
                int e = option.indexOf(61);
                if (e > 0) {
                    this.pushOptions.put(option.substring(0, e), option.substring(e + 1));
                    continue;
                }
                this.pushOptions.put(option, "");
            }
        }
        this.logDebug("Parsing {} commands", commands.size());
        block13: for (ReceiveCommand cmd : commands) {
            Matcher m;
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                this.logDebug("Already processed by core: {} {}", new Object[]{cmd.getResult(), cmd});
                continue;
            }
            if (!Repository.isValidRefName(cmd.getRefName()) || cmd.getRefName().contains("//")) {
                this.reject(cmd, "not valid ref");
                continue;
            }
            if (MagicBranch.isMagicBranch(cmd.getRefName())) {
                this.parseMagicBranch(cmd);
                continue;
            }
            if (this.projectControl.getProjectState().isAllUsers() && "refs/users/self".equals(cmd.getRefName())) {
                String newName = RefNames.refsUsers(this.user.getAccountId());
                this.logDebug("Swapping out command for {} to {}", "refs/users/self", newName);
                final ReceiveCommand orgCmd = cmd;
                cmd = new ReceiveCommand(cmd.getOldId(), cmd.getNewId(), newName, cmd.getType()){

                    @Override
                    public void setResult(ReceiveCommand.Result s, String m) {
                        super.setResult(s, m);
                        orgCmd.setResult(s, m);
                    }
                };
            }
            if ((m = NEW_PATCHSET.matcher(cmd.getRefName())).matches()) {
                Change.Id changeId = Change.Id.parse(m.group(1));
                this.parseReplaceCommand(cmd, changeId);
                continue;
            }
            switch (cmd.getType()) {
                case CREATE: {
                    this.parseCreate(cmd);
                    break;
                }
                case UPDATE: {
                    this.parseUpdate(cmd);
                    break;
                }
                case DELETE: {
                    this.parseDelete(cmd);
                    break;
                }
                case UPDATE_NONFASTFORWARD: {
                    this.parseRewind(cmd);
                    break;
                }
                default: {
                    this.reject(cmd, "prohibited by Gerrit: unknown command type " + (Object)((Object)cmd.getType()));
                    continue block13;
                }
            }
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || !ReceiveCommits.isConfig(cmd)) continue;
            this.logDebug("Processing {} command", cmd.getRefName());
            if (!this.projectControl.isOwner()) {
                this.reject(cmd, "not project owner");
                continue;
            }
            switch (cmd.getType()) {
                case CREATE: 
                case UPDATE: 
                case UPDATE_NONFASTFORWARD: {
                    try {
                        ProjectConfig cfg = new ProjectConfig(this.project.getNameKey());
                        cfg.load(this.rp.getRevWalk(), cmd.getNewId());
                        if (!cfg.getValidationErrors().isEmpty()) {
                            this.addError("Invalid project configuration:");
                            for (ValidationError err : cfg.getValidationErrors()) {
                                this.addError("  " + err.getMessage());
                            }
                            this.reject(cmd, "invalid project configuration");
                            this.logError("User " + this.user.getUserName() + " tried to push invalid project configuration " + cmd.getNewId().name() + " for " + this.project.getName());
                            continue block13;
                        }
                        Project.NameKey newParent = cfg.getProject().getParent(this.allProjectsName);
                        Project.NameKey oldParent = this.project.getParent(this.allProjectsName);
                        if (oldParent == null) {
                            if (newParent != null) {
                                this.reject(cmd, "invalid project configuration: root project cannot have parent");
                                continue block13;
                            }
                        } else {
                            if (!oldParent.equals(newParent) && !this.user.getCapabilities().canAdministrateServer()) {
                                this.reject(cmd, "invalid project configuration: only Gerrit admin can set parent");
                                continue block13;
                            }
                            if (this.projectCache.get(newParent) == null) {
                                this.reject(cmd, "invalid project configuration: parent does not exist");
                                continue block13;
                            }
                        }
                        for (DynamicMap.Entry<ProjectConfigEntry> entry : this.pluginConfigEntries) {
                            PluginConfig pluginCfg = cfg.getPluginConfig(entry.getPluginName());
                            ProjectConfigEntry configEntry = entry.getProvider().get();
                            String value = pluginCfg.getString(entry.getExportName());
                            String oldValue = this.projectControl.getProjectState().getConfig().getPluginConfig(entry.getPluginName()).getString(entry.getExportName());
                            if (configEntry.getType() == ProjectConfigEntryType.ARRAY) {
                                oldValue = Arrays.stream(this.projectControl.getProjectState().getConfig().getPluginConfig(entry.getPluginName()).getStringList(entry.getExportName())).collect(Collectors.joining("\n"));
                            }
                            if ((value == null ? oldValue != null : !value.equals(oldValue)) && !configEntry.isEditable(this.projectControl.getProjectState())) {
                                this.reject(cmd, String.format("invalid project configuration: Not allowed to set parameter '%s' of plugin '%s' on project '%s'.", entry.getExportName(), entry.getPluginName(), this.project.getName()));
                                continue;
                            }
                            if (!ProjectConfigEntryType.LIST.equals((Object)configEntry.getType()) || value == null || configEntry.getPermittedValues().contains(value)) continue;
                            this.reject(cmd, String.format("invalid project configuration: The value '%s' is not permitted for parameter '%s' of plugin '%s'.", value, entry.getExportName(), entry.getPluginName()));
                        }
                        continue block13;
                    }
                    catch (Exception e) {
                        this.reject(cmd, "invalid project configuration");
                        this.logError("User " + this.user.getUserName() + " tried to push invalid project configuration " + cmd.getNewId().name() + " for " + this.project.getName(), e);
                        continue block13;
                    }
                }
                case DELETE: {
                    break;
                }
                default: {
                    this.reject(cmd, "prohibited by Gerrit: don't know how to handle config update of type " + (Object)((Object)cmd.getType()));
                    continue block13;
                }
            }
        }
    }

    private void parseCreate(ReceiveCommand cmd) {
        RevObject obj;
        try {
            obj = this.rp.getRevWalk().parseAny(cmd.getNewId());
        }
        catch (IOException err) {
            this.logError("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName() + " creation", err);
            this.reject(cmd, "invalid object");
            return;
        }
        this.logDebug("Creating {}", cmd);
        if (ReceiveCommits.isHead(cmd) && !this.isCommit(cmd)) {
            return;
        }
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (ctl.canCreate(this.db, this.rp.getRepository(), obj)) {
            if (!this.validRefOperation(cmd)) {
                return;
            }
            this.validateNewCommits(ctl, cmd);
            this.batch.addCommand(cmd);
        } else {
            this.reject(cmd, "prohibited by Gerrit: create access denied for " + cmd.getRefName());
        }
    }

    private void parseUpdate(ReceiveCommand cmd) {
        this.logDebug("Updating {}", cmd);
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (ctl.canUpdate()) {
            if (ReceiveCommits.isHead(cmd) && !this.isCommit(cmd)) {
                return;
            }
            if (!this.validRefOperation(cmd)) {
                return;
            }
            this.validateNewCommits(ctl, cmd);
            this.batch.addCommand(cmd);
        } else {
            if ("refs/meta/config".equals(ctl.getRefName())) {
                this.errors.put(Error.CONFIG_UPDATE, "refs/meta/config");
            } else {
                this.errors.put(Error.UPDATE, ctl.getRefName());
            }
            this.reject(cmd, "prohibited by Gerrit: ref update access denied");
        }
    }

    private boolean isCommit(ReceiveCommand cmd) {
        RevObject obj;
        try {
            obj = this.rp.getRevWalk().parseAny(cmd.getNewId());
        }
        catch (IOException err) {
            this.logError("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName(), err);
            this.reject(cmd, "invalid object");
            return false;
        }
        if (obj instanceof RevCommit) {
            return true;
        }
        this.reject(cmd, "not a commit");
        return false;
    }

    private void parseDelete(ReceiveCommand cmd) {
        this.logDebug("Deleting {}", cmd);
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (ctl.getRefName().startsWith("refs/changes/")) {
            this.errors.put(Error.DELETE_CHANGES, ctl.getRefName());
            this.reject(cmd, "cannot delete changes");
        } else if (ctl.canDelete()) {
            if (!this.validRefOperation(cmd)) {
                return;
            }
            this.batch.addCommand(cmd);
        } else if ("refs/meta/config".equals(ctl.getRefName())) {
            this.reject(cmd, "cannot delete project configuration");
        } else {
            this.errors.put(Error.DELETE, ctl.getRefName());
            this.reject(cmd, "cannot delete references");
        }
    }

    private void parseRewind(ReceiveCommand cmd) {
        RevCommit newObject;
        try {
            newObject = this.rp.getRevWalk().parseCommit(cmd.getNewId());
        }
        catch (IncorrectObjectTypeException notCommit) {
            newObject = null;
        }
        catch (IOException err) {
            this.logError("Invalid object " + cmd.getNewId().name() + " for " + cmd.getRefName() + " forced update", err);
            this.reject(cmd, "invalid object");
            return;
        }
        this.logDebug("Rewinding {}", cmd);
        RefControl ctl = this.projectControl.controlForRef(cmd.getRefName());
        if (newObject != null) {
            this.validateNewCommits(ctl, cmd);
            if (cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                return;
            }
        }
        if (ctl.canForceUpdate()) {
            if (!this.validRefOperation(cmd)) {
                return;
            }
            this.batch.setAllowNonFastForwards(true).addCommand(cmd);
        } else {
            cmd.setResult(ReceiveCommand.Result.REJECTED_NONFASTFORWARD, " need 'Force Push' privilege.");
        }
    }

    @Nullable
    public ListMultimap<String, String> getPushOptions() {
        return ImmutableListMultimap.copyOf(this.pushOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseMagicBranch(ReceiveCommand cmd) {
        RevCommit tip;
        String ref;
        CmdLineParser clp;
        if (this.magicBranch != null) {
            this.reject(cmd, "duplicate request");
            return;
        }
        this.logDebug("Found magic branch {}", cmd.getRefName());
        this.magicBranch = new MagicBranchInput(cmd, this.labelTypes, this.notesMigration);
        this.magicBranch.reviewer.addAll(this.reviewersFromCommandLine);
        this.magicBranch.cc.addAll(this.ccFromCommandLine);
        this.magicBranch.clp = clp = this.optionParserFactory.create(this.magicBranch);
        try {
            ref = this.magicBranch.parse(clp, this.repo, this.rp.getAdvertisedRefs().keySet(), this.pushOptions);
        }
        catch (CmdLineException e) {
            if (!clp.wasHelpRequestedByOption()) {
                this.logDebug("Invalid branch syntax", new Object[0]);
                this.reject(cmd, e.getMessage());
                return;
            }
            ref = null;
        }
        if (clp.wasHelpRequestedByOption()) {
            StringWriter w = new StringWriter();
            w.write("\nHelp for refs/for/branch:\n\n");
            clp.printUsage(w, null);
            this.addMessage(w.toString());
            this.reject(cmd, "see help");
            return;
        }
        if (this.projectControl.getProjectState().isAllUsers() && "refs/users/self".equals(ref)) {
            this.logDebug("Handling {}", "refs/users/self");
            ref = RefNames.refsUsers(this.user.getAccountId());
        }
        if (!this.rp.getAdvertisedRefs().containsKey(ref) && !ref.equals(ReceiveCommits.readHEAD(this.repo))) {
            this.logDebug("Ref {} not found", ref);
            if (ref.startsWith("refs/heads/")) {
                String n = ref.substring("refs/heads/".length());
                this.reject(cmd, "branch " + n + " not found");
            } else {
                this.reject(cmd, ref + " not found");
            }
            return;
        }
        this.magicBranch.dest = new Branch.NameKey(this.project.getNameKey(), ref);
        this.magicBranch.ctl = this.projectControl.controlForRef(ref);
        if (!this.magicBranch.ctl.canWrite()) {
            this.reject(cmd, "project is read only");
            return;
        }
        if (this.magicBranch.draft) {
            if (!this.receiveConfig.allowDrafts) {
                this.errors.put(Error.CODE_REVIEW, ref);
                this.reject(cmd, "draft workflow is disabled");
                return;
            }
            if (this.projectControl.controlForRef("refs/drafts/" + ref).isBlocked("push")) {
                this.errors.put(Error.CODE_REVIEW, ref);
                this.reject(cmd, "cannot upload drafts");
                return;
            }
        }
        if (!this.magicBranch.ctl.canUpload()) {
            this.errors.put(Error.CODE_REVIEW, ref);
            this.reject(cmd, "cannot upload review");
            return;
        }
        if (this.magicBranch.draft && this.magicBranch.submit) {
            this.reject(cmd, "cannot submit draft");
            return;
        }
        if (this.magicBranch.submit && !this.projectControl.controlForRef("refs/for/" + ref).canSubmit(true)) {
            this.reject(cmd, "submit not allowed");
            return;
        }
        RevWalk walk = this.rp.getRevWalk();
        try {
            tip = walk.parseCommit(this.magicBranch.cmd.getNewId());
            this.logDebug("Tip of push: {}", tip.name());
        }
        catch (IOException ex) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", ex);
            return;
        }
        String destBranch = this.magicBranch.dest.get();
        try {
            Object branchTip;
            if (this.magicBranch.merged) {
                if (this.magicBranch.draft) {
                    this.reject(cmd, "cannot be draft & merged");
                    return;
                }
                if (this.magicBranch.base != null) {
                    this.reject(cmd, "cannot use merged with base");
                    return;
                }
                branchTip = this.readBranchTip(cmd, this.magicBranch.dest);
                if (branchTip == null) {
                    return;
                }
                if (!walk.isMergedInto(tip, (RevCommit)branchTip)) {
                    this.reject(cmd, "not merged into branch");
                    return;
                }
            }
            if (tip.getParentCount() > 1 || this.magicBranch.base != null || this.magicBranch.merged || tip.getParentCount() == 0) {
                this.logDebug("Forcing newChangeForAllNotInTarget = false", new Object[0]);
                this.newChangeForAllNotInTarget = false;
            }
            if (this.magicBranch.base != null) {
                this.logDebug("Handling %base: {}", this.magicBranch.base);
                this.magicBranch.baseCommit = Lists.newArrayListWithCapacity(this.magicBranch.base.size());
                for (ObjectId id : this.magicBranch.base) {
                    try {
                        this.magicBranch.baseCommit.add(walk.parseCommit(id));
                    }
                    catch (IncorrectObjectTypeException notCommit) {
                        this.reject(cmd, "base must be a commit");
                        return;
                    }
                    catch (MissingObjectException e) {
                        this.reject(cmd, "base not found");
                        return;
                    }
                    catch (IOException e) {
                        this.logWarn(String.format("Project %s cannot read %s", this.project.getName(), id.name()), e);
                        this.reject(cmd, "internal server error");
                        return;
                    }
                }
            } else if (this.newChangeForAllNotInTarget) {
                branchTip = this.readBranchTip(cmd, this.magicBranch.dest);
                if (branchTip == null) {
                    return;
                }
                this.magicBranch.baseCommit = Collections.singletonList(branchTip);
                this.logDebug("Set baseCommit = {}", this.magicBranch.baseCommit.get(0).name());
            }
        }
        catch (IOException ex) {
            this.logWarn(String.format("Error walking to %s in project %s", destBranch, this.project.getName()), ex);
            this.reject(cmd, "internal server error");
            return;
        }
        try {
            Ref targetRef = this.rp.getAdvertisedRefs().get(this.magicBranch.ctl.getRefName());
            if (targetRef == null || targetRef.getObjectId() == null) {
                this.logDebug("Branch is unborn", new Object[0]);
                return;
            }
            RevCommit h = walk.parseCommit(targetRef.getObjectId());
            this.logDebug("Current branch tip: {}", h.name());
            RevFilter oldRevFilter = walk.getRevFilter();
            try {
                walk.reset();
                walk.setRevFilter(RevFilter.MERGE_BASE);
                walk.markStart(tip);
                walk.markStart(h);
                if (walk.next() == null) {
                    this.reject(this.magicBranch.cmd, "no common ancestry");
                }
            }
            finally {
                walk.reset();
                walk.setRevFilter(oldRevFilter);
            }
        }
        catch (IOException e) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", e);
        }
    }

    private static String readHEAD(Repository repo) {
        try {
            return repo.getFullBranch();
        }
        catch (IOException e) {
            log.error("Cannot read HEAD symref", e);
            return null;
        }
    }

    private RevCommit readBranchTip(ReceiveCommand cmd, Branch.NameKey branch) throws IOException {
        Ref r = this.allRefs.get(branch.get());
        if (r == null) {
            this.reject(cmd, branch.get() + " not found");
            return null;
        }
        return this.rp.getRevWalk().parseCommit(r.getObjectId());
    }

    private void parseReplaceCommand(ReceiveCommand cmd, Change.Id changeId) {
        Change changeEnt;
        RevCommit newCommit;
        this.logDebug("Parsing replace command", new Object[0]);
        if (cmd.getType() != ReceiveCommand.Type.CREATE) {
            this.reject(cmd, "invalid usage");
            return;
        }
        try {
            newCommit = this.rp.getRevWalk().parseCommit(cmd.getNewId());
            this.logDebug("Replacing with {}", newCommit);
        }
        catch (IOException e) {
            this.logError("Cannot parse " + cmd.getNewId().name() + " as commit", e);
            this.reject(cmd, "invalid commit");
            return;
        }
        try {
            changeEnt = this.notesFactory.createChecked(this.db, this.project.getNameKey(), changeId).getChange();
        }
        catch (NoSuchChangeException e) {
            this.logError("Change not found " + changeId, e);
            this.reject(cmd, "change " + changeId + " not found");
            return;
        }
        catch (OrmException e) {
            this.logError("Cannot lookup existing change " + changeId, e);
            this.reject(cmd, "database error");
            return;
        }
        if (!this.project.getNameKey().equals(changeEnt.getProject())) {
            this.reject(cmd, "change " + changeId + " does not belong to project " + this.project.getName());
            return;
        }
        this.logDebug("Replacing change {}", changeEnt.getId());
        this.requestReplace(cmd, true, changeEnt, newCommit);
    }

    private boolean requestReplace(ReceiveCommand cmd, boolean checkMergedInto, Change change, RevCommit newCommit) {
        if (change.getStatus().isClosed()) {
            this.reject(cmd, this.changeFormatter.changeClosed(ChangeReportFormatter.Input.builder().setChange(change).build()));
            return false;
        }
        ReplaceRequest req = new ReplaceRequest(change.getId(), newCommit, cmd, checkMergedInto);
        if (this.replaceByChange.containsKey(req.ontoChange)) {
            this.reject(cmd, "duplicate request");
            return false;
        }
        this.replaceByChange.put(req.ontoChange, req);
        return true;
    }

    private void selectNewAndReplacedChangesFromMagicBranch() {
        this.logDebug("Finding new and replaced changes", new Object[0]);
        this.newChanges = new ArrayList<CreateRequest>();
        ListMultimap<ObjectId, Ref> existing = this.changeRefsById();
        GroupCollector groupCollector = GroupCollector.create(this.changeRefsById(), this.db, this.psUtil, this.notesFactory, this.project.getNameKey());
        try {
            RevCommit c;
            RevCommit start = this.setUpWalkForSelectingChanges();
            if (start == null) {
                return;
            }
            LinkedHashMap<RevCommit, ChangeLookup> pending = new LinkedHashMap<RevCommit, ChangeLookup>();
            HashSet<Change.Key> newChangeIds = new HashSet<Change.Key>();
            int maxBatchChanges = this.receiveConfig.getEffectiveMaxBatchChangesLimit(this.user);
            int total = 0;
            int alreadyTracked = 0;
            boolean rejectImplicitMerges = start.getParentCount() == 1 && this.projectCache.get(this.project.getNameKey()).isRejectImplicitMerges() && !this.magicBranch.merged;
            HashSet<RevCommit> mergedParents = rejectImplicitMerges ? new HashSet<RevCommit>() : null;
            while ((c = this.rp.getRevWalk().next()) != null) {
                List<String> idList;
                String idStr;
                boolean commitAlreadyTracked;
                ++total;
                this.rp.getRevWalk().parseBody(c);
                String name = c.name();
                groupCollector.visit(c);
                Collection existingRefs = existing.get((Object)c);
                if (rejectImplicitMerges) {
                    Collections.addAll(mergedParents, c.getParents());
                    mergedParents.remove(c);
                }
                boolean bl = commitAlreadyTracked = !existingRefs.isEmpty();
                if (commitAlreadyTracked) {
                    ++alreadyTracked;
                    for (Ref ref : existingRefs) {
                        this.updateGroups.add(new UpdateGroupsRequest(ref, c));
                    }
                    if (!this.newChangeForAllNotInTarget && this.magicBranch.base == null) continue;
                }
                String string = idStr = !(idList = c.getFooterLines(FooterConstants.CHANGE_ID)).isEmpty() ? idList.get(idList.size() - 1).trim() : null;
                if (idStr != null) {
                    pending.put(c, new ChangeLookup(c, new Change.Key(idStr)));
                } else {
                    pending.put(c, new ChangeLookup(c));
                }
                int n = pending.size() + this.newChanges.size();
                if (maxBatchChanges != 0 && n > maxBatchChanges) {
                    this.logDebug("{} changes exceeds limit of {}", n, maxBatchChanges);
                    this.reject(this.magicBranch.cmd, "the number of pushed changes in a batch exceeds the max limit " + maxBatchChanges);
                    this.newChanges = Collections.emptyList();
                    return;
                }
                if (commitAlreadyTracked) {
                    boolean changeExistsOnDestBranch = false;
                    for (ChangeData cd2 : ((ChangeLookup)pending.get((Object)c)).destChanges) {
                        if (!cd2.change().getDest().equals(this.magicBranch.dest)) continue;
                        changeExistsOnDestBranch = true;
                        break;
                    }
                    if (changeExistsOnDestBranch) continue;
                    this.logDebug("Creating new change for {} even though it is already tracked", name);
                }
                if (!this.validCommit(this.rp.getRevWalk(), this.magicBranch.ctl, this.magicBranch.cmd, c)) {
                    this.newChanges = Collections.emptyList();
                    this.logDebug("Aborting early due to invalid commit", new Object[0]);
                    return;
                }
                if (this.newChangeForAllNotInTarget && c.getParentCount() > 1) {
                    this.reject(this.magicBranch.cmd, "Pushing merges in commit chains with 'all not in target' is not allowed,\nto override please set the base manually");
                    this.logDebug("Rejecting merge commit {} with newChangeForAllNotInTarget", name);
                }
                if (!idList.isEmpty()) continue;
                this.newChanges.add(new CreateRequest(c, this.magicBranch.dest.get()));
            }
            this.logDebug("Finished initial RevWalk with {} commits total: {} already tracked, {} new changes with no Change-Id, and {} deferred lookups", total, alreadyTracked, this.newChanges.size(), pending.size());
            if (rejectImplicitMerges) {
                this.rejectImplicitMerges(mergedParents);
            }
            Iterator itr = pending.values().iterator();
            while (itr.hasNext()) {
                ChangeLookup p = (ChangeLookup)itr.next();
                if (p.changeKey == null) continue;
                if (newChangeIds.contains(p.changeKey)) {
                    this.logDebug("Multiple commits with Change-Id {}", p.changeKey);
                    this.reject(this.magicBranch.cmd, SAME_CHANGE_ID_IN_MULTIPLE_CHANGES);
                    this.newChanges = Collections.emptyList();
                    return;
                }
                List<ChangeData> changes = p.destChanges;
                if (changes.size() > 1) {
                    this.logDebug("Multiple changes in branch {} with Change-Id {}: {}", this.magicBranch.dest, p.changeKey, changes.stream().map(cd -> cd.getId().toString()).collect(Collectors.joining()));
                    this.reject(this.magicBranch.cmd, p.changeKey.get() + " has duplicates");
                    this.newChanges = Collections.emptyList();
                    return;
                }
                if (changes.size() == 1) {
                    RevId currentPs = changes.get(0).currentPatchSet().getRevision();
                    if (p.commit.name().equals(currentPs.get())) {
                        if (pending.size() == 1) {
                            this.reject(this.magicBranch.cmd, "commit(s) already exists (as current patchset)");
                        } else {
                            itr.remove();
                            continue;
                        }
                    }
                    if (this.requestReplace(this.magicBranch.cmd, false, changes.get(0).change(), p.commit)) continue;
                    this.newChanges = Collections.emptyList();
                    return;
                }
                if (changes.size() == 0) {
                    if (!ReceiveCommits.isValidChangeId(p.changeKey.get())) {
                        this.reject(this.magicBranch.cmd, "invalid Change-Id");
                        this.newChanges = Collections.emptyList();
                        return;
                    }
                    if (this.foundInExistingRef(existing.get((Object)p.commit))) {
                        if (pending.size() == 1) {
                            this.reject(this.magicBranch.cmd, "commit(s) already exists (as current patchset)");
                            this.newChanges = Collections.emptyList();
                            return;
                        }
                        itr.remove();
                        continue;
                    }
                    newChangeIds.add(p.changeKey);
                }
                this.newChanges.add(new CreateRequest(p.commit, this.magicBranch.dest.get()));
            }
            this.logDebug("Finished deferred lookups with {} updates and {} new changes", this.replaceByChange.size(), this.newChanges.size());
        }
        catch (IOException e) {
            this.magicBranch.cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", e);
            this.newChanges = Collections.emptyList();
            return;
        }
        catch (OrmException e) {
            this.logError("Cannot query database to locate prior changes", e);
            this.reject(this.magicBranch.cmd, "database error");
            this.newChanges = Collections.emptyList();
            return;
        }
        if (this.newChanges.isEmpty() && this.replaceByChange.isEmpty()) {
            this.reject(this.magicBranch.cmd, "no new changes");
            return;
        }
        if (!this.newChanges.isEmpty() && this.magicBranch.edit) {
            this.reject(this.magicBranch.cmd, "edit is not supported for new changes");
            return;
        }
        try {
            SortedSetMultimap<ObjectId, String> groups = groupCollector.getGroups();
            ImmutableList<Integer> newIds = this.seq.nextChangeIds(this.newChanges.size());
            for (int i = 0; i < this.newChanges.size(); ++i) {
                CreateRequest create = this.newChanges.get(i);
                create.setChangeId((Integer)newIds.get(i));
                this.batch.addCommand(create.cmd);
                create.groups = ImmutableList.copyOf(groups.get((Object)create.commit));
            }
            for (ReplaceRequest replace : this.replaceByChange.values()) {
                replace.groups = ImmutableList.copyOf(groups.get((Object)replace.newCommitId));
            }
            for (UpdateGroupsRequest update : this.updateGroups) {
                update.groups = ImmutableList.copyOf(groups.get((Object)update.commit));
            }
            this.logDebug("Finished updating groups from GroupCollector", new Object[0]);
        }
        catch (OrmException e) {
            this.logError("Error collecting groups for changes", e);
            this.reject(this.magicBranch.cmd, "internal server error");
            return;
        }
    }

    private boolean foundInExistingRef(Collection<Ref> existingRefs) throws OrmException {
        for (Ref ref : existingRefs) {
            ChangeNotes notes = this.notesFactory.create(this.db, this.project.getNameKey(), Change.Id.fromRef(ref.getName()));
            Change change = notes.getChange();
            if (!change.getDest().equals(this.magicBranch.dest)) continue;
            this.logDebug("Found change {} from existing refs.", change.getKey());
            CheckedFuture<?, IOException> possiblyIgnoredError = this.indexer.indexAsync(this.project.getNameKey(), change.getId());
            return true;
        }
        return false;
    }

    private RevCommit setUpWalkForSelectingChanges() throws IOException {
        RevWalk rw = this.rp.getRevWalk();
        RevCommit start = rw.parseCommit(this.magicBranch.cmd.getNewId());
        rw.reset();
        rw.sort(RevSort.TOPO);
        rw.sort(RevSort.REVERSE, true);
        this.rp.getRevWalk().markStart(start);
        if (this.magicBranch.baseCommit != null) {
            this.markExplicitBasesUninteresting();
        } else if (this.magicBranch.merged) {
            this.logDebug("Marking parents of merged commit {} uninteresting", start.name());
            for (RevCommit c : start.getParents()) {
                rw.markUninteresting(c);
            }
        } else {
            this.markHeadsAsUninteresting(rw, this.magicBranch.ctl != null ? this.magicBranch.ctl.getRefName() : null);
        }
        return start;
    }

    private void markExplicitBasesUninteresting() throws IOException {
        this.logDebug("Marking {} base commits uninteresting", this.magicBranch.baseCommit.size());
        for (RevCommit c : this.magicBranch.baseCommit) {
            this.rp.getRevWalk().markUninteresting(c);
        }
        Ref targetRef = this.allRefs.get(this.magicBranch.ctl.getRefName());
        if (targetRef != null) {
            this.logDebug("Marking target ref {} ({}) uninteresting", this.magicBranch.ctl.getRefName(), targetRef.getObjectId().name());
            this.rp.getRevWalk().markUninteresting(this.rp.getRevWalk().parseCommit(targetRef.getObjectId()));
        }
    }

    private void rejectImplicitMerges(Set<RevCommit> mergedParents) throws IOException {
        Ref targetRef;
        if (!mergedParents.isEmpty() && (targetRef = this.allRefs.get(this.magicBranch.ctl.getRefName())) != null) {
            RevWalk rw = this.rp.getRevWalk();
            RevCommit tip = rw.parseCommit(targetRef.getObjectId());
            boolean containsImplicitMerges = true;
            for (RevCommit p : mergedParents) {
                containsImplicitMerges &= !rw.isMergedInto(p, tip);
            }
            if (containsImplicitMerges) {
                RevCommit c;
                rw.reset();
                for (RevCommit p : mergedParents) {
                    rw.markStart(p);
                }
                rw.markUninteresting(tip);
                while ((c = rw.next()) != null) {
                    rw.parseBody(c);
                    this.messages.add(new CommitValidationMessage("ERROR: Implicit Merge of " + c.abbreviate(7).name() + " " + c.getShortMessage(), false));
                }
                this.reject(this.magicBranch.cmd, "implicit merges detected");
            }
        }
    }

    private void markHeadsAsUninteresting(RevWalk rw, @Nullable String forRef) {
        int i = 0;
        for (Ref ref : this.allRefs.values()) {
            if (!ref.getName().startsWith("refs/heads/") && !ref.getName().equals(forRef) || ref.getObjectId() == null) continue;
            try {
                rw.markUninteresting(rw.parseCommit(ref.getObjectId()));
                ++i;
            }
            catch (IOException e) {
                this.logWarn(String.format("Invalid ref %s in %s", ref.getName(), this.project.getName()), e);
            }
        }
        this.logDebug("Marked {} heads as uninteresting", i);
    }

    private static boolean isValidChangeId(String idStr) {
        return idStr.matches("^I[0-9a-fA-F]{40}$") && !idStr.matches("^I00*$");
    }

    private void submit(Collection<CreateRequest> create, Collection<ReplaceRequest> replace) throws OrmException, RestApiException {
        HashMap<ObjectId, Change> bySha = Maps.newHashMapWithExpectedSize(create.size() + replace.size());
        for (CreateRequest createRequest : create) {
            Preconditions.checkNotNull(createRequest.change, "cannot submit new change %s; op may not have run", (Object)createRequest.changeId);
            bySha.put(createRequest.commit, createRequest.change);
        }
        for (ReplaceRequest replaceRequest : replace) {
            bySha.put(replaceRequest.newCommitId, replaceRequest.notes.getChange());
        }
        Change tipChange = (Change)bySha.get(this.magicBranch.cmd.getNewId());
        Preconditions.checkNotNull(tipChange, "tip of push does not correspond to a change; found these changes: %s", bySha);
        this.logDebug("Processing submit with tip change {} ({})", tipChange.getId(), this.magicBranch.cmd.getNewId());
        try (MergeOp mergeOp = this.mergeOpProvider.get();){
            mergeOp.merge(this.db, tipChange, this.user, false, new SubmitInput(), false);
        }
    }

    private void preparePatchSetsForReplace() {
        try {
            this.readChangesForReplace();
            Iterator<ReplaceRequest> itr = this.replaceByChange.values().iterator();
            while (itr.hasNext()) {
                ReplaceRequest replaceRequest = itr.next();
                if (replaceRequest.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                replaceRequest.validate(false);
                if (!replaceRequest.skip || replaceRequest.cmd != null) continue;
                itr.remove();
            }
        }
        catch (OrmException err) {
            this.logError(String.format("Cannot read database before replacement for project %s", this.project.getName()), err);
            for (ReplaceRequest req : this.replaceByChange.values()) {
                if (req.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                req.inputCommand.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
            }
        }
        catch (IOException err) {
            this.logError(String.format("Cannot read repository before replacement for project %s", this.project.getName()), err);
            for (ReplaceRequest req : this.replaceByChange.values()) {
                if (req.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) continue;
                req.inputCommand.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "internal server error");
            }
        }
        this.logDebug("Read {} changes to replace", this.replaceByChange.size());
        for (ReplaceRequest replaceRequest : this.replaceByChange.values()) {
            if (replaceRequest.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED || replaceRequest.cmd == null) continue;
            if (replaceRequest.prev != null) {
                this.batch.addCommand(replaceRequest.prev);
            }
            this.batch.addCommand(replaceRequest.cmd);
        }
        if (this.magicBranch != null && this.magicBranch.cmd.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
            for (ReplaceRequest replaceRequest : this.replaceByChange.values()) {
                if (replaceRequest.inputCommand != this.magicBranch.cmd || replaceRequest.cmd == null) continue;
                replaceRequest.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "aborted");
            }
            for (CreateRequest createRequest : this.newChanges) {
                createRequest.cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, "aborted");
            }
        }
    }

    private void readChangesForReplace() throws OrmException {
        List<ChangeNotes> allNotes = this.notesFactory.create(this.db, this.replaceByChange.values().stream().map(r -> r.ontoChange).collect(Collectors.toList()));
        Iterator iterator = allNotes.iterator();
        while (iterator.hasNext()) {
            ChangeNotes notes;
            this.replaceByChange.get((Object)notes.getChangeId()).notes = notes = (ChangeNotes)iterator.next();
        }
    }

    private List<Ref> refs(Change.Id changeId) {
        return this.refsByChange().get((Object)changeId);
    }

    private void initChangeRefMaps() {
        if (this.refsByChange == null) {
            int estRefsPerChange = 4;
            this.refsById = MultimapBuilder.hashKeys().arrayListValues().build();
            this.refsByChange = MultimapBuilder.hashKeys(this.allRefs.size() / estRefsPerChange).arrayListValues(estRefsPerChange).build();
            for (Ref ref : this.allRefs.values()) {
                PatchSet.Id psId;
                ObjectId obj = ref.getObjectId();
                if (obj == null || (psId = PatchSet.Id.fromRef(ref.getName())) == null) continue;
                this.refsById.put(obj, ref);
                this.refsByChange.put(psId.getParentKey(), ref);
            }
        }
    }

    private ListMultimap<Change.Id, Ref> refsByChange() {
        this.initChangeRefMaps();
        return this.refsByChange;
    }

    private ListMultimap<ObjectId, Ref> changeRefsById() {
        this.initChangeRefMaps();
        return this.refsById;
    }

    static boolean parentsEqual(RevCommit a, RevCommit b) {
        if (a.getParentCount() != b.getParentCount()) {
            return false;
        }
        for (int i = 0; i < a.getParentCount(); ++i) {
            if (a.getParent(i).equals(b.getParent(i))) continue;
            return false;
        }
        return true;
    }

    static boolean authorEqual(RevCommit a, RevCommit b) {
        PersonIdent aAuthor = a.getAuthorIdent();
        PersonIdent bAuthor = b.getAuthorIdent();
        if (aAuthor == null && bAuthor == null) {
            return true;
        }
        if (aAuthor == null || bAuthor == null) {
            return false;
        }
        return ReceiveCommits.eq(aAuthor.getName(), bAuthor.getName()) && ReceiveCommits.eq(aAuthor.getEmailAddress(), bAuthor.getEmailAddress());
    }

    static boolean eq(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    private boolean validRefOperation(ReceiveCommand cmd) {
        RefOperationValidators refValidators = this.refValidatorsFactory.create(this.getProject(), this.user, cmd);
        try {
            this.messages.addAll(refValidators.validateForRefOperation());
        }
        catch (RefOperationValidationException e) {
            this.messages.addAll(Lists.newArrayList(e.getMessages()));
            this.reject(cmd, e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateNewCommits(RefControl ctl, ReceiveCommand cmd) {
        if (ctl.canForgeAuthor() && ctl.canForgeCommitter() && ctl.canForgeGerritServerIdentity() && ctl.canUploadMerges() && !this.projectControl.getProjectState().isUseSignedOffBy() && Iterables.isEmpty(this.rejectCommits) && !"refs/meta/config".equals(ctl.getRefName()) && !MagicBranch.isMagicBranch(cmd.getRefName()) && !NEW_PATCHSET.matcher(cmd.getRefName()).matches()) {
            this.logDebug("Short-circuiting new commit validation", new Object[0]);
            return;
        }
        boolean defaultName = Strings.isNullOrEmpty(this.user.getAccount().getFullName());
        RevWalk walk = this.rp.getRevWalk();
        walk.reset();
        walk.sort(RevSort.NONE);
        try {
            RevCommit c;
            RevObject parsedObject = walk.parseAny(cmd.getNewId());
            if (!(parsedObject instanceof RevCommit)) {
                return;
            }
            ListMultimap<ObjectId, Ref> existing = this.changeRefsById();
            walk.markStart((RevCommit)parsedObject);
            this.markHeadsAsUninteresting(walk, cmd.getRefName());
            int i = 0;
            while ((c = walk.next()) != null) {
                ++i;
                if (existing.keySet().contains(c)) continue;
                if (!this.validCommit(walk, ctl, cmd, c)) break;
                if (!defaultName || !this.user.hasEmailAddress(c.getCommitterIdent().getEmailAddress())) continue;
                try {
                    Account a = this.db.accounts().get(this.user.getAccountId());
                    if (a == null || !Strings.isNullOrEmpty(a.getFullName())) continue;
                    a.setFullName(c.getCommitterIdent().getName());
                    this.db.accounts().update(Collections.singleton(a));
                    this.user.getAccount().setFullName(a.getFullName());
                    this.accountCache.evict(a.getId());
                }
                catch (OrmException e) {
                    this.logWarn("Cannot default full_name", e);
                }
                finally {
                    defaultName = false;
                }
            }
            this.logDebug("Validated {} new commits", i);
        }
        catch (IOException err) {
            cmd.setResult(ReceiveCommand.Result.REJECTED_MISSING_OBJECT);
            this.logError("Invalid pack upload; one or more objects weren't sent", err);
        }
    }

    private boolean validCommit(RevWalk rw, RefControl ctl, ReceiveCommand cmd, ObjectId id) throws IOException {
        if (this.validCommits.contains(id)) {
            return true;
        }
        RevCommit c = rw.parseCommit(id);
        rw.parseBody(c);
        CommitReceivedEvent receiveEvent = new CommitReceivedEvent(cmd, this.project, ctl.getRefName(), c, this.user);
        CommitValidators.Policy policy = this.magicBranch != null && cmd.getRefName().equals(this.magicBranch.cmd.getRefName()) && this.magicBranch.merged ? CommitValidators.Policy.MERGED : CommitValidators.Policy.RECEIVE_COMMITS;
        try {
            this.messages.addAll(this.commitValidatorsFactory.create(policy, ctl, this.sshInfo, this.repo).validate(receiveEvent));
        }
        catch (CommitValidationException e) {
            this.logDebug("Commit validation failed on {}", c.name());
            this.messages.addAll(e.getMessages());
            this.reject(cmd, e.getMessage());
            return false;
        }
        this.validCommits.add(c.copy());
        return true;
    }

    private void autoCloseChanges(ReceiveCommand cmd) {
        this.logDebug("Starting auto-closing of changes", new Object[0]);
        String refName = cmd.getRefName();
        Preconditions.checkState(!MagicBranch.isMagicBranch(refName), "shouldn't be auto-closing changes on magic branch %s", (Object)refName);
        RevWalk rw = this.rp.getRevWalk();
        try (BatchUpdate bu = this.batchUpdateFactory.create(this.db, this.projectControl.getProject().getNameKey(), this.user, TimeUtil.nowTs());
             ObjectInserter ins = this.repo.newObjectInserter();){
            RevCommit c;
            bu.setRepository(this.repo, this.rp.getRevWalk(), ins).updateChangesInParallel();
            bu.setRequestId(this.receiveId);
            RevCommit newTip = rw.parseCommit(cmd.getNewId());
            Branch.NameKey branch = new Branch.NameKey(this.project.getNameKey(), refName);
            rw.reset();
            rw.markStart(newTip);
            if (!ObjectId.zeroId().equals(cmd.getOldId())) {
                rw.markUninteresting(rw.parseCommit(cmd.getOldId()));
            }
            ListMultimap<ObjectId, Ref> byCommit = this.changeRefsById();
            Map<Change.Key, ChangeNotes> byKey = null;
            ArrayList<ReplaceRequest> replaceAndClose = new ArrayList<ReplaceRequest>();
            int existingPatchSets = 0;
            int newPatchSets = 0;
            block13: while ((c = rw.next()) != null) {
                rw.parseBody(c);
                for (Ref ref : byCommit.get((Object)c.copy())) {
                    PatchSet.Id psId = PatchSet.Id.fromRef(ref.getName());
                    Optional<ChangeData> cd = this.byLegacyId(psId.getParentKey());
                    if (!cd.isPresent() || !cd.get().change().getDest().equals(branch)) continue;
                    ++existingPatchSets;
                    bu.addOp(psId.getParentKey(), this.mergedByPushOpFactory.create(this.requestScopePropagator, psId, refName));
                    continue block13;
                }
                for (String changeId : c.getFooterLines(FooterConstants.CHANGE_ID)) {
                    ChangeNotes onto;
                    if (byKey == null) {
                        byKey = this.openChangesByKeyByBranch(branch);
                    }
                    if ((onto = byKey.get(new Change.Key(changeId.trim()))) == null) continue;
                    ++newPatchSets;
                    ReplaceRequest req = new ReplaceRequest(onto.getChangeId(), c, cmd, false);
                    req.notes = onto;
                    replaceAndClose.add(req);
                    continue block13;
                }
            }
            for (final ReplaceRequest req : replaceAndClose) {
                Change.Id id = req.notes.getChangeId();
                if (!req.validate(true)) {
                    this.logDebug("Not closing {} because validation failed", id);
                    continue;
                }
                req.addOps(bu, null);
                bu.addOp(id, this.mergedByPushOpFactory.create(this.requestScopePropagator, req.psId, refName).setPatchSetProvider(new Provider<PatchSet>(){

                    @Override
                    public PatchSet get() {
                        return req.replaceOp.getPatchSet();
                    }
                }));
                bu.addOp(id, new ChangeProgressOp(this.closeProgress));
            }
            this.logDebug("Auto-closing {} changes with existing patch sets and {} with new patch sets", existingPatchSets, newPatchSets);
            bu.execute();
        }
        catch (RestApiException e) {
            this.logError("Can't insert patchset", e);
        }
        catch (UpdateException | OrmException | IOException e) {
            this.logError("Can't scan for changes to close", e);
        }
    }

    private Map<Change.Key, ChangeNotes> openChangesByKeyByBranch(Branch.NameKey branch) throws OrmException {
        HashMap<Change.Key, ChangeNotes> r = new HashMap<Change.Key, ChangeNotes>();
        for (ChangeData cd : this.queryProvider.get().byBranchOpen(branch)) {
            try {
                r.put(cd.change().getKey(), cd.notes());
            }
            catch (NoSuchChangeException noSuchChangeException) {}
        }
        return r;
    }

    private Optional<ChangeData> byLegacyId(Change.Id legacyId) throws OrmException {
        List<ChangeData> res = this.queryProvider.get().byLegacyChangeId(legacyId);
        if (res.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(res.get(0));
    }

    private void reject(ReceiveCommand cmd, String why) {
        cmd.setResult(ReceiveCommand.Result.REJECTED_OTHER_REASON, why);
        this.commandProgress.update(1);
    }

    private static boolean isHead(ReceiveCommand cmd) {
        return cmd.getRefName().startsWith("refs/heads/");
    }

    private static boolean isConfig(ReceiveCommand cmd) {
        return cmd.getRefName().equals("refs/meta/config");
    }

    private void logDebug(String msg, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug(this.receiveId + msg, args);
        }
    }

    private void logWarn(String msg, Throwable t) {
        if (log.isWarnEnabled()) {
            if (t != null) {
                log.warn(this.receiveId + msg, t);
            } else {
                log.warn(this.receiveId + msg);
            }
        }
    }

    private void logWarn(String msg) {
        this.logWarn(msg, null);
    }

    private void logError(String msg, Throwable t) {
        if (log.isErrorEnabled()) {
            if (t != null) {
                log.error(this.receiveId + msg, t);
            } else {
                log.error(this.receiveId + msg);
            }
        }
    }

    private void logError(String msg) {
        this.logError(msg, null);
    }

    private class UpdateGroupsRequest {
        private final PatchSet.Id psId;
        private final RevCommit commit;
        List<String> groups = ImmutableList.of();

        UpdateGroupsRequest(Ref ref, RevCommit commit) {
            this.psId = Preconditions.checkNotNull(PatchSet.Id.fromRef(ref.getName()));
            this.commit = commit;
        }

        private void addOps(BatchUpdate bu) {
            bu.addOp(this.psId.getParentKey(), new BatchUpdateOp(){

                @Override
                public boolean updateChange(ChangeContext ctx) throws OrmException {
                    PatchSet ps = ReceiveCommits.this.psUtil.get(ctx.getDb(), ctx.getNotes(), UpdateGroupsRequest.this.psId);
                    List<String> oldGroups = ps.getGroups();
                    if (oldGroups == null ? UpdateGroupsRequest.this.groups == null : UpdateGroupsRequest.this.sameGroups(oldGroups, UpdateGroupsRequest.this.groups)) {
                        return false;
                    }
                    ReceiveCommits.this.psUtil.setGroups(ctx.getDb(), ctx.getUpdate(UpdateGroupsRequest.this.psId), ps, UpdateGroupsRequest.this.groups);
                    return true;
                }
            });
        }

        private boolean sameGroups(List<String> a, List<String> b) {
            return Sets.newHashSet(a).equals(Sets.newHashSet(b));
        }
    }

    private class ReplaceRequest {
        final Change.Id ontoChange;
        final ObjectId newCommitId;
        final ReceiveCommand inputCommand;
        final boolean checkMergedInto;
        ChangeNotes notes;
        ChangeControl changeCtl;
        BiMap<RevCommit, PatchSet.Id> revisions;
        PatchSet.Id psId;
        ReceiveCommand prev;
        ReceiveCommand cmd;
        PatchSetInfo info;
        boolean skip;
        private PatchSet.Id priorPatchSet;
        List<String> groups = ImmutableList.of();
        private ReplaceOp replaceOp;

        ReplaceRequest(Change.Id toChange, RevCommit newCommit, ReceiveCommand cmd, boolean checkMergedInto) {
            this.ontoChange = toChange;
            this.newCommitId = newCommit.copy();
            this.inputCommand = cmd;
            this.checkMergedInto = checkMergedInto;
            this.revisions = HashBiMap.create();
            for (Ref ref : ReceiveCommits.this.refs(toChange)) {
                try {
                    this.revisions.forcePut(ReceiveCommits.this.rp.getRevWalk().parseCommit(ref.getObjectId()), PatchSet.Id.fromRef(ref.getName()));
                }
                catch (IOException err) {
                    ReceiveCommits.this.logWarn(String.format("Project %s contains invalid change ref %s", ReceiveCommits.this.project.getName(), ref.getName()), err);
                }
            }
        }

        boolean validate(boolean autoClose) throws IOException, OrmException {
            if (!autoClose && this.inputCommand.getResult() != ReceiveCommand.Result.NOT_ATTEMPTED) {
                return false;
            }
            if (this.notes == null) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " not found");
                return false;
            }
            this.priorPatchSet = this.notes.getChange().currentPatchSetId();
            if (!this.revisions.containsValue(this.priorPatchSet)) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " missing revisions");
                return false;
            }
            RevCommit newCommit = ReceiveCommits.this.rp.getRevWalk().parseCommit(this.newCommitId);
            RevCommit priorCommit = (RevCommit)this.revisions.inverse().get(this.priorPatchSet);
            this.changeCtl = ReceiveCommits.this.projectControl.controlFor(this.notes);
            if (!this.changeCtl.canAddPatchSet(ReceiveCommits.this.db)) {
                String locked = ".";
                if (this.changeCtl.isPatchSetLocked(ReceiveCommits.this.db)) {
                    locked = ". Change is patch set locked.";
                }
                ReceiveCommits.this.reject(this.inputCommand, "cannot add patch set to " + this.ontoChange + locked);
                return false;
            }
            if (this.notes.getChange().getStatus().isClosed()) {
                ReceiveCommits.this.reject(this.inputCommand, "change " + this.ontoChange + " closed");
                return false;
            }
            if (this.revisions.containsKey(newCommit)) {
                ReceiveCommits.this.reject(this.inputCommand, "commit already exists (in the change)");
                return false;
            }
            for (Ref r : ReceiveCommits.this.rp.getRepository().getRefDatabase().getRefs("refs/changes").values()) {
                if (!r.getObjectId().equals(newCommit)) continue;
                ReceiveCommits.this.reject(this.inputCommand, "commit already exists (in the project)");
                return false;
            }
            for (RevCommit prior : this.revisions.keySet()) {
                if (!ReceiveCommits.this.rp.getRevWalk().isMergedInto(prior, newCommit)) continue;
                ReceiveCommits.this.reject(this.inputCommand, ReceiveCommits.SAME_CHANGE_ID_IN_MULTIPLE_CHANGES);
                return false;
            }
            if (!ReceiveCommits.this.validCommit(ReceiveCommits.this.rp.getRevWalk(), this.changeCtl.getRefControl(), this.inputCommand, newCommit)) {
                return false;
            }
            ReceiveCommits.this.rp.getRevWalk().parseBody(priorCommit);
            if (newCommit.getTree().equals(priorCommit.getTree())) {
                boolean messageEq = ReceiveCommits.eq(newCommit.getFullMessage(), priorCommit.getFullMessage());
                boolean parentsEq = ReceiveCommits.parentsEqual(newCommit, priorCommit);
                boolean authorEq = ReceiveCommits.authorEqual(newCommit, priorCommit);
                ObjectReader reader = ReceiveCommits.this.rp.getRevWalk().getObjectReader();
                if (messageEq && parentsEq && authorEq && !autoClose) {
                    ReceiveCommits.this.addMessage(String.format("(W) No changes between prior commit %s and new commit %s", reader.abbreviate(priorCommit).name(), reader.abbreviate(newCommit).name()));
                } else {
                    StringBuilder msg = new StringBuilder();
                    msg.append("(I) ");
                    msg.append(reader.abbreviate(newCommit).name());
                    msg.append(":");
                    msg.append(" no files changed");
                    if (!authorEq) {
                        msg.append(", author changed");
                    }
                    if (!messageEq) {
                        msg.append(", message updated");
                    }
                    if (!parentsEq) {
                        msg.append(", was rebased");
                    }
                    ReceiveCommits.this.addMessage(msg.toString());
                }
            }
            if (ReceiveCommits.this.magicBranch != null && ((ReceiveCommits)ReceiveCommits.this).magicBranch.edit) {
                return this.newEdit();
            }
            this.newPatchSet();
            return true;
        }

        private boolean newEdit() {
            this.psId = this.notes.getChange().currentPatchSetId();
            Optional<ChangeEdit> edit = null;
            try {
                edit = ReceiveCommits.this.editUtil.byChange(this.changeCtl);
            }
            catch (AuthException | IOException e) {
                ReceiveCommits.this.logError("Cannot retrieve edit", e);
                return false;
            }
            if (edit.isPresent()) {
                if (edit.get().getBasePatchSet().getId().equals(this.psId)) {
                    this.cmd = new ReceiveCommand(edit.get().getRef().getObjectId(), this.newCommitId, edit.get().getRefName());
                } else {
                    this.prev = new ReceiveCommand(edit.get().getRef().getObjectId(), ObjectId.zeroId(), edit.get().getRefName());
                    this.createEditCommand();
                }
            } else {
                this.createEditCommand();
            }
            return true;
        }

        private void createEditCommand() {
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.newCommitId, RefNames.refsEdit(ReceiveCommits.this.user.getAccountId(), this.notes.getChangeId(), this.psId));
        }

        private void newPatchSet() throws IOException {
            RevCommit newCommit = ReceiveCommits.this.rp.getRevWalk().parseCommit(this.newCommitId);
            this.psId = ChangeUtil.nextPatchSetId(ReceiveCommits.this.allRefs, this.notes.getChange().currentPatchSetId());
            this.info = ReceiveCommits.this.patchSetInfoFactory.get(ReceiveCommits.this.rp.getRevWalk(), newCommit, this.psId);
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.newCommitId, this.psId.toRefName());
        }

        void addOps(BatchUpdate bu, @Nullable MultiProgressMonitor.Task progress) throws IOException {
            if (this.cmd.getResult() == ReceiveCommand.Result.NOT_ATTEMPTED) {
                this.cmd.execute(ReceiveCommits.this.rp);
            }
            if (ReceiveCommits.this.magicBranch != null && ((ReceiveCommits)ReceiveCommits.this).magicBranch.edit) {
                bu.addOp(this.notes.getChangeId(), new BatchUpdateOp(){

                    @Override
                    public boolean updateChange(ChangeContext ctx) throws Exception {
                        return true;
                    }
                });
                return;
            }
            RevWalk rw = ReceiveCommits.this.rp.getRevWalk();
            RevCommit newCommit = rw.parseCommit(this.newCommitId);
            rw.parseBody(newCommit);
            RevCommit priorCommit = (RevCommit)this.revisions.inverse().get(this.priorPatchSet);
            this.replaceOp = ReceiveCommits.this.replaceOpFactory.create(ReceiveCommits.this.projectControl, this.notes.getChange().getDest(), this.checkMergedInto, this.priorPatchSet, priorCommit, this.psId, newCommit, this.info, this.groups, ReceiveCommits.this.magicBranch, ReceiveCommits.this.rp.getPushCertificate()).setRequestScopePropagator(ReceiveCommits.this.requestScopePropagator).setUpdateRef(false);
            bu.addOp(this.notes.getChangeId(), this.replaceOp);
            if (progress != null) {
                bu.addOp(this.notes.getChangeId(), new ChangeProgressOp(progress));
            }
        }

        void insertPatchSetWithoutBatchUpdate() throws IOException, UpdateException, RestApiException {
            try (BatchUpdate bu = ReceiveCommits.this.batchUpdateFactory.create(ReceiveCommits.this.db, ReceiveCommits.this.projectControl.getProject().getNameKey(), ReceiveCommits.this.user, TimeUtil.nowTs());
                 ObjectInserter ins = ReceiveCommits.this.repo.newObjectInserter();){
                bu.setRepository(ReceiveCommits.this.repo, ReceiveCommits.this.rp.getRevWalk(), ins);
                bu.setRequestId(ReceiveCommits.this.receiveId);
                this.addOps(bu, ReceiveCommits.this.replaceProgress);
                bu.execute();
            }
        }

        String getRejectMessage() {
            return this.replaceOp != null ? this.replaceOp.getRejectMessage() : null;
        }
    }

    private class CreateRequest {
        final RevCommit commit;
        private final String refName;
        Change.Id changeId;
        ReceiveCommand cmd;
        ChangeInserter ins;
        List<String> groups = ImmutableList.of();
        Change change;

        CreateRequest(RevCommit commit, String refName) {
            this.commit = commit;
            this.refName = refName;
        }

        private void setChangeId(int id) {
            this.changeId = new Change.Id(id);
            this.ins = ReceiveCommits.this.changeInserterFactory.create(this.changeId, this.commit, this.refName).setTopic(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic).setValidatePolicy(CommitValidators.Policy.NONE);
            if (((ReceiveCommits)ReceiveCommits.this).magicBranch.draft) {
                this.ins.setDraft(((ReceiveCommits)ReceiveCommits.this).magicBranch.draft);
            } else if (((ReceiveCommits)ReceiveCommits.this).magicBranch.merged) {
                this.ins.setStatus(Change.Status.MERGED);
            }
            this.cmd = new ReceiveCommand(ObjectId.zeroId(), this.commit, this.ins.getPatchSetId().toRefName());
            if (ReceiveCommits.this.rp.getPushCertificate() != null) {
                this.ins.setPushCertificate(ReceiveCommits.this.rp.getPushCertificate().toTextWithSignature());
            }
        }

        private void addOps(BatchUpdate bu) throws RestApiException {
            Preconditions.checkState(this.changeId != null, "must call setChangeId before addOps");
            try {
                RevWalk rw = ReceiveCommits.this.rp.getRevWalk();
                rw.parseBody(this.commit);
                final PatchSet.Id psId = this.ins.setGroups(this.groups).getPatchSetId();
                Account.Id me = ReceiveCommits.this.user.getAccountId();
                List<FooterLine> footerLines = this.commit.getFooterLines();
                MailUtil.MailRecipients recipients = new MailUtil.MailRecipients();
                HashMap<String, Short> approvals = new HashMap();
                Preconditions.checkNotNull(ReceiveCommits.this.magicBranch);
                recipients.add(ReceiveCommits.this.magicBranch.getMailRecipients());
                approvals = ((ReceiveCommits)ReceiveCommits.this).magicBranch.labels;
                recipients.add(MailUtil.getRecipientsFromFooters(ReceiveCommits.this.db, ReceiveCommits.this.accountResolver, ((ReceiveCommits)ReceiveCommits.this).magicBranch.draft, footerLines));
                recipients.remove(me);
                StringBuilder msg = new StringBuilder(ApprovalsUtil.renderMessageWithApprovals(psId.get(), approvals, Collections.emptyMap()));
                msg.append('.');
                if (!Strings.isNullOrEmpty(((ReceiveCommits)ReceiveCommits.this).magicBranch.message)) {
                    msg.append("\n").append(((ReceiveCommits)ReceiveCommits.this).magicBranch.message);
                }
                bu.insertChange(this.ins.setReviewers(recipients.getReviewers()).setExtraCC(recipients.getCcOnly()).setApprovals(approvals).setMessage(msg.toString()).setNotify(((ReceiveCommits)ReceiveCommits.this).magicBranch.notify).setAccountsToNotify(ReceiveCommits.this.magicBranch.getAccountsToNotify()).setRequestScopePropagator(ReceiveCommits.this.requestScopePropagator).setSendMail(true).setUpdateRef(false).setPatchSetDescription(((ReceiveCommits)ReceiveCommits.this).magicBranch.message));
                if (!((ReceiveCommits)ReceiveCommits.this).magicBranch.hashtags.isEmpty()) {
                    bu.addOp(this.changeId, ReceiveCommits.this.hashtagsFactory.create(new HashtagsInput(((ReceiveCommits)ReceiveCommits.this).magicBranch.hashtags)).setFireEvent(false));
                }
                if (!Strings.isNullOrEmpty(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic)) {
                    bu.addOp(this.changeId, new BatchUpdateOp(){

                        @Override
                        public boolean updateChange(ChangeContext ctx) {
                            ctx.getUpdate(psId).setTopic(((ReceiveCommits)ReceiveCommits.this).magicBranch.topic);
                            return true;
                        }
                    });
                }
                bu.addOp(this.changeId, new BatchUpdateOp(){

                    @Override
                    public boolean updateChange(ChangeContext ctx) {
                        CreateRequest.this.change = ctx.getChange();
                        return false;
                    }
                });
                bu.addOp(this.changeId, new ChangeProgressOp(ReceiveCommits.this.newProgress));
            }
            catch (Exception e) {
                throw (RestApiException)INSERT_EXCEPTION.apply(e);
            }
        }
    }

    private class ChangeLookup {
        final RevCommit commit;
        final Change.Key changeKey;
        final List<ChangeData> destChanges;

        ChangeLookup(RevCommit c, Change.Key key) throws OrmException {
            this.commit = c;
            this.changeKey = key;
            this.destChanges = ((InternalChangeQuery)ReceiveCommits.this.queryProvider.get()).byBranchKey(((ReceiveCommits)ReceiveCommits.this).magicBranch.dest, key);
        }

        ChangeLookup(RevCommit c) throws OrmException {
            this.commit = c;
            this.destChanges = ((InternalChangeQuery)ReceiveCommits.this.queryProvider.get()).byBranchCommit(((ReceiveCommits)ReceiveCommits.this).magicBranch.dest, c.getName());
            this.changeKey = null;
        }
    }

    static class MagicBranchInput {
        private static final Splitter COMMAS = Splitter.on(',').omitEmptyStrings();
        final ReceiveCommand cmd;
        Branch.NameKey dest;
        RefControl ctl;
        Set<Account.Id> reviewer = Sets.newLinkedHashSet();
        Set<Account.Id> cc = Sets.newLinkedHashSet();
        Map<String, Short> labels = new HashMap<String, Short>();
        String message;
        List<RevCommit> baseCommit;
        LabelTypes labelTypes;
        CmdLineParser clp;
        Set<String> hashtags = new HashSet<String>();
        NotesMigration notesMigration;
        @Option(name="--base", metaVar="BASE", usage="merge base of changes")
        List<ObjectId> base;
        @Option(name="--topic", metaVar="NAME", usage="attach topic to changes")
        String topic;
        @Option(name="--draft", usage="mark new/updated changes as draft")
        boolean draft;
        @Option(name="--edit", aliases={"-e"}, usage="upload as change edit")
        boolean edit;
        @Option(name="--submit", usage="immediately submit the change")
        boolean submit;
        @Option(name="--merged", usage="create single change for a merged commit")
        boolean merged;
        @Option(name="--notify", usage="Notify handling that defines to whom email notifications should be sent. Allowed values are NONE, OWNER, OWNER_REVIEWERS, ALL. If not set, the default is ALL.")
        NotifyHandling notify = NotifyHandling.ALL;
        @Option(name="--notify-to", metaVar="USER", usage="user that should be notified")
        List<Account.Id> tos = new ArrayList<Account.Id>();
        @Option(name="--notify-cc", metaVar="USER", usage="user that should be CC'd")
        List<Account.Id> ccs = new ArrayList<Account.Id>();
        @Option(name="--notify-bcc", metaVar="USER", usage="user that should be BCC'd")
        List<Account.Id> bccs = new ArrayList<Account.Id>();

        @Option(name="--reviewer", aliases={"-r"}, metaVar="EMAIL", usage="add reviewer to changes")
        void reviewer(Account.Id id) {
            this.reviewer.add(id);
        }

        @Option(name="--cc", metaVar="EMAIL", usage="notify user by CC")
        void cc(Account.Id id) {
            this.cc.add(id);
        }

        @Option(name="--publish", usage="publish new/updated changes")
        void publish(boolean publish) {
            this.draft = !publish;
        }

        @Option(name="--label", aliases={"-l"}, metaVar="LABEL+VALUE", usage="label(s) to assign (defaults to +1 if no value provided")
        void addLabel(String token) throws CmdLineException {
            LabelVote v = LabelVote.parse(token);
            try {
                LabelType.checkName(v.label());
                ApprovalsUtil.checkLabel(this.labelTypes, v.label(), v.value());
            }
            catch (BadRequestException e) {
                throw this.clp.reject(e.getMessage());
            }
            this.labels.put(v.label(), v.value());
        }

        @Option(name="--message", aliases={"-m"}, metaVar="MESSAGE", usage="Comment message to apply to the review")
        void addMessage(String token) {
            this.message = token.replace("_", " ");
        }

        @Option(name="--hashtag", aliases={"-t"}, metaVar="HASHTAG", usage="add hashtag to changes")
        void addHashtag(String token) throws CmdLineException {
            if (!this.notesMigration.readChanges()) {
                throw this.clp.reject("cannot add hashtags; noteDb is disabled");
            }
            String hashtag = HashtagsUtil.cleanupHashtag(token);
            if (!hashtag.isEmpty()) {
                this.hashtags.add(hashtag);
            }
        }

        MagicBranchInput(ReceiveCommand cmd, LabelTypes labelTypes, NotesMigration notesMigration) {
            this.cmd = cmd;
            this.draft = cmd.getRefName().startsWith("refs/drafts/");
            this.labelTypes = labelTypes;
            this.notesMigration = notesMigration;
        }

        MailUtil.MailRecipients getMailRecipients() {
            return new MailUtil.MailRecipients(this.reviewer, this.cc);
        }

        ListMultimap<RecipientType, Account.Id> getAccountsToNotify() {
            Multimap accountsToNotify = MultimapBuilder.hashKeys().arrayListValues().build();
            accountsToNotify.putAll(RecipientType.TO, this.tos);
            accountsToNotify.putAll(RecipientType.CC, this.ccs);
            accountsToNotify.putAll(RecipientType.BCC, this.bccs);
            return accountsToNotify;
        }

        String parse(CmdLineParser clp, Repository repo, Set<String> refs, ListMultimap<String, String> pushOptions) throws CmdLineException {
            String name;
            String ref = RefNames.fullName(MagicBranch.getDestBranchName(this.cmd.getRefName()));
            LinkedListMultimap<String, String> options = LinkedListMultimap.create(pushOptions);
            int optionStart = ref.indexOf(37);
            if (0 < optionStart) {
                for (String s : COMMAS.split(ref.substring(optionStart + 1))) {
                    int e = s.indexOf(61);
                    if (0 < e) {
                        options.put(s.substring(0, e), s.substring(e + 1));
                        continue;
                    }
                    options.put(s, "");
                }
                ref = ref.substring(0, optionStart);
            }
            if (!options.isEmpty()) {
                clp.parseOptionMap(options);
            }
            String head = ReceiveCommits.readHEAD(repo);
            int split = ref.length();
            while (!refs.contains(name = ref.substring(0, split)) && !name.equals(head)) {
                if ((split = name.lastIndexOf(47, split - 1)) > "refs/".length()) continue;
                return ref;
            }
            if (split < ref.length()) {
                this.topic = Strings.emptyToNull(ref.substring(split + 1));
            }
            return ref.substring(0, split);
        }
    }

    private class ReceivePackMessageSender
    implements MessageSender {
        private ReceivePackMessageSender() {
        }

        @Override
        public void sendMessage(String what) {
            ReceiveCommits.this.rp.sendMessage(what);
        }

        @Override
        public void sendError(String what) {
            ReceiveCommits.this.rp.sendError(what);
        }

        @Override
        public void sendBytes(byte[] what) {
            this.sendBytes(what, 0, what.length);
        }

        @Override
        public void sendBytes(byte[] what, int off, int len) {
            try {
                ReceiveCommits.this.rp.getMessageOutputStream().write(what, off, len);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void flush() {
            try {
                ReceiveCommits.this.rp.getMessageOutputStream().flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface MessageSender {
        public void sendMessage(String var1);

        public void sendError(String var1);

        public void sendBytes(byte[] var1);

        public void sendBytes(byte[] var1, int var2, int var3);

        public void flush();
    }

    static interface Factory {
        public ReceiveCommits create(ProjectControl var1, Repository var2);
    }

    private static enum Error {
        CONFIG_UPDATE("You are not allowed to perform this operation.\nConfiguration changes can only be pushed by project owners\nwho also have 'Push' rights on refs/meta/config"),
        UPDATE("You are not allowed to perform this operation.\nTo push into this reference you need 'Push' rights."),
        DELETE("You need 'Delete Reference' rights or 'Push' rights with the \n'Force Push' flag set to delete references."),
        DELETE_CHANGES("Cannot delete from 'refs/changes/'"),
        CODE_REVIEW("You need 'Push' rights to upload code review requests.\nVerify that you are pushing to the right branch.");

        private final String value;

        private Error(String value) {
            this.value = value;
        }

        public String get() {
            return this.value;
        }
    }
}

