/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Sets;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.client.SubmitType;
import com.google.gerrit.extensions.config.FactoryModule;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.GerritPersonIdent;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.change.RebaseChangeOp;
import com.google.gerrit.server.extensions.events.ChangeMerged;
import com.google.gerrit.server.git.CodeReviewCommit;
import com.google.gerrit.server.git.EmailMerge;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.IntegrationException;
import com.google.gerrit.server.git.LabelNormalizer;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeSorter;
import com.google.gerrit.server.git.MergeTip;
import com.google.gerrit.server.git.MergeUtil;
import com.google.gerrit.server.git.SubmoduleOp;
import com.google.gerrit.server.git.TagCache;
import com.google.gerrit.server.git.strategy.ImplicitIntegrateOp;
import com.google.gerrit.server.git.strategy.SubmitStrategyOp;
import com.google.gerrit.server.git.validators.OnSubmitValidators;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectState;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.update.BatchUpdate;
import com.google.gerrit.server.util.RequestId;
import com.google.inject.Module;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;

public abstract class SubmitStrategy {
    final Arguments args;

    public static Module module() {
        return new FactoryModule(){

            @Override
            protected void configure() {
                this.factory(Arguments.Factory.class);
            }
        };
    }

    SubmitStrategy(Arguments args) {
        this.args = Preconditions.checkNotNull(args);
    }

    public final void addOps(BatchUpdate bu, Set<CodeReviewCommit> toMerge) throws IntegrationException {
        List<SubmitStrategyOp> ops = this.buildOps(toMerge);
        HashSet<CodeReviewCommit> added = Sets.newHashSetWithExpectedSize(ops.size());
        for (SubmitStrategyOp op : ops) {
            added.add(op.getCommit());
        }
        ArrayList<CodeReviewCommit> difference = new ArrayList<CodeReviewCommit>(Sets.difference(toMerge, added));
        Collections.reverse(difference);
        for (CodeReviewCommit c : difference) {
            bu.addOp(c.change().getId(), new ImplicitIntegrateOp(this.args, c));
        }
        for (SubmitStrategyOp op : ops) {
            bu.addOp(op.getId(), op);
        }
    }

    protected abstract List<SubmitStrategyOp> buildOps(Collection<CodeReviewCommit> var1) throws IntegrationException;

    static class Arguments {
        final AccountCache accountCache;
        final ApprovalsUtil approvalsUtil;
        final BatchUpdate.Factory batchUpdateFactory;
        final ChangeControl.GenericFactory changeControlFactory;
        final ChangeMerged changeMerged;
        final ChangeMessagesUtil cmUtil;
        final EmailMerge.Factory mergedSenderFactory;
        final GitRepositoryManager repoManager;
        final LabelNormalizer labelNormalizer;
        final PatchSetInfoFactory patchSetInfoFactory;
        final PatchSetUtil psUtil;
        final ProjectCache projectCache;
        final PersonIdent serverIdent;
        final RebaseChangeOp.Factory rebaseFactory;
        final OnSubmitValidators.Factory onSubmitValidatorsFactory;
        final TagCache tagCache;
        final InternalChangeQuery internalChangeQuery;
        final Branch.NameKey destBranch;
        final CodeReviewCommit.CodeReviewRevWalk rw;
        final MergeOp.CommitStatus commitStatus;
        final IdentifiedUser caller;
        final MergeTip mergeTip;
        final ObjectInserter inserter;
        final Repository repo;
        final RevFlag canMergeFlag;
        final ReviewDb db;
        final Set<RevCommit> alreadyAccepted;
        final Set<CodeReviewCommit> incoming;
        final RequestId submissionId;
        final SubmitType submitType;
        final NotifyHandling notifyHandling;
        final ListMultimap<RecipientType, Account.Id> accountsToNotify;
        final SubmoduleOp submoduleOp;
        final ProjectState project;
        final MergeSorter mergeSorter;
        final MergeUtil mergeUtil;
        final boolean dryrun;

        @AssistedInject
        Arguments(AccountCache accountCache, ApprovalsUtil approvalsUtil, BatchUpdate.Factory batchUpdateFactory, ChangeControl.GenericFactory changeControlFactory, ChangeMerged changeMerged, ChangeMessagesUtil cmUtil, EmailMerge.Factory mergedSenderFactory, GitRepositoryManager repoManager, LabelNormalizer labelNormalizer, MergeUtil.Factory mergeUtilFactory, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, @GerritPersonIdent PersonIdent serverIdent, ProjectCache projectCache, RebaseChangeOp.Factory rebaseFactory, OnSubmitValidators.Factory onSubmitValidatorsFactory, TagCache tagCache, InternalChangeQuery internalChangeQuery, @Assisted Branch.NameKey destBranch, @Assisted MergeOp.CommitStatus commitStatus, @Assisted CodeReviewCommit.CodeReviewRevWalk rw, @Assisted IdentifiedUser caller, @Assisted MergeTip mergeTip, @Assisted ObjectInserter inserter, @Assisted Repository repo, @Assisted RevFlag canMergeFlag, @Assisted ReviewDb db, @Assisted Set<RevCommit> alreadyAccepted, @Assisted Set<CodeReviewCommit> incoming, @Assisted RequestId submissionId, @Assisted SubmitType submitType, @Assisted NotifyHandling notifyHandling, @Assisted ListMultimap<RecipientType, Account.Id> accountsToNotify, @Assisted SubmoduleOp submoduleOp, @Assisted boolean dryrun) {
            this.accountCache = accountCache;
            this.approvalsUtil = approvalsUtil;
            this.batchUpdateFactory = batchUpdateFactory;
            this.changeControlFactory = changeControlFactory;
            this.changeMerged = changeMerged;
            this.mergedSenderFactory = mergedSenderFactory;
            this.repoManager = repoManager;
            this.cmUtil = cmUtil;
            this.labelNormalizer = labelNormalizer;
            this.patchSetInfoFactory = patchSetInfoFactory;
            this.psUtil = psUtil;
            this.projectCache = projectCache;
            this.rebaseFactory = rebaseFactory;
            this.tagCache = tagCache;
            this.internalChangeQuery = internalChangeQuery;
            this.serverIdent = serverIdent;
            this.destBranch = destBranch;
            this.commitStatus = commitStatus;
            this.rw = rw;
            this.caller = caller;
            this.mergeTip = mergeTip;
            this.inserter = inserter;
            this.repo = repo;
            this.canMergeFlag = canMergeFlag;
            this.db = db;
            this.alreadyAccepted = alreadyAccepted;
            this.incoming = incoming;
            this.submissionId = submissionId;
            this.submitType = submitType;
            this.notifyHandling = notifyHandling;
            this.accountsToNotify = accountsToNotify;
            this.submoduleOp = submoduleOp;
            this.dryrun = dryrun;
            this.project = Preconditions.checkNotNull(projectCache.get(destBranch.getParentKey()), "project not found: %s", (Object)destBranch.getParentKey());
            this.mergeSorter = new MergeSorter(rw, alreadyAccepted, canMergeFlag);
            this.mergeUtil = mergeUtilFactory.create(this.project);
            this.onSubmitValidatorsFactory = onSubmitValidatorsFactory;
        }

        static interface Factory {
            public Arguments create(SubmitType var1, Branch.NameKey var2, MergeOp.CommitStatus var3, CodeReviewCommit.CodeReviewRevWalk var4, IdentifiedUser var5, MergeTip var6, ObjectInserter var7, Repository var8, RevFlag var9, ReviewDb var10, Set<RevCommit> var11, Set<CodeReviewCommit> var12, RequestId var13, NotifyHandling var14, ListMultimap<RecipientType, Account.Id> var15, SubmoduleOp var16, boolean var17);
        }
    }
}

