/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.extensions.client.AuthType;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.DefaultInput;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountException;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.AccountManager;
import com.google.gerrit.server.account.AccountResolver;
import com.google.gerrit.server.account.AccountsCollection;
import com.google.gerrit.server.account.AuthRequest;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.config.AuthConfig;
import com.google.gerrit.server.group.GetMember;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.MemberResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Singleton
public class AddMembers
implements RestModifyView<GroupResource, Input> {
    private final Provider<IdentifiedUser> self;
    private final AccountManager accountManager;
    private final AuthType authType;
    private final AccountsCollection accounts;
    private final AccountResolver accountResolver;
    private final AccountCache accountCache;
    private final AccountLoader.Factory infoFactory;
    private final Provider<ReviewDb> db;
    private final AuditService auditService;

    @Inject
    AddMembers(Provider<IdentifiedUser> self, AccountManager accountManager, AuthConfig authConfig, AccountsCollection accounts, AccountResolver accountResolver, AccountCache accountCache, AccountLoader.Factory infoFactory, Provider<ReviewDb> db, AuditService auditService) {
        this.self = self;
        this.accountManager = accountManager;
        this.auditService = auditService;
        this.authType = authConfig.getAuthType();
        this.accounts = accounts;
        this.accountResolver = accountResolver;
        this.accountCache = accountCache;
        this.infoFactory = infoFactory;
        this.db = db;
    }

    public List<AccountInfo> apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException, IOException {
        AccountGroup internalGroup = resource.toAccountGroup();
        if (internalGroup == null) {
            throw new MethodNotAllowedException();
        }
        input = Input.init(input);
        GroupControl control = resource.getControl();
        HashSet<Account.Id> newMemberIds = new HashSet<Account.Id>();
        for (String nameOrEmailOrId : input.members) {
            Account a = this.findAccount(nameOrEmailOrId);
            if (!a.isActive()) {
                throw new UnprocessableEntityException(String.format("Account Inactive: %s", nameOrEmailOrId));
            }
            if (!control.canAddMember()) {
                throw new AuthException("Cannot add member: " + a.getFullName());
            }
            newMemberIds.add(a.getId());
        }
        this.addMembers(internalGroup.getId(), newMemberIds);
        return this.toAccountInfoList(newMemberIds);
    }

    Account findAccount(String nameOrEmailOrId) throws AuthException, UnprocessableEntityException, OrmException, IOException {
        try {
            return this.accounts.parse(nameOrEmailOrId).getAccount();
        }
        catch (UnprocessableEntityException e) {
            switch (this.authType) {
                case HTTP_LDAP: 
                case CLIENT_SSL_CERT_LDAP: 
                case LDAP: {
                    Account a;
                    if (this.accountResolver.find(this.db.get(), nameOrEmailOrId) != null || (a = this.createAccountByLdap(nameOrEmailOrId)) == null) break;
                    return a;
                }
            }
            throw e;
        }
    }

    public void addMembers(AccountGroup.Id groupId, Collection<? extends Account.Id> newMemberIds) throws OrmException, IOException {
        HashMap<Account.Id, AccountGroupMember> newAccountGroupMembers = new HashMap<Account.Id, AccountGroupMember>();
        for (Account.Id id : newMemberIds) {
            if (newAccountGroupMembers.containsKey(id)) continue;
            AccountGroupMember.Key key = new AccountGroupMember.Key(id, groupId);
            AccountGroupMember m = this.db.get().accountGroupMembers().get(key);
            if (m != null) continue;
            m = new AccountGroupMember(key);
            newAccountGroupMembers.put(m.getAccountId(), m);
        }
        if (!newAccountGroupMembers.isEmpty()) {
            this.auditService.dispatchAddAccountsToGroup(this.self.get().getAccountId(), newAccountGroupMembers.values());
            this.db.get().accountGroupMembers().insert(newAccountGroupMembers.values());
            for (AccountGroupMember accountGroupMember : newAccountGroupMembers.values()) {
                this.accountCache.evict(accountGroupMember.getAccountId());
            }
        }
    }

    private Account createAccountByLdap(String user) throws IOException {
        if (!ExternalId.isValidUsername(user)) {
            return null;
        }
        try {
            AuthRequest req = AuthRequest.forUser(user);
            req.setSkipAuthentication(true);
            return this.accountCache.get(this.accountManager.authenticate(req).getAccountId()).getAccount();
        }
        catch (AccountException e) {
            return null;
        }
    }

    private List<AccountInfo> toAccountInfoList(Set<Account.Id> accountIds) throws OrmException {
        ArrayList<AccountInfo> result = new ArrayList<AccountInfo>();
        AccountLoader loader = this.infoFactory.create(true);
        for (Account.Id accId : accountIds) {
            result.add(loader.get(accId));
        }
        loader.fill();
        return result;
    }

    @Singleton
    static class UpdateMember
    implements RestModifyView<MemberResource, PutMember.Input> {
        private final GetMember get;

        @Inject
        UpdateMember(GetMember get) {
            this.get = get;
        }

        public AccountInfo apply(MemberResource resource, PutMember.Input input) throws OrmException {
            return this.get.apply(resource);
        }
    }

    static class PutMember
    implements RestModifyView<GroupResource, Input> {
        private final AddMembers put;
        private final String id;

        PutMember(AddMembers put, String id) {
            this.put = put;
            this.id = id;
        }

        public AccountInfo apply(GroupResource resource, Input input) throws AuthException, MethodNotAllowedException, ResourceNotFoundException, OrmException, IOException {
            com.google.gerrit.server.group.AddMembers$Input in = new com.google.gerrit.server.group.AddMembers$Input();
            in._oneMember = this.id;
            try {
                List<AccountInfo> list = this.put.apply(resource, in);
                if (list.size() == 1) {
                    return list.get(0);
                }
                throw new IllegalStateException();
            }
            catch (UnprocessableEntityException e) {
                throw new ResourceNotFoundException(this.id);
            }
        }

        static class Input {
            Input() {
            }
        }
    }

    public static class Input {
        @DefaultInput
        String _oneMember;
        List<String> members;

        public static Input fromMembers(List<String> members) {
            Input in = new Input();
            in.members = members;
            return in;
        }

        static Input init(Input in) {
            if (in == null) {
                in = new Input();
            }
            if (in.members == null) {
                in.members = Lists.newArrayListWithCapacity(1);
            }
            if (!Strings.isNullOrEmpty(in._oneMember)) {
                in.members.add(in._oneMember);
            }
            return in;
        }
    }
}

