/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.collect.Lists;
import com.google.gerrit.common.data.GroupDetail;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.gerrit.server.account.AccountLoader;
import com.google.gerrit.server.account.GroupCache;
import com.google.gerrit.server.account.GroupDetailFactory;
import com.google.gerrit.server.api.accounts.AccountInfoComparator;
import com.google.gerrit.server.group.GroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.kohsuke.args4j.Option;

public class ListMembers
implements RestReadView<GroupResource> {
    private final GroupCache groupCache;
    private final GroupDetailFactory.Factory groupDetailFactory;
    private final AccountLoader accountLoader;
    @Option(name="--recursive", usage="to resolve included groups recursively")
    private boolean recursive;

    @Inject
    protected ListMembers(GroupCache groupCache, GroupDetailFactory.Factory groupDetailFactory, AccountLoader.Factory accountLoaderFactory) {
        this.groupCache = groupCache;
        this.groupDetailFactory = groupDetailFactory;
        this.accountLoader = accountLoaderFactory.create(true);
    }

    public ListMembers setRecursive(boolean recursive) {
        this.recursive = recursive;
        return this;
    }

    public List<AccountInfo> apply(GroupResource resource) throws MethodNotAllowedException, OrmException {
        if (resource.toAccountGroup() == null) {
            throw new MethodNotAllowedException();
        }
        return this.apply(resource.getGroupUUID());
    }

    public List<AccountInfo> apply(AccountGroup group) throws OrmException {
        return this.apply(group.getGroupUUID());
    }

    public List<AccountInfo> apply(AccountGroup.UUID groupId) throws OrmException {
        Map<Account.Id, AccountInfo> members = this.getMembers(groupId, new HashSet<AccountGroup.UUID>());
        ArrayList<AccountInfo> memberInfos = Lists.newArrayList(members.values());
        Collections.sort(memberInfos, AccountInfoComparator.ORDER_NULLS_FIRST);
        return memberInfos;
    }

    private Map<Account.Id, AccountInfo> getMembers(AccountGroup.UUID groupUUID, HashSet<AccountGroup.UUID> seenGroups) throws OrmException {
        GroupDetail groupDetail;
        seenGroups.add(groupUUID);
        HashMap<Account.Id, AccountInfo> members = new HashMap<Account.Id, AccountInfo>();
        AccountGroup group = this.groupCache.get(groupUUID);
        if (group == null) {
            return Collections.emptyMap();
        }
        try {
            groupDetail = this.groupDetailFactory.create(group.getId()).call();
        }
        catch (NoSuchGroupException e) {
            return Collections.emptyMap();
        }
        if (groupDetail.members != null) {
            for (AccountGroupMember m : groupDetail.members) {
                if (members.containsKey(m.getAccountId())) continue;
                members.put(m.getAccountId(), this.accountLoader.get(m.getAccountId()));
            }
        }
        if (this.recursive && groupDetail.includes != null) {
            for (AccountGroupById includedGroup : groupDetail.includes) {
                if (seenGroups.contains(includedGroup.getIncludeUUID())) continue;
                members.putAll(this.getMembers(includedGroup.getIncludeUUID(), seenGroups));
            }
        }
        this.accountLoader.fill();
        return members;
    }
}

