/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.gerrit.server.index.AutoValue_IndexConfig;
import org.eclipse.jgit.lib.Config;

@AutoValue
public abstract class IndexConfig {
    private static final int DEFAULT_MAX_TERMS = 1024;

    public static IndexConfig createDefault() {
        return IndexConfig.create(0, 0, 1024);
    }

    public static IndexConfig fromConfig(Config cfg) {
        return IndexConfig.create(cfg.getInt("index", null, "maxLimit", 0), cfg.getInt("index", null, "maxPages", 0), cfg.getInt("index", null, "maxTerms", 0));
    }

    public static IndexConfig create(int maxLimit, int maxPages, int maxTerms) {
        return new AutoValue_IndexConfig(IndexConfig.checkLimit(maxLimit, "maxLimit", Integer.MAX_VALUE), IndexConfig.checkLimit(maxPages, "maxPages", Integer.MAX_VALUE), IndexConfig.checkLimit(maxTerms, "maxTerms", 1024));
    }

    private static int checkLimit(int limit, String name, int defaultValue) {
        if (limit == 0) {
            return defaultValue;
        }
        Preconditions.checkArgument(limit > 0, "%s must be positive: %s", (Object)name, limit);
        return limit;
    }

    public abstract int maxLimit();

    public abstract int maxPages();

    public abstract int maxTerms();
}

